#include <math.h>
#include"mbed.h"
#include "locate.h"
#include"function.h"
const int speed=100;//基本速度
const float allowdegree = 0.02;//角度許容誤差
const int speedscaler = 10;//角度と速度を変換
const int minspeed = 50;//最小速度
const int allowlength=30;


void move(); //-225<right,left<225


void open_hand();
void close_hand();
void lift(); //一段持ち上げる
void open_arm();
void close_arm();



void moveto();//調節しながら目的地に直進する関数(障害物がある場合はハブを噛ませる)

void back();//15cmバックする

void turnto();

int sensor();//左右のセンサー前にものがあるかを返す

void fixto();//センサーの値から自己位置を修正する


//改善案１
void movex();







void moveto(int targetx, int targety){
    int x, y;
    float theta, phi;
    int onoff = 1;

    //よく使うかたまり
        x = coordinateX();
        y = coordinateY();
        theta = coordinateTheta();//自己位置取得
        phi = atan(double(targety - y) / double(targetx - x));//目的地への角度phi取得


    //まず目的地方面に回転。今回は必ず時計回りで位置合わせするが今後最短経路に直す
    while (1){
        x = coordinateX();
        y = coordinateY();
        theta = coordinateTheta();
        phi = atan(double(targety - y) / double(targetx - x));

        move((-1)*speed, speed);
        if (phi - allowdegree < theta&&theta< phi + allowdegree){ break; }//thetaにpiを足して逆ベクトルを判定
    }

    //角度を合わせながら直進
    while (onoff){
        x = coordinateX();
        y = coordinateY();
        theta = coordinateTheta();
        phi = atan(double(targety - y) / double(targetx - x));

        move(speed + 10 * (phi - theta), speed); //この10はradを回転数に影響させるスカラー。右輪のみで方向を調節するが、

        if (targetx - allowlength < x&&x < targetx + allowlength){
            //x座標が合ったら
            if (targety - allowlength < y&&y < targety + allowlength){
                onoff = 0;//whileから抜ける
            }
        }
    }
    //位置合わせ完了(最終的にはx,yどっちか先に合わせたい)
}



void back(){

    int x1, y1, x2, y2,distance;

    x1 = coordinateX();
    y1= coordinateY();


    move((-1)*speed, (-1) *speed);

    while (1){
        x2 = coordinateX();
        y2 = coordinateY();
        distance = (x1 - x2)*(x1 - x2) + (y1 - y2)*(y1 - y2);
        
        if (distance > 22500){ 
            move(0, 0);
            break; }
    }


}

void turnto(int targetx, int targety, int){


}

void movex(int targetx){
    int x,dx;


    while (1){
        x = coordinateX();
        dx = targetx - x;

        move(minspeed + dx*speedscaler, minspeed + dx*speedscaler);
        if ((-1)*allowlength < dx&&dx < allowlength){ break; }
    }
}


int sensor(void){
    //センサー読む

    return 0;
    //(right,left)=(off,off),(on,off),(off,on),(on,on)
    //                 0        1         2       3
}


void fixto(int targetx,int targety){//必ずy正方向からとることとする
    int onoff=1,lr=0;


    while (onoff){
    
        lr = sensor();
        switch (lr){

        case 0:
            break;
        case 1:
            move(speed , speed);
        case 2:

        case 3://一時的にナナメっているので平行にする
            move(speed, speed);
            break;
        default:
            break;
        }
        move(speed , speed);//直進に戻してセンサ判定へ

    }
}





