#include "mbed.h"
#include "move.h"
#include "locate.h"
#include "stdlib.h"
#include "math.h"
#include "servo.h"

/*************/
int rightspeed = 70;
int leftspeed = (int)(rightspeed)+7;
const int hosei_turnspeed = 14;
const int max_disorder = 3;
const float ratio = 1.0/7.0;
const int t_spe[] = {50,50};
/*************/

PwmOut M1cw(PA_11);
PwmOut M1ccw(PB_15);
PwmOut M2ccw(PB_14);
PwmOut M2cw(PB_13);

DigitalOut green (PC_2);
DigitalOut yellow(PC_3);
DigitalOut red   (PC_0);

//Serial pc(SERIAL_TX, SERIAL_RX);    //pcと通信



int tcolor;

void initmotor(int team)
{
    tcolor = team;
    if(tcolor == -1) {
        int tspeed = rightspeed;
        rightspeed  = leftspeed;
        leftspeed = tspeed;
    }
    M1cw.period_us(256);
    M1ccw.period_us(256);
    M2cw.period_us(256);
    M2ccw.period_us(256);
}

void move(int left,int right)
{
    float rightduty,leftduty;

    if(right>256)
        right=256;
    else if(right<-256)
        right=-256;

    if(left>256)
        left=256;
    else if(left<-256)
        left=-256;

    if(tcolor == -1) {
        int t =  right;
        right = left;
        left = t;
    }

    rightduty=right/256.0;
    leftduty=left/256.0;

    if(right>0) {
        M1cw.write(1-rightduty);
        M1ccw.write(1);
    } else {
        M1cw.write(1);
        M1ccw.write(1+rightduty);
    }

    if(left>0) {
        M2cw.write(1-leftduty);
        M2ccw.write(1);
    } else {
        M2cw.write(1);
        M2ccw.write(1+leftduty);
    }
}

void hosei_turn(float pt, bool cw, float rad)
{
    int np;
    if(cw) np = 1;
    else   np = -1;
    while(1) {
        update_np();
        if(pt-coordinateTheta() < np * rad - ALLOW_RAD) {
            move(-hosei_turnspeed, hosei_turnspeed);
        } else if(pt-coordinateTheta() > np * rad + ALLOW_RAD) {
            move(hosei_turnspeed, -hosei_turnspeed);
        } else {
            move(0,0);
            return;
        }
    }

}

void turnrad(float rad)
{
    green = 1;

    update_np();

    int np;
    if(coordinateTheta() > rad) np = 1;
    else if(coordinateTheta() < rad) np = -1;
    else return;

    //move((-np)*rightspeed, (np)*leftspeed);
    move((-np) * t_spe[0], (np) * t_spe[1]);
    while(1) {
        update_np();\
        if(rad - 0.2 < coordinateTheta() && coordinateTheta() < rad + 0.2) {
            move(0,0);
            break;
        }
    }

    hosei_turn(0, false, rad);
    wait(0.2);
    hosei_turn(0, false, rad);
    wait(0.2);
    green = 0;
}


void turnrad_ccw(float rad, int team)
{
    if(team == 0) {
        turnrad_cw(rad, 1);
        return;
    }

    green = 1;

    update();

    //move(rightspeed, -leftspeed);
    move(t_spe[0], -t_spe[1]);
    
    while(1) {


        update();
        if(rad - 0.2 < coordinateTheta() && coordinateTheta() < rad + 0.2) {
            move(0,0);
            break;
        }
    }

    hosei_turn(0, false, rad);
    wait(0.2);
    hosei_turn(0, false, rad);
    wait(0.2);
    green = 0;
}

void turnrad_cw(float rad, int team)
{
    if(team == 0) {
        turnrad_ccw(rad, 1);
        return;
    }

    green = 1;

    update();

    //move((-1)*rightspeed, leftspeed);
    move(-t_spe[0], t_spe[1]);
    while(1) {
        update();
        if(rad - 0.2 < coordinateTheta() && coordinateTheta() < rad + 0.2) {
            move(0,0);
            break;
        }
    }

    hosei_turn(0, false, rad);
    wait(0.2);
    hosei_turn(0, false, rad);
    wait(0.2);
    green = 0;
}



void movelength(int length)
{
    int px,py,pt;
    update();
    px=coordinateX();
    py=coordinateY();
    pt=coordinateTheta();

    move(rightspeed,leftspeed);
    while(1) {

        update();
        //pc.printf("dx:%d, dy:%d, l:%d x:%d y:%d t:%f\n\r",px-coordinateX(),py-coordinateY(),length,coordinateX(),coordinateY(), coordinateTheta());
        if(((px-coordinateX())*(px-coordinateX())+(py-coordinateY())*(py-coordinateY()))>length*length) {
            break;
        }

    }
    move(-32,-30);
    wait(0.05);
    move(0,0);
    
}


void movelengthnoprintf(int length)
{
    int px,py,pt;
    update();
    px=coordinateX();
    py=coordinateY();
    pt=coordinateTheta();

    move(rightspeed,leftspeed);
    while(1) {

        update_np();
        if(((px-coordinateX())*(px-coordinateX())+(py-coordinateY())*(py-coordinateY()))>length*length) {
            break;
        }

    }
    move(0,0);
}


void pmove(int x, int y)
{
    yellow = 1;

    float k = 1.0;//ズレ(mm)を回転数に反映させる比例定数
    int   k_theta = 25;//ズレ(rad)を回転数に反映させる比例定数

    int length, dx, dy;
    int *d_length, *disorder;
    int absd_length;
    float dtheta, ptheta;
    float daikei;

    int direction;

    if(abs(x - coordinateX()) > abs(y - coordinateY())) {
        y = coordinateY();
        direction = X_PLUS;
        length = abs(x - coordinateX());
        d_length = &dx;
        disorder = &dy;
    } else {
        x = coordinateX();
        direction = Y_PLUS;
        length = abs(y - coordinateY());
        d_length = &dy;
        disorder = &dx;
    }

    update();
    dx = x - coordinateX();
    dy = y - coordinateY();

    if(*d_length < 0)   //x,y減少方向なら、*d_length<0
        direction *= -1;

    switch(direction) {
        case X_PLUS:
            ptheta = 0;
            break;
        case Y_PLUS:
            ptheta = PI/2;
            break;
        case X_MINUS:
            k *= -1;
            ptheta = PI;
            break;
        case Y_MINUS:
            k *= -1;
            ptheta = -PI/2;
            break;
        default:
            return;
    }

    ptheta += nearPi(coordinateTheta() - ptheta);

    turnrad(ptheta);

    if(length == 0) return;

    int i = 0;

    while(1) {
        update();
        dx = x - coordinateX();
        dy = y - coordinateY();
        dtheta = coordinateTheta() - ptheta;

        if(*disorder>max_disorder) {
            *disorder = max_disorder;
        } else if(*disorder<-max_disorder) {
            *disorder = -max_disorder;
        }

        absd_length = abs(*d_length);


        if(i++ < 5) {
            daikei = i/5;
        } else if(absd_length < 300) {
            daikei = absd_length / 300.0;
        } else
            daikei = 1;

        move(daikei * (rightspeed*(1-ratio) - k*(*disorder) - k_theta*dtheta) + rightspeed*ratio,
             daikei * (leftspeed *(1-ratio) + k*(*disorder) + k_theta*dtheta) + leftspeed *ratio);

        //pc.printf("d_length:%d disorder:%d rs:%f ls:%f daikei:%f\n\r", *d_length, *disorder, k*(*disorder) - k_theta*dtheta, -k*(*disorder) + k_theta*dtheta, daikei);
        if((direction > 0 && *d_length <= 0) || (direction < 0 &&  *d_length >= 0)) {
            move(0, 0);
            break;
        }

    }

    wait(0.2);

    yellow = 0;
}

void pmove2(int x, int y)
{
    yellow = 0.8;
    red=0;
    float k = 1.0;//ズレ(mm)を回転数に反映させる比例定数
    int   k_theta = 25;//ズレ(rad)を回転数に反映させる比例定数

    double length;
    int d_length, disorder;
    float dtheta, ptheta;
    float daikei;

    length = sqrt(pow((double)(x - coordinateX()), 2) + pow((double)(y - coordinateY()), 2)) - 10;

    if(length == 0) {
        red=1;
        return;
    }

    ptheta = giveatan(x, y);

    ptheta += nearPi(coordinateTheta() - ptheta);

    //pc.printf("pt:%f", ptheta);
    turnrad(ptheta);

    virtual_setup();

    int i = 0;

    while(1) {
        update();
        virtual_update();

        d_length = length - virtual_coordinateX();
        disorder = virtual_coordinateY();
        dtheta = virtual_coordinateTheta();

        if(disorder>max_disorder) {
            disorder = max_disorder;
        } else if(disorder<-max_disorder) {
            disorder = -max_disorder;
        }

        if(i++ < 5) {
            daikei = i/5;
        } else if(d_length < 300) {
            daikei = d_length / 300.0;
        } else
            daikei = 1;

        move(daikei * (rightspeed*(1-ratio) + k*disorder - k_theta*dtheta) + rightspeed*ratio + k*disorder - k_theta*dtheta,
             daikei * (leftspeed *(1-ratio) - k*disorder + k_theta*dtheta) + leftspeed *ratio - k*disorder + k_theta*dtheta);


        //printf("length:%f, d_length:%d, vx:%d, vy:%d\n\r", length, d_length, virtual_coordinateX(), virtual_coordinateY());
        if(d_length <= 0) {
            move(0, 0);
            break;
        }

    }

    wait(0.2);

    yellow = 0;
    red = 0;
}

void back300()
{
    red = 1;

    float k = 0.9;
    int length, px, py, dx, dy;

    update();

    px = coordinateX();
    py = coordinateY();

    length = 300;

    while(1) {
        update_np();
        dx = coordinateX() - px;
        dy = coordinateY() - py;

        if(dy>max_disorder) {
            dy = max_disorder;
        } else if(dy<-max_disorder) {
            dy = -max_disorder;
        }

        move(-(30 + k*dy), -(32 - k*dy));

        if(dx>length) {
            move(0, 0);
            break;
        }
    }

    wait(0.2);

    red = 0;
}


void nxback300()
{
    red = 1;

    float k = 0.9;
    int length, px, py, dx, dy;

    update();

    px = coordinateX();
    py = coordinateY();

    length = 300;

    turnrad(nearPi(coordinateTheta()));

    while(1) {
        update_np();
        dx = coordinateX() - px;
        dy = coordinateY() - py;

        if(dy>max_disorder) {
            dy = max_disorder;
        } else if(dy<-max_disorder) {
            dy = -max_disorder;
        }

        move(-(30 - k*dy), -(32 + k*dy));

        if(abs(dx)>length) {
            move(0, 0);
            break;
        }
    }

    wait(0.2);

    red = 0;
}

void pyback300(int team)
{
    if(team == 0) {
        nyback300(1);
        return;
    }

    red = 1;

    float k = 0.9;
    int length, px, py, dx, dy;

    update();

    px = coordinateX();
    py = coordinateY();

    length = 300;

    turnrad(PI/2 + nearPi(coordinateTheta() - PI/2));

    while(1) {
        update_np();
        dx = coordinateX() - px;
        dy = coordinateY() - py;

        if(dx>max_disorder) {
            dx = max_disorder;
        } else if(dx<-max_disorder) {
            dx = -max_disorder;
        }

        move(-(30 - k*dx), -(32 + k*dx));

        if(dy>length) {
            move(0, 0);
            break;
        }

    }

    wait(0.2);

    red    = 0;
}

void nyback300(int team)
{
    if(team == 0) {
        pyback300(1);
        return;
    }

    red = 1;

    float k = 0.9;
    int length, px, py, dx, dy;

    update();

    px = coordinateX();
    py = coordinateY();

    length = 300;

    turnrad(-PI/2 + nearPi(coordinateTheta() + PI/2));

    while(1) {
        update();//npの部分を変更した
        dx = coordinateX() - px;
        dy = coordinateY() - py;

        if(dx>max_disorder) {
            dx = max_disorder;
        } else if(dx<-max_disorder) {
            dx = -max_disorder;
        }

        move(-(30 - k*dx), -(32 + k*dx));

        if(abs(dy)>length) {
            move(0, 0);
            break;
        }
    }

    wait(0.2);

    red = 0;
}

float nearPi(float rad)
{
    float npi  = 0;

    while(1) {
        if(rad > npi + PI)
            npi += 2*PI;
        else if(rad < npi - PI)
            npi -= 2*PI;
        else
            return npi;
    }
}

float giveatan(int targetx,int targety)
{
    int x,y;
    float phi;
    update();
    x = coordinateX();
    y = coordinateY();

    if(targetx - x == 0) {
        if(targety - y > 0)
            return PI/2;
        else if(targety - y < 0)
            return -PI/2;
        else
            return 0;
    }

    phi = atan(double(targety - y) / double(targetx - x));//目的地への角度phi取得
    if(targetx - x < 0) {
        if(targety  - y > 0)
            phi += PI;
        else if(targety - y < 0)
            phi -= PI;
    }

    return phi;
}

void commandMove(int cx0 = 17, int cx1 = 17, int cx2 = 17)
{
    if(cx0 >= 10) {
        pmove2(150, 900);
        return;
    }
    yokoMove(cx0 * 100 + 300, true);
    close_hand();
    wait(0.3);
    lift();
    open_hand();
    if(cx1 >= 10) {
        pmove2(150, 900);
        return;
    }
    yokoMove(cx1 * 100 + 300, false);
    close_hand();
    wait(0.3);
    lift();
    open_hand();
    if(cx2 >= 10) {
        pmove2(150, 900);
        return;
    }
    yokoMove(cx2 * 100 + 300, true);
    pmove2(150, 900);
}

void commandMoveEnemy(int cx0 = 17, int cx1 = 17, int cx2 = 17)
{
    pmove2(1200, 1200);
    if(cx0 >= 10) return;
    yokoMove(-cx0 * 100 + 2700, false);
    close_hand();
    wait(0.3);
    lift();
    open_hand();
    if(cx1 >= 10) return;
    yokoMove(-cx1 * 100 + 2700, true);
    pmove2(150, 1100);
}

void yokoMove(int cx, bool Left)
{
    if(Left) {
        pmove2(cx, 100);
        pmove(cx, 1100);
    } else {
        pmove2(cx, 1100);
        pmove(cx, 100);
    }
}

void moveTriangle(int c0, int c1, int c2, int c3)
{
    pmove2(c0  * 100, c1 * 100);
    pmove2(c2 * 100, c3 * 100);
    pmove2(0, 900);   
}