#ifndef Locate_H
#define Locate_H
 
#include <math.h>
#include "Encoder.h"
 
 
 //Serial pc(SERIAL_TX, SERIAL_RX);
/****************定数定義***************************/
 
#define OUTERRING_D     140             //外輪間距離(mm)
#define INNERRING_D     136             //内輪間距離(mm)
#define PI              3.14159         //π
#define RESOLUSION      200             //P/R(分解能)
#define DIAMETER        32.05          //タイヤの直径(mm)
#define ROUND_HOSEI     1.0367            //角度のズレを補正.038
#define HOSEI           1.00
// エンコーダの１ステップあたりの距離;(mm)
#define LOCATE_STEP     (DIAMETER*PI / RESOLUSION * HOSEI)                 
//タイヤ間距離(mm) 
#define TIRE_DISTANCE   ((OUTERRING_D + INNERRING_D) / 2)          
//機体が１回転するために必要なステップ数の”逆数”
#define ROUND           ((PI * DIAMETER / (RESOLUSION * TIRE_DISTANCE)) * ROUND_HOSEI)   
 
/****************************************************************/
 
 
 
 
/********以下関数宣言*****************/
 
//最初に一回だけ行う
void  setup(int team);
 
//setupの初期位置指定版
void setup(int tx, int ty);
 
//位置情報を更新する。r,lはエンコーダから
void  update();
 
//update()のprintfなし版
void update_np();
 
//xをmm換算して整数値として返す
int coordinateX(); 
 
//yをmm換算して整数値として返す
int coordinateY();
 
//thetaを返す
float coordinateTheta();  
 
//encorderの値を回転数に変換。update内部で使われる
int convert_enc_count(int16_t pulse, int8_t direction);
 
//x, y, thetaを0にする
void erase();
 
//仮想
void virtual_setup();
 
void virtual_update();
 
int virtual_coordinateX();
 
int virtual_coordinateY();
 
float virtual_coordinateTheta();
/**********************************/
#endif
 
 
 
 
 
/**************Encoderライブラリで使う定義**************************/
 
#ifdef TARGET_STM32F3
#define __HAL_TIM_GET_COUNTER(__HANDLE__) ((__HANDLE__)->Instance->CNT)
#define __HAL_TIM_IS_TIM_COUNTING_DOWN(__HANDLE__)            (((__HANDLE__)->Instance->CR1 &(TIM_CR1_DIR)) == (TIM_CR1_DIR))
#endif
 
/***************************************************************/
            