#include "mbed.h"
#include <stdint.h>

I2C i2c(PB_9, PB_8);
Serial usb_serial(SERIAL_TX, SERIAL_RX);

#define ADDR_FSR0 0x90
#define ADDR_FSR1 0x29
#define ADDR_PZT 0x96

#define AD1115_CONFIG 0x01

#define PZT0 0x10
#define PZT1 0x20

int main() {
    int16_t raw_data, config;
    double voltage0, voltage1;
    usb_serial.baud(230400);
    i2c.frequency(200000);
    char rxbuf[10];
    char txbuf[10];
        // set mux to pzt0
        config = 0x84E3 | PZT0;
        txbuf[0] = AD1115_CONFIG;
        txbuf[1] = config >> 8;
        txbuf[2] = config & 0xFF;
        i2c.write(ADDR_PZT, txbuf, 3);
        txbuf[0] = 0;
        i2c.write(ADDR_PZT, txbuf, 1);
    while(1) {
        i2c.read(ADDR_PZT, rxbuf, 2);
        raw_data = (rxbuf[0] << 8) | rxbuf[1];
        voltage0 = 5.0/65535.0 * (double)raw_data;
        usb_serial.printf("%f\r\n", voltage0);
        wait_ms(1);
    }
}
