/*all variables used----------------
In one Frame sequence - Flag -> Packet -> CRC
flag
{0x7E(8)}
Packet - either Short or Long
{
psc-Packet Sequence Count(8)
apid-Application Id(2)
lfb-Last Frame Bit(1)
los-Long or Short(1)
aon-Abort on Nack(1)
spr-Spare(2)
ack-Acknoledge(1)
st-Service type(4)
sst-Service Sub Type(4)
appdata-Application Data(48 or 1040)
}
crc-Frame Check Sequence(16)

There are totally 12 bytes for short frame
and 136 for long frame
Short frame-12
{
    bytes-names
    1-Flag
    1-PSC
    1-APID(2)+LFB(1)+LoS(1)+AoN(1)+Spr(2)+Ack(1)
    1-ST(4)+SST(4)
    6-Appdata
    2-CRC
}
Long frame-136
{
    bytes-names
    1-Flag
    1-PSC
    1-APID(2)+LFB(1)+LoS(1)+AoN(1)+Spr(2)+Ack(1)
    1-ST(4)+SST(4)
    130-Appdata
    2-CRC
}
------------------------------------*/
#include "mbed.h"

Serial pc(USBTX,USBRX);

int main()
{
    char data[2],flag,psc,apid,lfb,los,aon,spr,ack,st,sst,crc[2],sappdata[6],lappdata[130]; //All variable used 
    flag=pc.getc();
    psc=pc.getc();
    data[0]=pc.getc(); //Data[0] contains APID,LFB,LoS,AoN,Spr and Ack
    data[1]=pc.getc(); //Data[1] contains ST and SST
    apid=(data[0]&0xC0)>>6;
    lfb=(data[0]&0x20)>>5;
    los=(data[0]&0x10)>>4;
    aon=(data[0]&0x08)>>3;
    spr=(data[0]&0x06)>>1;
    ack=(data[0]&0x01);
    st=(data[1]&0xF0)>>4;
    sst=(data[1]&0x0F);
    if(int(los)==0) {
        for(int i=0; i<6; i++) {
            sappdata[i]=pc.getc();
        }
    } 
    else {
        for(int i=0; i<130; i++) {
            lappdata[i]=pc.getc();
        }
    }

        crc[0]=pc.getc();
        crc[1]=pc.getc();

}