/*all variables used----------------
In one Frame sequence - Flag -> Packet -> CRC
flag
{0x7E(8)}
Packet - either Short or Long
{
psc-Packet Sequence Count(8)
apid-Application Id(2)
lfb-Last Frame Bit(1)
los-Long or Short(1)
aon-Abort on Nack(1)
spr-Spare(2)
ack-Acknoledge(1)
st-Service type(4)
sst-Service Sub Type(4)
appdata-Application Data(48 or 1040)
}
crc-Frame Check Sequence(16)

There are totally 12 bytes for short frame
and 136 for long frame
Short frame-12
{
    bytes-names
    1-Flag
    1-PSC
    1-APID(2)+LFB(1)+LoS(1)+AoN(1)+Spr(2)+Ack(1)
    1-ST(4)+SST(4)
    6-Appdata
    2-CRC
}
Long frame-136
{
    bytes-names
    1-Flag
    1-PSC
    1-APID(2)+LFB(1)+LoS(1)+AoN(1)+Spr(2)+Ack(1)
    1-ST(4)+SST(4)
    130-Appdata
    2-CRC
}

pid-process id
sst-state id
------------------------------------*/
#include "mbed.h"

Serial pc(USBTX,USBRX);

uint8_t tmp2[13],tmp1[130];
uint8_t lmb_tm[128],crc_tm[2];
uint8_t fsc_fhp_tm,motp_tm[127];
uint8_t tclp1_tm[9],tclp2_tm[9];
uint8_t crc1_tm[2],crc2_tm[2];
uint8_t tmid1_spr_tm=0xA0,tc_ec_tm,tc_stat_tm,psc_tc_tm[8];
uint8_t tmid2_spr_tm=0xB0,tc_psc_tm,tm_psc_tm,ackcode_tm;
uint8_t tmid3_spr_tm=0xC0,smb_tm[7];
uint8_t tmid4_spr_tm=0xD0,fms[8];
   
int main()
{
    uint8_t apid_size,psc,apid,los,st,sst; //All variable used 
    pc.scanf("%x",&psc);
    pc.scanf("%x",&apid_size); //Data[0] contains APID,LFB,LoS,AoN,Spr and Ack
    apid=(apid_size&0xC0)>>6;
    los=(apid_size&0x10)>>4;
        switch(apid)
        {
             case 1:
             {
                    printf("BAE\n");
                   uint8_t p_i2c_bae[los*124+11];
                   p_i2c_bae[0]=psc;
                   p_i2c_bae[1]=apid_size;
                   pc.scanf("%x",&p_i2c_bae[2]);
                   for(int i=3;i<(los*124+11);i++){
                      pc.scanf("%x",&p_i2c_bae[i]);
                   }
                   printf("inform BAE about TC using I2C\n");
                   printf("send the packet + CRC to the BAE after receving i2c signal from BAE\n");
            break;
            }
            case 3:
            {
                   printf("SPEED\n");
                   uint8_t p_i2c_speed[los*124+11];
                   p_i2c_speed[0]=psc;
                   p_i2c_speed[1]=apid_size;
                   pc.scanf("%x",&p_i2c_speed[2]); //services contains ST and SST
                   for(int i=3;i<(los*124+11);i++){
                      pc.scanf("%x",&p_i2c_speed[i]);
                   }
                   printf("inform PL about TC using I2C\n");
                   printf("send the packet + CRC to the PL after receving i2c signal from PL\n");
            break;
            }
            case 2:
            {
                   printf("CDMS\n");
                   uint8_t services,appdata[los*124+6],crc[2];
                   pc.scanf("%x",&services); //services contains ST and SST
                   for(int i=3;i<(los*124+6);i++){
                      pc.scanf("%x",&appdata[i]);
                   }
                   pc.scanf("%x",&crc[0]);
                   pc.scanf("%x",&crc[1]);
                   st=(services&0xF0)>>4;
                   sst=(services&0x0F);
                   switch(st){
                        case 6:
                        {
                               printf("memory management system\n");
                               switch(sst){
                                    case 1:
                                    {
                                           printf("READ FROM MEMORY\n");
                                           if(appdata[0]==2){             //appdata[0] is pid                     
                                            printf("RD_L_FLASH1\n");
                                              for(int i=0;i<128;i++){
                                                tmp1[i]=lmb_tm[i-1];
                                              }
                                              for(int i=128;i<130;i++){
                                                tmp1[i]=crc_tm[i-128];
                                              }
                                           }
                                           else if ((appdata[0]&0xF0)==0x10){
                                            printf("RD_L_FLASH2\n");
                                              for(int i=0;i<128;i++){
                                                tmp1[i]=lmb_tm[i-1];
                                              }
                                              for(int i=128;i<130;i++){
                                                tmp1[i]=crc_tm[i-128];
                                              }
                                           }
                                           else if (appdata[0]==0x22){
                                            printf("RD_S_FLASH1\n");
                                            tmp2[0]=tmid3_spr_tm;
                                            tmp2[1]=tc_psc_tm;
                                            tmp2[2]=tm_psc_tm;
                                            for(int i=4;i<11;i++){
                                                  tmp2[i]=smb_tm[i-4];
                                                }
                                              for(int i=11;i<13;i++){
                                                  tmp2[i]=crc_tm[i-11];
                                                }
                                           }
                                           else if ((appdata[0]&0xF0)==0x30){
                                            printf("RD_S_FLASH2\n");
                                            tmp2[0]=tmid3_spr_tm;
                                            tmp2[1]=tc_psc_tm;
                                            tmp2[2]=tm_psc_tm;
                                            for(int i=3;i<11;i++){
                                                  tmp2[i]=smb_tm[i-3];
                                                }
                                              for(int i=11;i<13;i++){
                                                  tmp2[i]=crc_tm[i-11];
                                                }
                                           }
                                           else if (appdata[0]==0x42){
                                            printf("RD_L_RAM1\n");
                                              for(int i=0;i<128;i++){
                                                tmp1[i]=lmb_tm[i-1];
                                              }
                                              for(int i=128;i<130;i++){
                                                tmp1[i]=crc_tm[i-128];
                                              }
                                           }
                                           else if ((appdata[0]&0xF0)==0x50){
                                            printf("RD_L_RAM2\n");
                                              for(int i=0;i<128;i++){
                                                tmp1[i]=lmb_tm[i-1];
                                              }
                                              for(int i=128;i<130;i++){
                                                tmp1[i]=crc_tm[i-128];
                                              }
                                           }
                                           else if (appdata[0]==0x62){
                                            printf("RD_S_RAM\n");
                                            tmp2[0]=tmid3_spr_tm;
                                            tmp2[1]=tc_psc_tm;
                                            tmp2[2]=tm_psc_tm;
                                            for(int i=3;i<11;i++){
                                                  tmp2[i]=smb_tm[i-3];
                                                }
                                              for(int i=11;i<13;i++){
                                                  tmp2[i]=crc_tm[i-11];
                                                }
                                           }
                                           else if ((appdata[0]&0xF0)==0x70){
                                            printf("RD_S_RAM2\n");
                                            tmp2[0]=tmid3_spr_tm;
                                            tmp2[1]=tc_psc_tm;
                                            tmp2[2]=tm_psc_tm;
                                            for(int i=3;i<11;i++){
                                                  tmp2[i]=smb_tm[i-3];
                                                }
                                              for(int i=11;i<13;i++){
                                                  tmp2[i]=crc_tm[i-11];
                                                }
                                           }
                                    break;
                                    }
                                    case 5:
                                    {
                                           printf("WRITE ON MEMORY\n");
                                           switch(appdata[0]){
                                                case 0:printf("WR_S_FLASH\n");
                                                break;
                                                case 1:printf("WR_S_RAM\n");
                                                break;
                                                case 16:printf("WR_L_FLASH\n");
                                                break;
                                                case 17:printf("WR_L_RAM\n");
                                                break;
                                           }
                                    break;
                                    }
                                    case 6:
                                    {
                                           printf("WRITE FROM ONE MEMORY TO ANOTHER\n");
                                           switch(appdata[0]){
                                                case 0:printf("WR_S_FLASH\n");
                                                break;
                                                case 1:printf("WR_S_RAM\n");
                                                break;
                                                case 16:printf("WR_L_FLASH\n");
                                                break;
                                                case 17:printf("WR_L_RAM\n");
                                                break;
                                           }
                                    break;
                                    }
                                    case 9:
                                    {
                                           printf("SEND CRC OF FLASH MEMORY\n");
                                           if(appdata[0]==2){
                                            printf("GET_FLASH_CRC\n");
                                          for(int i=0;i<2;i++){
                                                tmp1[i]=crc1_tm[i];
                                              }
                                            for(int i=2;i<4;i++){
                                                tmp1[i]=crc2_tm[i-2];
                                              }
                                            for(int i=128;i<130;i++){
                                                tmp1[i]=crc_tm[i-128];
                                              }
                                           }
                                    break;
                                    }
                                }
                        break;
                        }
                        case 8:
                        {
                               printf("FUNCTION MANAGEMENT SERVICE\n");
                               if(sst==1){
                                if((appdata[0]&0xF0)==0x00){
                                    printf("RUN_PRCS\n");
                                    switch(appdata[0]){
                                        case 1:printf("P_PL_INIT\n");
                                        break;
                                        case 2:printf("P_PL_MNGR\n");
                                        break;
                                        case 3:printf("P_COM_INIT\n");
                                        break;
                                        case 4:printf("P_CDMS_HK_MNGR\n");
                                        break;
                                    }
                                }
                                else if((appdata[0]&0xF0)==0x10){
                                    printf("PWR_SWCH\n");
                                }
                                else if((appdata[0]&0xF0)==0x20){
                                    printf("PWR_RST\n");
                                }
                                else if((appdata[0]&0xF0)==0xE0){
                                    printf("RD_RTC\n");
                                    tmp2[0]=tmid4_spr_tm;
                                    tmp2[1]=tc_psc_tm;
                                    tmp2[2]=tm_psc_tm;
                                    for(int i=3;i<11;i++){
                                          tmp2[i]=fms[i-3];
                                        }
                                      for(int i=11;i<13;i++){
                                          tmp2[i]=crc_tm[i-11];
                                        }
                                }
                                else if((appdata[0]&0xF0)==0xF0){
                                    printf("SD_MNGR\n");
                                    tmp2[0]=tmid4_spr_tm;
                                    tmp2[1]=tc_psc_tm;
                                    tmp2[2]=tm_psc_tm;
                                    for(int i=3;i<11;i++){
                                          tmp2[i]=fms[i-3];
                                        }
                                      for(int i=11;i<13;i++){
                                          tmp2[i]=crc_tm[i-11];
                                        }
                                }
                               }
                        break;
                        }
                        case 7:
                        {
                               printf("PAYLOAD MANAGEMENT SERVICE\n");
                               switch(sst){
                                    case 1:printf("INSERT PL SCHEDULE\n");
                                    break;
                                    case 2:printf("DELETE PL SCHEDULE\n");
                                    break; 
                               }
                        break;
                        }
                        case 11:
                        {
                                printf("ONBOARD OPERATIONS SCHEDULING SERVICE\n");
                                switch(sst){
                                    case 1:
                                    {
                                           printf("DISABLE RELEASE OF TCs\n");
                                           tmp2[0]=tmid1_spr_tm;
                                           tmp2[1]=tc_ec_tm;
                                           tmp2[2]=tc_stat_tm;
                                           for(int i=3;i<11;i++){
                                                tmp2[i]=psc_tc_tm[i-3];
                                               }
                                             for(int i=11;i<13;i++){
                                                tmp2[i]=crc_tm[i-11];
                                              }
                                    break;
                                    }
                                    case 2:
                                    {
                                      printf("ENABLE RELEASE OF TCs\n");
                                    break;
                                    }
                                    case 5:
                                    {
                                      printf("DELETE TELECOMMANDS\n");
                                    break;
                                    }
                                    case 6:
                                    {
                                      printf("REPORT TC LIST IN DETAILED FORM\n");
                                           for(int i=0;i<9;i++){
                                              tmp1[i]=tclp1_tm[i];
                                               }
                                           for(int i=9;i<18;i++){
                                              tmp1[i]=tclp2_tm[i-9];
                                              }
                                           for(int i=128;i<130;i++){
                                              tmp1[i]=crc_tm[i-128];
                                            }
                                    break;
                                    }
                                    case 8:
                                    {
                                           printf("REPORT STATUS OF TC LIST\n");
                                           tmp2[0]=tmid1_spr_tm;
                                           tmp2[1]=tc_ec_tm;
                                           tmp2[2]=tc_stat_tm;
                                           for(int i=3;i<11;i++){
                                                tmp2[i]=psc_tc_tm[i-3];
                                               }
                                             for(int i=11;i<13;i++){
                                                tmp2[i]=crc_tm[i-11];
                                              }
                                    break;
                                    }
                                    case 15:
                                    {
                                            printf("REPORT STATUS OF LAST UNEXECUTED TC\n");
                                            tmp2[0]=tmid2_spr_tm;
                                            tmp2[1]=tc_psc_tm;
                                            tmp2[2]=tm_psc_tm;
                                            tmp2[3]=ackcode_tm;
                                            for(int i=3;i<11;i++){
                                                  tmp2[i]=0x00;
                                                }
                                              for(int i=11;i<13;i++){
                                                  tmp2[i]=crc_tm[i-11];
                                                }
                                    break;
                                    }
                                }
                        break;
                        }
                        case 13:
                        {
                               printf("LARGE DATA TRANSFER\n");
                        break;
                        }
                        case 15:
                        {
                                printf("ONBOARD STORAGE AND RETRIEVAL SERVICE\n");
                                switch(sst){
                                    case 0:
                                    {
                                           printf("SCF\n");
                                           tmp1[0]=fsc_fhp_tm;
                                           for(int i=1;i<128;i++){
                                             tmp1[i]=motp_tm[i-1];
                                           }
                                           for(int i=128;i<130;i++){
                                             tmp1[i]=crc_tm[i-128];
                                           }
                                    break;
                                    }
                                    case 1:
                                    {
                                           printf("SFF-AT\n");
                                           tmp1[0]=fsc_fhp_tm;
                                           for(int i=1;i<128;i++){
                                             tmp1[i]=motp_tm[i-1];
                                           }
                                           for(int i=128;i<130;i++){
                                             tmp1[i]=crc_tm[i-128];
                                           }
                                    break;
                                    }
                                    case 2:
                                    {
                                           printf("SFF-BT\n");
                                           tmp1[0]=fsc_fhp_tm;
                                           for(int i=1;i<128;i++){
                                             tmp1[i]=motp_tm[i-1];
                                           }
                                           for(int i=128;i<130;i++){
                                             tmp1[i]=crc_tm[i-128];
                                           }
                                    break;
                                    }
                                    case 3:
                                    {
                                           printf("LOG\n");
                                           tmp1[0]=fsc_fhp_tm;
                                           for(int i=1;i<128;i++){
                                             tmp1[i]=motp_tm[i-1];
                                           }
                                           for(int i=128;i<130;i++){
                                             tmp1[i]=crc_tm[i-128];
                                           }
                                    break;
                                    }
                                    case 4:
                                    {
                                           printf("HK_ARCHIVE\n");
                                           tmp1[0]=fsc_fhp_tm;
                                           for(int i=1;i<128;i++){
                                             tmp1[i]=motp_tm[i-1];
                                           }
                                           for(int i=128;i<130;i++){
                                             tmp1[i]=crc_tm[i-128];
                                           }
                                    break;
                                    }
                                } 
                        break;
                        }
                   }
            break;
            }
        }

}
