#include "mbed.h"
#include "cdms_rtc.h"

SPI rtc_spi(PTE1, PTE3, PTE2);      // MOSI,MISO, CLOCK microcontroller(in order)                                                       
DigitalOut rtc_cs(PTE29);         //Slave Select pin 

void FCTN_CDMS_INIT_RTC()
{
    rtc_cs=1;
    rtc_spi.format(8,0);
    rtc_spi.frequency(1000000);
    //clearing the halt bit 
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x8C);
    rtc_spi.write(0x00);
     
    //clearing the OF bit 
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x8F);
    rtc_spi.write(0x00);
     
    //century bits
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x80|0x03);
    rtc_spi.write(0x00);
 
    //Kick starting the oscillator 
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x81); //register address with write flag
    rtc_spi.write(0x80);//enabling stop bit in the seconds register
 
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x81);
    rtc_spi.write(0x00);//disabling the stop bit to restart the oscillator 
 
    
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x80); 
    rtc_spi.write(0x01); // set milliseconds value to 00
    rtc_cs=1;
 
    rtc_cs=0;
    rtc_spi.write(0x81); 
    rtc_spi.write(0x01); //set seconds value to 00
    rtc_cs=1;
 
    rtc_cs=0;
    rtc_spi.write(0x82); 
    rtc_spi.write(0x01);//set minutes value to 00
    rtc_cs=1;
 
    rtc_cs=0;
    rtc_spi.write(0x83); 
    rtc_spi.write(0x23); //set the hours to 01
    rtc_cs=1;
    
    rtc_cs=0;
    rtc_spi.write(0x84); 
    rtc_spi.write(0x01); //set day of the week to 01
    rtc_cs=1;
    
    rtc_cs=0;
    rtc_spi.write(0x85); 
    rtc_spi.write(0x31); //set date of the month to 01
    rtc_cs=1;
    
    rtc_cs=0;
    rtc_spi.write(0x86); 
    rtc_spi.write(0x12); //set month to 01
    rtc_cs=1;
    
    rtc_cs=0;
    rtc_spi.write(0x87); 
    rtc_spi.write(0x01); //set year to 00(2000)
    rtc_cs=1;
    printf("\n\r rtc initalised \n");
}
 
uint64_t FCTN_CDMS_RD_RTC()
{    
    uint8_t response;
    printf("\n\r Entered rtc\n");
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x00); //reading milliseconds register
    response = rtc_spi.write(0x00); // read the value by sending dummy byte
    uint8_t centiseconds =  (uint8_t(response&0xF0)>>4)*10+uint8_t(response&0x0F)*1;
    
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x01); //reading seconds register
    response =rtc_spi.write(0x01);
    uint8_t seconds =  ((response&0x70)>>4)*10+(response&0x0F)*1;
    
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x02); //reading minutes register
    response =rtc_spi.write(0x01);
    uint8_t minutes =  ((response&0xF0)>>4)*10+(response&0x0F)*1;
    
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x03); //reading hours register
    response=rtc_spi.write(0x01);
    uint8_t hours =  ((response&0x30)>>4)*10+(response&0x0F)*1;
    
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x04); //reading day's  register
    uint8_t day =rtc_spi.write(0x01);
    
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x05); //reading date register
    response =rtc_spi.write(0x01);
    uint8_t date =  ((response&0x30)>>4)*10+(response&0x0F)*1;
    
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x06); //reading month registe
    response =rtc_spi.write(0x01);
    uint8_t month =  ((response&0x10)>>4)*10+(response&0x0F)*1;
    
    rtc_cs=1;
    rtc_cs=0;
    rtc_spi.write(0x07); //reading year's registe
    response =rtc_spi.write(0x01);
    uint8_t year =  ((response&0xF0)>>4)*10+(response&0x0F)*1;
    rtc_cs=1;
    //sprintf(Time_stamp,"%02d%02d%02d%02d%02d%02d%02d%02d",year, month, date, day, hours, minutes, seconds, milliseconds );
    uint8_t Time_stamp[8] = {year, month, date, day, hours, minutes, seconds, centiseconds};
    for(int i= 0; i<8;i++)
        printf("%d\t",Time_stamp[i]);
    printf("read\r\n");
    uint64_t time;
    time = 0;
    time = time|(((uint64_t)(centiseconds&0x7F)));
    time = time|(((uint64_t)(seconds&0x3F))<<7);
    time = time|(((uint64_t)(minutes&0x3F))<<13);
    time = time|(((uint64_t)(hours&0x1F))<<19);
    time = time|(((uint64_t)(day&0x1F))<<24);
    time = time|(((uint64_t)(month&0x07))<<29);
    time = time|(((uint64_t)(year&0x03))<<33);
    time = (time&0x00000007FFFFFFFF);
    //printf("\n\r%x%x", (int)(time >> 32), (int)(time));
    printf("\n\r0x%016llx\n\r", time);
   return time;
}