#include "structure.h"
#include "i2c.h"
#include "pinconfig.h"
#include "crc.h"
#include "TMTC.h"
#include "cdms_rtc.h"
#include "cdms_sd.h"
#include "Flash.h"

DigitalIn tm_status_4m_slv(PIN39); //I2C interrupt to CDMS from BAE
//DigitalIn tm_status_4m_pl(PIN61); //I2C interrupt to CDMS from PL

uint8_t received = 0;
uint16_t mid1;
uint16_t mid2;
uint16_t Nbytes;
uint32_t Data;
uint16_t nbytes;
uint8_t flash_counter = 0;
uint16_t crc16;
uint16_t mid;
uint32_t block;

Base_tm *FCTN_CDMS_RLY_TMTC(Base_tc *tc)
{
    printf("\rTC execution in progress\r\n");
    Base_tm *tm = new Long_tm;
    Base_tm *tm_pointer = tm;
    received = 0;
    switch(GETapid(tc))
    {
        case 1: //apid=01 implies it corresponds to bae
        {
            printf("Telecommand is for BAE\r\n");
            printf("Sending TC to BAE...\r\n"); //interrupt to be sent to the bae
            FCTN_I2C_WRITE((char*)tc->TC_string);
            while(1)
            {
                wait(1); //TimeOut instead of wait
                if(tm_status_4m_slv == 1)
                {
                    printf("receiving...\r\n");
                    FCTN_I2C_READ((char*)tm_pointer->TM_string);
                    printf("%s", tm_pointer->TM_string);
                    received+=1;
                    tm_pointer = tm_pointer->next_TM;
                    break; //only for testing purpose
                }
                else
                {
                    break;
                }
            }
            if(received >= 1 )
            {
                printf("Telemetry is received from BAE\r\n");
                Base_tm *tm_print = tm;
                for(uint8_t i=0;i<received;i++)
                {   
                    printf("%s", tm_print->TM_string);
                    tm_print = tm_print->next_TM; //for check
                }
                received  = 0;
                return tm;
            }
            else
            {
                printf("Telemetry is not received from BAE\r\n");
                tm_pointer = new Short_tm;
                tm_pointer->TM_string[0] = 0xB0;
                tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                tm_pointer->TM_string[2] = 0x01;
                tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                tm_pointer->TM_string[4] = 0x01;
                for(uint8_t i=0;i<6;i++)
                {
                    tm_pointer->TM_string[i+5] = 0;
                }
                crc16 = CRC::crc16_gen(tm->TM_string,11);
                tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                return tm;
            }
            break;
        }
        case 2:
        {
            printf("Telecommand is for CDMS\r\n"); //apid = 10 corresponds to cdms
            switch(GETservice_type(tc))
            {
                case 6:
                {
                    printf("service:MMS\r\n");
                    switch(GETservice_subtype(tc))
                    {
                        case 1:
                        {
                            printf("sub_service:Read from Memory\r\n");
                            if(GETpid(tc) == 2)
                            {                                  
                                printf("pid:RD_L_FLASH\r\n");
                                mid1 = ((((uint16_t)tc->TC_string[5])<<8)|(uint16_t)(tc->TC_string[6]));
                                mid2 = ((((uint16_t)tc->TC_string[7])<<8)|(uint16_t)(tc->TC_string[8]));
                                Nbytes = (((mid2-mid1)*32)/8)+4;
                                uint8_t data[4*Nbytes];
                                for(uint8_t i=0;i<mid2-mid1+1;i++)
                                {
                                    Data = FCTN_CDMS_RD_FLASH(mid1+i);
                                    data[4*i] = (uint8_t)((Data&0xFF000000)>>24);
                                    data[4*i+1] = (uint8_t)((Data&0xFF000000)>>16);
                                    data[4*i+2] = (uint8_t)((Data&0xFF000000)>>8);
                                    data[4*i+3] = (uint8_t)(Data&0xFF000000);
                                }
                                nbytes = Nbytes;
                                flash_counter = 0;
                                while(nbytes>=8)
                                {
                                    tm_pointer = new Long_tm;
                                    tm_pointer->TM_string[0] = 0x30;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = (uint8_t)(flash_counter);
                                    for(uint8_t i=0;i<8;i++)
                                    {
                                        tm_pointer->TM_string[3+i] = data[i+128*flash_counter];
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,9);
                                    tm_pointer->TM_string[9] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[10] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer = tm_pointer->next_TM;
                                    nbytes-=128;
                                    flash_counter++;
                                }
                                if(nbytes>0)
                                {
                                    tm_pointer->TM_string[0] = 0x30;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = (uint8_t)((flash_counter&0xFF00)>>8);
                                    tm_pointer->TM_string[3] = (uint8_t)(flash_counter&0x00FF);
                                    for(uint8_t i=0;i<nbytes;i++)
                                    {
                                        tm_pointer->TM_string[4+i] = data[i+128*flash_counter];
                                    }
                                    for(uint8_t i=nbytes;i<128;i++)
                                    {
                                        tm_pointer->TM_string[4+i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,132);
                                    tm_pointer->TM_string[132] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[133] = (uint8_t)(crc16&0x00FF);
                                }
                                return tm;
                            }
                            else if (GETpid(tc)==0x22)
                            {
                                printf("RD_S_FLASH\r\n");
                                mid1 = ((((uint16_t)tc->TC_string[5])<<8)|(uint16_t)(tc->TC_string[6]));
                                mid2 = ((((uint16_t)tc->TC_string[7])<<8)|(uint16_t)(tc->TC_string[8]));
                                Nbytes = (((mid2-mid1)*32)/8)+4;
                                uint8_t data[4*Nbytes];
                                for(uint8_t i=0;i<mid2-mid1+1;i++)
                                {
                                    Data = FCTN_CDMS_RD_FLASH(mid1+i);
                                    data[4*i] = (uint8_t)((Data&0xFF000000)>>24);
                                    data[4*i+1] = (uint8_t)((Data&0xFF000000)>>16);
                                    data[4*i+2] = (uint8_t)((Data&0xFF000000)>>8);
                                    data[4*i+3] = (uint8_t)(Data&0xFF000000);
                                }
                                nbytes = Nbytes;
                                flash_counter = 0;
                                while(nbytes>=8)
                                {
                                    tm_pointer = new Short_tm;
                                    tm_pointer->TM_string[0] = 0xC0;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = (uint8_t)(flash_counter);
                                    for(uint8_t i=0;i<8;i++)
                                    {
                                        tm_pointer->TM_string[3+i] = data[i+8*flash_counter];
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer = tm_pointer->next_TM;
                                    nbytes-=8;
                                    flash_counter++;
                                }
                                if(nbytes>0)
                                {
                                    tm_pointer->TM_string[0] = 0xC0;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = (uint8_t)(flash_counter);
                                    for(uint8_t i=0;i<nbytes;i++)
                                    {
                                        tm_pointer->TM_string[3+i] = data[i+8*flash_counter];
                                    }
                                    for(uint8_t i=nbytes;i<128;i++)
                                    {
                                        tm_pointer->TM_string[3+i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[132] = (uint8_t)((crc16&0xFF00)>>2);
                                    tm_pointer->TM_string[133] = (uint8_t)(crc16&0x00FF);
                                }
                                return tm;
                            }
                            else if (GETpid(tc)==0x42)
                            {
                                printf("RD_L_RAM\r\r\n"); //to be discussed which RAM variables are to read;
                                tm_pointer = new Short_tm; //for now sending ACKL234
                                tm_pointer->TM_string[0] = 0xB0;
                                tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                tm_pointer->TM_string[2] = 0x01;
                                tm_pointer->TM_string[3] = ACKCODE; 
                                tm_pointer->TM_string[4] = 0x01;
                                for(uint8_t i=0;i<6;i++)
                                {
                                    tm_pointer->TM_string[i+5] = 0;
                                }
                                crc16 = CRC::crc16_gen(tm->TM_string,11);
                                tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                return tm;
                            }
                            else if (GETpid(tc)==0x62)
                            {
                                printf("RD_S_RAM\r\r\n");  //to be discussed which RAM variables are to read;
                                tm_pointer = new Short_tm; //for now sending ACKL234
                                tm_pointer->TM_string[0] = 0xB0;
                                tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                tm_pointer->TM_string[2] = 0x01;
                                tm_pointer->TM_string[3] = ACKCODE; 
                                tm_pointer->TM_string[4] = 0x01;
                                for(uint8_t i=0;i<6;i++)
                                {
                                    tm_pointer->TM_string[i+5] = 0;
                                }
                                crc16 = CRC::crc16_gen(tm->TM_string,11);
                                tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                return tm;
                            }
                            else 
                            {
                                printf("INVALID TC\r\n"); //Send Invalid TC Telemetry
                                tm_pointer = new Short_tm;
                                tm_pointer->TM_string[0] = 0xB0;
                                tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                tm_pointer->TM_string[2] = 0x01;
                                tm_pointer->TM_string[3] = ACKCODE;  //ackcode to be decided
                                tm_pointer->TM_string[4] = 0x01;
                                for(uint8_t i=0;i<6;i++)
                                {
                                    tm_pointer->TM_string[i+5] = 0;
                                }
                                crc16 = CRC::crc16_gen(tm->TM_string,11);
                                tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                return tm;                               
                            }
                            break;
                        }
                        case 5:
                        {
                            printf("WRITE ON MEMORY\r\n");
                            switch(GETpid(tc))
                            {
                                case 0:
                                {
                                    printf("WR_S_FLASH\r\r\n");
                                    mid = ((uint16_t)tc->TC_string[4]);
                                    block = (((uint32_t)(tc->TC_string[5])<<24)|((uint32_t)(tc->TC_string[5])<<16)|((uint32_t)(tc->TC_string[5])<<8)|((uint32_t)(tc->TC_string[5])));
                                    FCTN_CDMS_WR_FLASH(mid,block);
                                    tm_pointer = new Short_tm;
                                    tm_pointer->TM_string[0] = 0xB0;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE;  //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                case 1:
                                {
                                    printf("WR_S_RAM\r\r\n"); //RAM variables to be written is to be decided
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                case 16:
                                {
                                    printf("WR_L_FLASH\r\n");
                                    mid = ((uint16_t)tc->TC_string[4]);
                                    for(uint8_t i=0;i<32;i++)
                                    {
                                        block = (((uint32_t)(tc->TC_string[5])<<24)|((uint32_t)(tc->TC_string[5])<<16)|((uint32_t)(tc->TC_string[5])<<8)|((uint32_t)(tc->TC_string[5])));
                                        FCTN_CDMS_WR_FLASH(mid+i,block);
                                    }
                                    tm_pointer = new Short_tm;
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                    break;
                                }
                                case 17:
                                {
                                    printf("WR_L_RAM\r\r\n"); //RAM variables to be written is to be decided
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                default:
                                {
                                    printf("INVALID TC"); //send invalid TC TM
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                            }
                            break;
                        }
                        // case 6:
                        // {
                        //     printf("WRITE FROM ONE MEMORY TO ANOTHER\r\r\n");
                        //     switch(appdata[0])
                        //     {
                        //         case 0:
                        //         {
                        //             printf("WR_S_FLASH\r\r\n");
                        //             telemetry_type2[0]=0XB0;
                        //             telemetry_type2[1]=tc_pac_seq_cnt_tm;
                        //             telemetry_type2[2]=tm_pac_seq_cnt_tm;
                        //             telemetry_type2[3]=ackcode_tm;
                        //             for(int i=4;i<11;i++)
                        //             {
                        //                 telemetry_type2[i]=0X00;
                        //             }
                        //             break;
                        //         }
                        //         case 1:
                        //         {
                        //             printf("WR_S_RAM\r\r\n");
                        //             telemetry_type2[0]=0XB0;
                        //             telemetry_type2[1]=tc_pac_seq_cnt_tm;
                        //             telemetry_type2[2]=tm_pac_seq_cnt_tm;
                        //             telemetry_type2[3]=ackcode_tm;
                        //             for(int i=4;i<11;i++)
                        //             {
                        //                 telemetry_type2[i]=0X00;
                        //             }
                        //             break;
                        //         }
                        //         case 16:
                        //         {
                        //             printf("WR_L_FLASH\r\r\n");
                        //             telemetry_type2[0]=0XB0;
                        //             telemetry_type2[1]=tc_pac_seq_cnt_tm;
                        //             telemetry_type2[2]=tm_pac_seq_cnt_tm;
                        //             telemetry_type2[3]=ackcode_tm;
                        //             for(int i=4;i<11;i++)
                        //             {
                        //                 telemetry_type2[i]=0X00;
                        //             }
                        //             break;
                        //         }
                        //         case 17:
                        //         {
                        //             printf("WR_L_RAM\r\r\n");
                        //             telemetry_type2[0]=0XB0;
                        //             telemetry_type2[1]=tc_pac_seq_cnt_tm;
                        //             telemetry_type2[2]=tm_pac_seq_cnt_tm;
                        //             telemetry_type2[3]=ackcode_tm;
                        //             for(int i=4;i<11;i++)
                        //             {
                        //                 telemetry_type2[i]=0X00;
                        //             }
                        //             break;
                        //         }
                        //         default:
                        //         {
                        //             printf("INVALID TC"); //send invalid TC TM
                        //             break;
                        //         }
                        //     }
                        //     break;
                        // }
                        case 9:
                        {
                            printf("SEND CRC OF FLASH MEMORY\r\n");
                            if(GETpid(tc)==2)
                            {
                                printf("GET_FLASH_CRC\r\n");
                                mid1 = ((((uint16_t)tc->TC_string[5])<<8)|(uint16_t)(tc->TC_string[6]));
                                mid2 = ((((uint16_t)tc->TC_string[7])<<8)|(uint16_t)(tc->TC_string[8]));
                                Nbytes = (((mid2-mid1)*32)/8)+4;
                                uint8_t data[4*Nbytes];
                                uint8_t flash_counter = 0;
                                tm_pointer = new Long_tm;
                                tm_pointer->TM_string[0] = 0x80;
                                tm_pointer->TM_string[1] = 0x00; //spare
                                tm_pointer->TM_string[2] = GETpacket_seq_count(tc);
                                tm_pointer->TM_string[3] = (uint8_t)(flash_counter);
                                for(uint8_t i=0;i<mid2-mid1+1;i++)
                                {
                                    Data = FCTN_CDMS_RD_FLASH(mid1+i);
                                    data[4*i] = (uint8_t)((Data&0xFF000000)>>24);
                                    data[4*i+1] = (uint8_t)((Data&0xFF000000)>>16);
                                    data[4*i+2] = (uint8_t)((Data&0xFF000000)>>8);
                                    data[4*i+3] = (uint8_t)(Data&0xFF000000);
                                }
                                nbytes = Nbytes;
                                while(nbytes>=32)
                                {
                                    crc16 = CRC::crc16_gen((data+32*flash_counter),32);
                                    tm_pointer->TM_string[11+2*flash_counter] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12+2*flash_counter] = (uint8_t)(crc16&0x00FF);
                                    nbytes-=32;
                                    flash_counter++;
                                }
                                if(nbytes>0)
                                {
                                    crc16 = CRC::crc16_gen((data+32*flash_counter),nbytes);
                                    tm_pointer->TM_string[11+2*flash_counter] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12+2*flash_counter] = (uint8_t)(crc16&0x00FF);
                                }
                                return tm;
                            }
                            else 
                            {
                                printf("INVALID TC"); //Send Invalid TC Telemetry
                                tm_pointer = new Short_tm; 
                                tm_pointer->TM_string[0] = 0xB0; 
                                tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                tm_pointer->TM_string[2] = 0x01;
                                tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                tm_pointer->TM_string[4] = 0x01;
                                for(uint8_t i=0;i<6;i++)
                                {
                                    tm_pointer->TM_string[i+5] = 0;
                                }
                                crc16 = CRC::crc16_gen(tm->TM_string,11);
                                tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                return tm;
                            }
                            break;
                        }
                        case 8:
                        {
                            printf("service:FUNCTION MANAGEMENT SERVICE\r\n"); 
                            if(GETservice_subtype(tc)==1)
                            {
                                if((GETpid(tc)&0xF0)==0x00)
                                {
                                    printf("RUN_PRCS\r\n");
                                    switch(GETpid(tc))
                                    {
                                        case 1:
                                        {
                                            printf("P_PL_INIT\r\n"); //call P_PL_INIT using CDMS_RUN_PRCS
                                            tm_pointer = new Short_tm; 
                                            tm_pointer->TM_string[0] = 0xB0; 
                                            tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                            tm_pointer->TM_string[2] = 0x01;
                                            tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                            tm_pointer->TM_string[4] = 0x01;
                                            for(uint8_t i=0;i<6;i++)
                                            {
                                                tm_pointer->TM_string[i+5] = 0;
                                            }
                                            crc16 = CRC::crc16_gen(tm->TM_string,11);
                                            tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                            tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                            return tm;
                                            break;
                                        }
                                        case 2:
                                        {
                                            printf("P_PL_MNGR\r\n"); //call P_PL_MNGR using CDMS_RUN_PRCS
                                            tm_pointer = new Short_tm; 
                                            tm_pointer->TM_string[0] = 0xB0; 
                                            tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                            tm_pointer->TM_string[2] = 0x01;
                                            tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                            tm_pointer->TM_string[4] = 0x01;
                                            for(uint8_t i=0;i<6;i++)
                                            {
                                                tm_pointer->TM_string[i+5] = 0;
                                            }
                                            crc16 = CRC::crc16_gen(tm->TM_string,11);
                                            tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                            tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                            return tm;
                                            break;
                                        }
                                        case 3:
                                        {
                                            printf("P_COM_INIT\r\n"); //call P_COM_INIT using CDMS_RUN_PRCS
                                            tm_pointer = new Short_tm; 
                                            tm_pointer->TM_string[0] = 0xB0; 
                                            tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                            tm_pointer->TM_string[2] = 0x01;
                                            tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                            tm_pointer->TM_string[4] = 0x01;
                                            for(uint8_t i=0;i<6;i++)
                                            {
                                                tm_pointer->TM_string[i+5] = 0;
                                            }
                                            crc16 = CRC::crc16_gen(tm->TM_string,11);
                                            tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                            tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                            return tm;
                                            break;
                                        }
                                        case 4:
                                        {
                                            printf("P_CDMS_HK_MNGR\r\n"); //call P_CDMS_HK_MNGR using CDMS_RUN_PRCS
                                            tm_pointer = new Short_tm; 
                                            tm_pointer->TM_string[0] = 0xB0; 
                                            tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                            tm_pointer->TM_string[2] = 0x01;
                                            tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                            tm_pointer->TM_string[4] = 0x01;
                                            for(uint8_t i=0;i<6;i++)
                                            {
                                                tm_pointer->TM_string[i+5] = 0;
                                            }
                                            crc16 = CRC::crc16_gen(tm->TM_string,11);
                                            tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                            tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                            return tm;
                                            break;
                                        }
                                        default:
                                        {
                                            printf("INVALID TC\r\n");
                                            tm_pointer = new Short_tm; 
                                            tm_pointer->TM_string[0] = 0xB0; 
                                            tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                            tm_pointer->TM_string[2] = 0x01;
                                            tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                            tm_pointer->TM_string[4] = 0x01;
                                            for(uint8_t i=0;i<6;i++)
                                            {
                                                tm_pointer->TM_string[i+5] = 0;
                                            }
                                            crc16 = CRC::crc16_gen(tm->TM_string,11);
                                            tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                            tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                            return tm;
                                            break;
                                        }
                                    }
                                }
                                else if((GETpid(tc)&0xF0)==0x10)
                                {
                                    printf("PWR_SWCH_ON\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if((GETpid(tc)&0xF0)==0x20)
                                {
                                    printf("PWR_SWCH_OFF\r\n"); // call PWR_SWCH_OFF function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if((GETpid(tc)&0xF0)==0x20) 
                                {
                                    printf("PWR_RST\r\n"); // call PWR_RST function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if((GETpid(tc)&0xF0)==0xE0)
                                {
                                    printf("RD_RTC\r\n"); //call RD_RTC
                                    tm_pointer = new Short_tm;
                                    tm_pointer->TM_string[0] = 0xD0;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = 0x01;
                                    uint64_t time = FCTN_CDMS_RD_RTC();
                                    tm_pointer->TM_string[3] = (uint8_t)((time&0xFF00000000000000)>>56);
                                    tm_pointer->TM_string[4] = (uint8_t)((time&0x00FF000000000000)>>48);
                                    tm_pointer->TM_string[5] = (uint8_t)((time&0x0000FF0000000000)>>40);
                                    tm_pointer->TM_string[6] = (uint8_t)((time&0x000000FF00000000)>>32);
                                    tm_pointer->TM_string[7] = (uint8_t)((time&0x00000000FF000000)>>24);
                                    tm_pointer->TM_string[8] = (uint8_t)((time&0x0000000000FF0000)>>16);
                                    tm_pointer->TM_string[9] = (uint8_t)((time&0x000000000000FF00)>>8);
                                    tm_pointer->TM_string[10] = (uint8_t)(time&0x00000000000000FF);
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                }
                                else if((GETpid(tc)&0xF0)==0xF0)
                                {
                                    printf("SD_MNGR\r\n"); //call SD_MNGR function and send required information in FMS TM
                                    tm_pointer = new Short_tm; // for now sending ACK L_234
                                    tm_pointer->TM_string[0] = 0xD0;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = 0x01;
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0; // for now filling with zeroes instead of SD_MNGR Data
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                }
                                else 
                                {
                                    printf("INVALID TC\r\n");
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                }
                            }
                            default:
                            {
                                printf("INVALID TC\r\n");
                                tm_pointer = new Short_tm; 
                                tm_pointer->TM_string[0] = 0xB0; 
                                tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                tm_pointer->TM_string[2] = 0x01;
                                tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                tm_pointer->TM_string[4] = 0x01;
                                for(uint8_t i=0;i<6;i++)
                                {
                                    tm_pointer->TM_string[i+5] = 0;
                                }
                                crc16 = CRC::crc16_gen(tm->TM_string,11);
                                tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                return tm;
                                break;
                            }
                            break;
                        }
                        case 7:
                        {
                            printf("service:PAYLOAD MANAGEMENT SERVICE\r\r\n"); //TM is ACKL234
                            switch(GETservice_subtype(tc))
                            {
                                case 1:
                                {
                                    printf("INSERT PL SCHEDULE\r\n"); //should be called PL_MAIN 
                                    tm_pointer = new Short_tm;  // for now sending dummy ACK L_234
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                case 2:
                                {
                                    printf("DELETE PL SCHEDULE\r\n"); //Should be called PL_MAIN 
                                    tm_pointer = new Short_tm; // for now sending dummy ACK L_234
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                case 3:
                                {
                                    printf("REPORT PL SCHEDULE\r\n"); //Data is taken by calling PL_MAIN
                                    tm_pointer = new Long_tm; //for now sending dummy PMS
                                    tm_pointer->TM_string[0] = 0x48;
                                    tm_pointer->TM_string[1] = 0x00; //spare 8 bits 
                                    tm_pointer->TM_string[2] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[3] = 0x01;
                                    for(uint8_t i=4;i<132;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0; // for now filling with zeros instead of PL_SCHEDULE
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[132] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[133] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                default:
                                {
                                    printf("INVALID TC"); //send invalid TC TM
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                            }
                            break;
                        }
                    }
                    break;
                }
                default:
                {
                    printf("INVALID TC"); //send invalid TC TM
                    tm_pointer = new Short_tm; 
                    tm_pointer->TM_string[0] = 0xB0; 
                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                    tm_pointer->TM_string[2] = 0x01;
                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                    tm_pointer->TM_string[4] = 0x01;
                    for(uint8_t i=0;i<6;i++)
                    {
                        tm_pointer->TM_string[i+5] = 0;
                    }
                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                    return tm;
                    break;
                }
            }
        }
        case 3:
        {
            printf("Telecommand is for PL\r\n");
            // printf("Informing PL about TC using I2C\r\n"); //interrupt to be sent to the bae
            // FCTN_I2C_WRITE((char*)tc->TC_string);
            // printf("sent the Telecommand to BAE\r\n"); //packet along with crc will be sent when bae is ready
            // wait(1); //wait time is to be optimised
            // if(tm_status_4m_slv == 1)
            // {
            //     FCTN_I2C_READ((char*)tm->TM_string);
            //     received = 1;
            // }
            // if(received == 1 )
            // {
            //     printf("Telemetry is received from BAE\r\n");
            //     printf("%s", tm->TM_string);
            //     received  = 0;
            // } // similar to BAE functions
            break;
        }
        default: //invalid TC
        {
            printf("INVALID TC\r\n");
            tm_pointer = new Short_tm; 
            tm_pointer->TM_string[0] = 0xB0; 
            tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
            tm_pointer->TM_string[2] = 0x01;
            tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
            tm_pointer->TM_string[4] = 0x01;
            for(uint8_t i=0;i<6;i++)
            {
                tm_pointer->TM_string[i+5] = 0;
            }
            crc16 = CRC::crc16_gen(tm->TM_string,11);
            tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
            tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
            return tm;
            break;
        }
     }
}