#include "structure.h"
#include "i2c.h"
#include "pinconfig.h"
#include "crc.h"
#include "TMTC.h"
#include "cdms_rtc.h"
#include "cdms_sd.h"
#include "Flash.h"


DigitalIn tm_status_4m_slv(PIN39); //I2C interrupt to CDMS from BAE
//DigitalIn tm_status_4m_pl(PIN61); //I2C interrupt to CDMS from PL

uint8_t received = 0;
uint16_t mid1;
uint16_t mid2;
uint16_t Nbytes;
uint32_t Data[2];
uint16_t nbytes;
uint8_t flash_counter = 0;
uint16_t crc16;
uint16_t mid;
uint32_t block;

Base_tm *FCTN_CDMS_RLY_TMTC(Base_tc *tc)
{
    printf("\rTC execution in progress\r\n");
    Base_tm *tm = new Long_tm;
    Base_tm *tm_pointer = tm;
    received = 0;
    switch(GETapid(tc))
    {
        case 1: //apid=01 implies it corresponds to bae
        {
            printf("Telecommand is for BAE\r\n");
            printf("Sending TC to BAE...\r\n"); //interrupt to be sent to the bae
            FCTN_I2C_WRITE((char*)tc->TC_string);
            while(1)
            {
                wait(1.5); //TimeOut instead of wait
                if(tm_status_4m_slv == 1)
                {
                    printf("receiving...\r\n");
                    FCTN_I2C_READ((char*)tm_pointer->TM_string,134);
                    //printf("%s", tm_pointer->TM_string);
                    received+=1;
                    tm_pointer = tm_pointer->next_TM;
                    break; //only for testing purpose
                }
                else
                {
                    break;
                }
            }
            if(received >= 1 )
            {
                printf("Telemetry is received from BAE\r\n");
                Base_tm *tm_print = tm;
                for(uint8_t i=0;i<received;i++)
                {   
                    printf("%s", tm_print->TM_string);
                    tm_print = tm_print->next_TM; //for check
                }
                received  = 0;
                return tm;
            }
            else
            {
                printf("Telemetry is not received from BAE\r\n");
                tm_pointer = new Short_tm;
                tm_pointer->TM_string[0] = 0xB0;
                tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                tm_pointer->TM_string[2] = 0x01;
                tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                tm_pointer->TM_string[4] = 0x01;
                for(uint8_t i=0;i<6;i++)
                {
                    tm_pointer->TM_string[i+5] = 0;
                }
                crc16 = CRC::crc16_gen(tm->TM_string,11);
                tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                return tm;
            }
            break;
        }
        case 2:
        {
            printf("Telecommand is for CDMS\r\n"); //apid = 10 corresponds to cdms
            switch(GETservice_type(tc))
            {
                case 0x60:
                {
                        printf("service:MMS\r\n");
                        switch(GETservice_subtype(tc))
                        {
                            case 0x1:
                            {
                            printf("sub_service:Read from RAM_Memory\r\n");
                            mid=(uint16_t)(tc->TC_string[3]<<4)+(uint16_t)(tc->TC_string[4]);
                            
                            
                                                              
                                    Data[0] = FCTN_CDMS_RD_FLASH(0);
                                    Data[1] = FCTN_CDMS_RD_FLASH(1);
                                    tm_pointer = new Long_tm;
                                    tm_pointer->TM_string[0] = 0x30;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = (uint8_t)(flash_counter);
                                    for(uint8_t i=0;i<4;i++)
                                    {
                                        tm_pointer->TM_string[3+i] = (uint8_t)((Data[0]>>(8*i))&0x00FF);
                                    }
                                    for(uint8_t i=4;i<8;i++)
                                    {
                                        tm_pointer->TM_string[3+i] = (uint8_t)((Data[1]>>(8*i))&0x00FF);
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,9);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                return tm;
                            }
                            
                            case 0x2:
                            {
                            printf("sub_service:Read from Flash_Memory\r\n");
                            mid=(uint16_t)(tc->TC_string[3]<<4)+(uint16_t)(tc->TC_string[4]);
                            
                              
                                
                                
                                    Data[0] = FCTN_CDMS_RD_FLASH(0);
                                    Data[1] = FCTN_CDMS_RD_FLASH(1);
                                    
                                
                              
                                    tm_pointer = new Long_tm;
                                    tm_pointer->TM_string[0] = 0x30;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = (uint8_t)(flash_counter);
                                    for(uint8_t i=0;i<4;i++)
                                    {
                                        tm_pointer->TM_string[3+i] = (uint8_t)((Data[0]>>(8*i))&0x00FF);
                                    }
                                    for(uint8_t i=4;i<8;i++)
                                    {
                                        tm_pointer->TM_string[3+i] = (uint8_t)((Data[1]>>(8*i))&0x00FF);
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,9);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                return tm;
                            
               }
                            
                            case 0x5:
                            {
                            printf("WRITE ON FLASH_MEMORY\r\n");
                            
                                    mid=(uint16_t)(tc->TC_string[3]<<4)+(uint16_t)(tc->TC_string[4]);
                                    
                                    block = (((uint32_t)(tc->TC_string[5])<<24)|((uint32_t)(tc->TC_string[5])<<16)|((uint32_t)(tc->TC_string[5])<<8)|((uint32_t)(tc->TC_string[5])));
                                    FCTN_CDMS_WR_FLASH(mid,block);
                                    tm_pointer = new Short_tm;
                                    tm_pointer->TM_string[0] = 0xB0;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE;  //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                            }
                           
                         
                            default: 
                            {
                                printf("INVALID TC\r\n"); //Send Invalid TC Telemetry
                                tm_pointer = new Short_tm;
                                tm_pointer->TM_string[0] = 0xB0;
                                tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                tm_pointer->TM_string[2] = 0x01;
                                tm_pointer->TM_string[3] = ACKCODE;  //ackcode to be decided
                                tm_pointer->TM_string[4] = 0x01;
                                for(uint8_t i=0;i<6;i++)
                                {
                                    tm_pointer->TM_string[i+5] = 0;
                                }
                                crc16 = CRC::crc16_gen(tm->TM_string,11);
                                tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                return tm;                               
                            }
                            break;
                        
                    }
                       
                      
                       
                    case 0x8:
                    {
                        printf("service:FUNCTION MANAGEMENT SERVICE\r\n"); 
                        if(GETservice_subtype(tc)==0x1)
                            {
                                
                              if(GETpid(tc)==0x01)
                                {
                                    printf("TC_PL_INIT\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                
                                else if(GETpid(tc)==0x02)
                                {
                                    printf("TC_PL_MAIN\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                               else if(GETpid(tc)==0x03)
                                {
                                    printf("TC_COM_INIT\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if(GETpid(tc)==0x04)
                                {
                                    printf("TC_CDMS_HK_MAIN\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                   
                                }
                                else if(GETpid(tc)==0x11)
                                {
                                    printf("TC_SW_ON_SD\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if(GETpid(tc)==0x12)
                                {
                                    printf("TC_SW_ON_RTC\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if(GETpid(tc)==0x13)
                                {
                                    printf("TC_SW_ON_BAE\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if(GETpid(tc)==0x14)
                                {
                                    printf("TC_SW_ON_PL_DL\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                 else if(GETpid(tc)==0x15)
                                {
                                    printf("TC_SW_ON_PL_AG_HV\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                 else if(GETpid(tc)==0x16)
                                {
                                    printf("TC_SW_ON_V_A_EN\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                   
                                }
                                else if(GETpid(tc)==0x21)
                                {
                                    printf("TC_SW_OFF_SD\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if(GETpid(tc)==0x22)
                                {
                                    printf("TC_SW_OFF_RTC\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if(GETpid(tc)==0x23)
                                {
                                    printf("TC_SW_OFF_BAE\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if(GETpid(tc)==0x24)
                                {
                                    printf("TC_SW_OFF_PL_DL\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                 else if(GETpid(tc)==0x25)
                                {
                                    printf("TC_SW_OFF_PL_AG_HV\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                 else if(GETpid(tc)==0x26)
                                {
                                    printf("TC_SW_OFF_V_A_EN\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if(GETpid(tc)==0x31)
                                {
                                    printf("TC_RST_SD\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if(GETpid(tc)==0x32)
                                {
                                    printf("TC_RST_RTC\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if(GETpid(tc)==0x33)
                                {
                                    printf("TC_RST_BAE\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if(GETpid(tc)==0x34)
                                {
                                    printf("TC_RST_PL_DL\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                
                                }
                                else if(GETpid(tc)==0xC1)
                                {
                                    printf("RESET_HK_COUNTER\r\n"); // call PWR_SWCH_ON function
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                    break;
                                }
                                else if(GETpid(tc)==0xF1)
                                {
                                    printf("RD_RTC\r\n"); //call RD_RTC
                                    tm_pointer = new Short_tm;
                                    tm_pointer->TM_string[0] = 0xD0;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);
                                    tm_pointer->TM_string[2] = 0x01;
                                    uint64_t time = FCTN_CDMS_RD_RTC();
                                    tm_pointer->TM_string[3] = (uint8_t)((time&0xFF00000000000000)>>56);
                                    tm_pointer->TM_string[4] = (uint8_t)((time&0x00FF000000000000)>>48);
                                    tm_pointer->TM_string[5] = (uint8_t)((time&0x0000FF0000000000)>>40);
                                    tm_pointer->TM_string[6] = (uint8_t)((time&0x000000FF00000000)>>32);
                                    tm_pointer->TM_string[7] = (uint8_t)((time&0x00000000FF000000)>>24);
                                    tm_pointer->TM_string[8] = (uint8_t)((time&0x0000000000FF0000)>>16);
                                    tm_pointer->TM_string[9] = (uint8_t)((time&0x000000000000FF00)>>8);
                                    tm_pointer->TM_string[10] = (uint8_t)(time&0x00000000000000FF);
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                }
                                
                                else 
                                {
                                    printf("INVALID TC\r\n");
                                    tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    return tm;
                                }
                            }
                           
                        }
                       
                    
                  
                
                default:
                {
                    printf("INVALID TC"); //send invalid TC TM
                    tm_pointer = new Short_tm; 
                    tm_pointer->TM_string[0] = 0xB0; 
                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
                    tm_pointer->TM_string[2] = 0x01;
                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                    tm_pointer->TM_string[4] = 0x01;
                    for(uint8_t i=0;i<6;i++)
                    {
                        tm_pointer->TM_string[i+5] = 0;
                    }
                    crc16 = CRC::crc16_gen(tm->TM_string,11);
                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                    return tm;
                    break;
                }
            }
        }
        case 3:
        {
            printf("Telecommand is for PL\r\n");
            // printf("Informing PL about TC using I2C\r\n"); //interrupt to be sent to the bae
            // FCTN_I2C_WRITE((char*)tc->TC_string);
            // printf("sent the Telecommand to BAE\r\n"); //packet along with crc will be sent when bae is ready
            // wait(1); //wait time is to be optimised
            // if(tm_status_4m_slv == 1)
            // {
            //     FCTN_I2C_READ((char*)tm->TM_string);
            //     received = 1;
            // }
            // if(received == 1 )
            // {
            //     printf("Telemetry is received from BAE\r\n");
            //     printf("%s", tm->TM_string);
            //     received  = 0;
            // } // similar to BAE functions
            break;
        }
       
        default: //invalid TC
        {
            printf("INVALID TC\r\n");
            tm_pointer = new Short_tm; 
            tm_pointer->TM_string[0] = 0xB0; 
            tm_pointer->TM_string[1] = GETpacket_seq_count(tc);                                    
            tm_pointer->TM_string[2] = 0x01;
            tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
            tm_pointer->TM_string[4] = 0x01;
            for(uint8_t i=0;i<6;i++)
            {
                tm_pointer->TM_string[i+5] = 0;
            }
            crc16 = CRC::crc16_gen(tm->TM_string,11);
            tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
            tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
            return tm;
            break;
       }

     
}
}
}