#include "mbed.h"
#include "pin_config.h"
#include "all_funcs.h"

#define COMM_TX_EN_PIN PIN64                 //COMM receiver enable
#define PYLD_EN_PIN PIN73                    // Payload switch enable

DigitalOut COMM_TX_EN(COMM_TX_EN_PIN);            //assuming active high
DigitalOut PYLD_EN(PYLD_EN_PIN);            //assuming active high
    
void FCTN_POWER_MODE(int SOC)                  //flag corresponds to the power mode
{
    printf("Entered Power Management \n"); 
    printf("Battery Level %d \n",SOC);
    // range of battery level is dummy. yet to be fixed
    if(SOC>=85)
        {
            COMM_TX_EN = 1;         //high power mode : everything is on
            PYLD_EN = 1;
        }            
    else if(SOC<85 && SOC>=70)
        {
            COMM_TX_EN = 1;         //COMM TX is on
            PYLD_EN = 1;            //payload switch enable
        }           
    else if(SOC<55 && SOC>=70)
        {
            COMM_TX_EN = 1;         //COMM TX is off
            PYLD_EN = 0;            //payload switch disable
        } 
    else if(SOC<40 && SOC>=55)
        {
            COMM_TX_EN = 1;         //COMM TX is off
            PYLD_EN = 0;            //payload switch disable
        }         
    

}
