/*Header Files*/
#include "mbed.h"
#include "rtos.h"
#include "main.h"
#include "Flags.h"
#include "all_funcs.h"
/*End*/

Serial pc(USBTX, USBRX);

/*CDMS INIT*/
void FCTN_CDMS_INIT()
{
    all_flags = all_flags|CDMS_INIT_STATUS; //setting the CDMS_INIT_STATUS Flag
    
    /*Configuring pins*/
    InterruptIn pl_sc_data(PTC3);           //interrupt from payload to send science data
    InterruptIn cdms_rcv_tc(PTC12);         //interrupt from comm b4 sending tc
    InterruptIn bae_tm_rcv(PTC11);          //interrupt from bae b4 sending tm
    InterruptIn pl_tm_rcv(PTC10);           //interrupt from bae b4 sending tm
    /*End*/
        
    master.frequency(100000);              //I2C master frequency initializing
    irpt_2_slv = 1;                        //Interrupt pin to be pulled down in the beginning
    
    /*All Interrupt pin configuration*/
    pl_sc_data.rise(&ISR_PL_RCV_SC_DATA);
    cdms_rcv_tc.rise(&ISR_CDMS_RLY_TC);
    bae_tm_rcv.rise(&ISR_CDMS_RLY_TM);
    pl_tm_rcv.rise(&ISR_CDMS_RLY_TM);
    /*End*/
    
    /*Initializing PYLD SPI*/
    pl_spi.format(8,3);  // SPI format --> 16 bits, mode = 0
    pl_spi.frequency(1000000);
    /*End*/
    
    FCTN_CDMS_HK_INIT();
    FCTN_INIT_RTC();    
    FCTN_INIT_SD();
    all_flags = all_flags&(~CDMS_INIT_STATUS);
}
/*End*/

/*All Threads*/
void T_CDMS_RLY_TC(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x2);
        pc.printf("in T_CDMS_RLY_TC\r\n");
        FCTN_CDMS_RLY_TC();
    }
}

void T_CDMS_RLY_TM(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x3);
        pc.printf("\rin T_CDMS_RLY_TM\r\n");
        FCTN_CDMS_RLY_TM();
    }
}

void T_PL_RCV_SC_DATA(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x1);
        pc.printf("\rin T_PL_RCV_SC_DATA\r\n");
        FCTN_PL_RCV_SC_DATA();
    }
}
/*End*/

/*RTOS Scheduler*/         
void T_SC(void const *args)
{
    sc_timer++;
    if(sc_timer%18==0)
    {
        FCTN_CDMS_HK_MAIN();
    }
    if(sc_timer%9==0)
    {
        FCTN_PL_MAIN();
    }
}
/*End*/

/*All ISR's*/
void ISR_PL_RCV_SC_DATA()
{
    ptr_t_sc_data->signal_set(0x1);  //science thread is signalled from here
}

void ISR_CDMS_RLY_TC()
{
    ptr_t_tc->signal_set(0x2);  //TC thread is signalled from here
}

void ISR_CDMS_RLY_TM()
{
    ptr_t_tm->signal_set(0x3);  //TM thread is signalled from here whenever a interrupt comes from 
}
/*End*/

/*main thread*/
int main() 
{
    printf("\n\r CDMS Activated \n");
    
    /*Initializing the threads*/
    ptr_t_tc = new Thread (T_CDMS_RLY_TC);  
    ptr_t_tm = new Thread (T_CDMS_RLY_TM);
    ptr_t_sc_data = new Thread (T_PL_RCV_SC_DATA);
    /*End*/
    
    RtosTimer TIMER_HK_ACQ(T_SC,osTimerPeriodic); //Initializing RTOS Timer
    TIMER_HK_ACQ.start(1000);              //1 second RTOS Timer
    
    void FCTN_CDMS_INIT();
    
    while(1);
}
/*End*/