#include "mbed.h"
#include "pin_config.h"
#include "i2c.h"
#include "all_funcs.h"

Serial gc(USBTX,USBRX);
InterruptIn irpt_4m_slv(PIN4);                                      //I2c interrupt from CDMS
DigitalOut irpt_2_slv(PIN5);                                        //I2C interrupt to CDMS
I2C master(PIN32,PIN31);



const int addr = 0x20;                                            //slave address 
Timer t;


int FCTN_I2C_READ(char *data, int length )
{
    bool read_ack = true;
    irpt_2_slv = 0; 
    t.start();
    read_ack=master.read(addr|1,data,length);
    t.stop();
    if(read_ack == 0)
        printf("\r\n\rData received from BAE is %s \r\n",data);
    else
    {
        printf("\r\n \r data not received \r\n");
        master.stop();
    }
    irpt_2_slv = 1;
    printf("\r\n\r %d \r\n",t.read_us());
    t.reset();
    return read_ack;
}

int  FCTN_I2C_WRITE(char *data,int length)
{
    bool write_ack = true;
    irpt_2_slv = 0;
    t.start();
    write_ack=master.write(addr|0x00,data,length);
    t.stop();
    if(write_ack == 0)
        printf("\r\n\rData sent to BAE is %s \r\n",data);
    else 
    {
        printf("\r\n\r data not sent \r\n");
        master.stop();
    }
    irpt_2_slv = 1;
    printf("\r\n\r %d \r\n",t.read_us());
    t.reset();
    return write_ack;
}

bool check = 1;
int FCTN_MASTER_I2C(char i2c_data_type , char* i2c_data)
{
    FCTN_I2C_WRITE(&i2c_data_type,1); 
    wait_ms(10);
    switch(i2c_data_type)
    {
        case 's':
        FCTN_I2C_WRITE(i2c_data,11);
        break;
            
        case 'l':
        FCTN_I2C_WRITE(i2c_data,135);
        break;
            
        case 'h':
        FCTN_I2C_READ(i2c_data,25);
        break;
            
        default:
        printf("\r\n\r invalid command \r\n");
        return 25;
    }
}