/*PL functions*/
void FCTN_PL_INIT();
void FCTN_PL_MAIN();
void FCTN_PL_RCV_SC_DATA();
void FCTN_PL_SCIENCE();
/*End*/

/*ISR functions*/
void ISR_PL_RCV_SC_DATA();
void ISR_CDMS_RLY_TC();
void ISR_CDMS_RLY_TM();
/*End*/

/*CDMS functions*/
void FCTN_CDMS_INIT();
void FCTN_CDMS_MAIN();
/*End*/

/*Flash functions*/
uint32_t FCTN_CDMS_RD_FLASH(uint16_t i);
void FCTN_CDMS_WR_FLASH(uint16_t i,uint32_t block);
void FCTN_CDMS_GET_FLASH_CRC();
/*End*/

/*RAM functions*/
void FCTN_CDMS_RD_RAM();
void FCTN_CDMS_WR_RAM();
/*End*/

/*RTC functions*/
void FCTN_INIT_RTC();
uint64_t FCTN_CDMS_RD_RTC();
/*End*/

/*I2C functions*/
int FCTN_I2C_READ(char *data,int length = 1);
int FCTN_I2C_WRITE(char *data,int length = 1);
int FCTN_MASTER_I2C(char i2c_data_type , char* i2c_data);
/*End*/

/*SDCard functions*/
void FCTN_INIT_SD();
int FCTN_WR_SD(const uint8_t *, uint64_t);
int FCTN_RD_SD(uint8_t *, uint64_t);
void FCTN_CDMS_MNG_SD();
int initialise_card();
int initialise_card_v2();
int disk_initialize();
int cmd(int, int);
int cmd58();
int cmdx(int, int);
int cmd8();
uint64_t sd_sectors();
int read(uint8_t*, uint32_t );
int write(const uint8_t*, uint32_t );
static uint32_t ext_bits(unsigned char *, int , int );
/*End*/

/*COM functions*/
void FCTN_COM_INIT();
void FCTN_COM_RCV_TC();
void FCTN_COM_MNGR_TMTC();
void FCTN_COM_SND_TM();
void FCTN_COM_SD_TM();
void FCTN_COM_COMP_SC_DATA();
/*End*/

/*HK functions*/
void FCTN_CDMS_HK_INIT();
char* FCTN_CDMS_HK_MAIN();
int quantiz(float l_start,float l_step,float l_x);
void FCTN_HK_MAIN();
/*End*/

/*Power functions*/
void FCTN_POWER_MODE(int SOC);
void FCTN_CDMS_SWCH_PWR();
void FCTN_CDMS_RST_PWR();
/*End*/

/*TCTM functions*/
void FCTN_CDMS_RLY_TC();
void FCTN_CDMS_RLY_TM();
/*End*/