#include "mbed.h"
#include "TC.h"
#include "all_funcs.h"
#include "Flags.h"

Serial sc(USBTX,USBRX);
   
void FCTN_CDMS_RLY_TC()
{
    CDMS_TC_TM_FLAG=0x0000000000000000;
    CDMS_TC_TM_FLAG|=CDMS_TC_TM_STATUS;
    
    sc.printf("\rin FCTN_CDMS_RLY_TC\r\n");
    uint8_t read;
    sc.scanf("%d",&read); //Packet sequence count
    pac_seq_cnt = read;
    sc.scanf("%d",&read); //Data[0] contains APID,LFB,long_or_short,AoN,Spr and Ack
    apid_size = read;
    apid=(apid_size&0xC0)>>6; //apid is decoded
    long_or_short=(apid_size&0x10)>>4; //size of tc is known
        switch(apid)
        {
             case 1:             //apid=01 implies it corresponds to bae
             {
                   CDMS_TC_TM_FLAG|= BAE_TC_STATUS;
                   sc.printf("BAE\r\r\r\n");
                   uint8_t p_i2c_bae[long_or_short*124+11];
                   p_i2c_bae[0]=pac_seq_cnt;
                   p_i2c_bae[1]=apid_size;
                   sc.scanf("%d",&read); //services contains service_type and sub_service_type
                   p_i2c_bae[2] = read;
                   for(int i=3;i<(long_or_short*124+11);i++){
                      sc.scanf("%d",&read);
                      p_i2c_bae[i] = read;
                   }
                   sc.printf("informing BAE about TC using I2C\r\r\n");
                   CDMS_TC_TM_FLAG|= TC_I2C_BAE_STATUS;
                   int I2C_BAE; //interrupt to be sent to the bae
                   if(long_or_short==0)
                   I2C_BAE = FCTN_MASTER_I2C('s', (char *)p_i2c_bae);
                   else if(long_or_short==1)
                   I2C_BAE = FCTN_MASTER_I2C('l', (char *)p_i2c_bae);
                   else
                   sc.printf("long_or_short invalid\r\r\n");
                   sc.printf("send the packet + CRC to the BAE after receving i2c signal from BAE\r\r\n"); //packet along with crc will be sent when bae is ready
                   if(I2C_BAE!=0)
                   CDMS_TC_TM_FLAG|= TC_BAE_I2C_ERR ;
                   CDMS_TC_TM_FLAG &= ~(TC_I2C_BAE_STATUS);
                   CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                   
                
                   
            break;
            }
            case 3:
            {
                   CDMS_TC_TM_FLAG|= PL_TC_STATUS;
                   sc.printf("SPEED\r\r\n"); //speed corresponds to apid = 11
                   uint8_t p_i2c_speed[long_or_short*124+11];
                   p_i2c_speed[0]=pac_seq_cnt;
                   p_i2c_speed[1]=apid_size;
                   sc.scanf("%d",&read);
                   p_i2c_speed[2] = read; //services contains service_type and sub_service_type
                   for(int i=3;i<(long_or_short*124+11);i++){
                      sc.scanf("%d",&read);
                      p_i2c_speed[i] = read;
                   }
                   CDMS_TC_TM_FLAG|= TC_I2C_PL_STATUS;
                   sc.printf("inform PL about TC using I2C\r\r\n");
                   sc.printf("send the packet + CRC to the PL after receving i2c signal from PL\r\r\n");
                   //Check err in I2C
                   //if ERROR  CDMS_TC_TM_FLAG|= TC_PL_I2C_ERR ;
                   CDMS_TC_TM_FLAG &= ~(TC_I2C_PL_STATUS);
                   CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                   
            break;
            }
            case 2:
            {
                   CDMS_TC_TM_FLAG|= PL_TC_STATUS;
                   sc.printf("CDMS\r\r\n"); //apid = 10 corresponds to cdms
                   uint8_t services,appdata[long_or_short*124+6],crc[2];
                   sc.scanf("%d",&read);
                   services = read; //services contains service_type and sub_service_type
                   for(int i=3;i<(long_or_short*124+6);i++){
                      sc.scanf("%d",&read);
                      appdata[i-3] = read;
                   }
                   sc.scanf("%d",&read);
                   crc[0] = read;
                   sc.scanf("%d",&read);
                   crc[1] = read;
                   service_type=(services&0xF0)>>4;
                   sub_service_type=(services&0x0F);
                   switch(service_type){
                        case 6:
                        {
                               sc.printf("memory management syservice_typeem\r\r\n");
                               switch(sub_service_type){
                                    case 1:
                                    {
                                           sc.printf("READ FROM MEMORY\r\r\n");
                                           if(appdata[0]==2){             //appdata[0] is pid                     
                                            sc.printf("RD_L_FLASH1\r\r\n"); //tm is lmb
                        //P_CDMS_RD_FLASH

                                              for(int i=0;i<128;i++){
                                                telemetry_type1[i]=long_memory_block_tm[i-1]; 
                                              }
                                              for(int i=128;i<130;i++){
                                                telemetry_type1[i]=crc_tm[i-128];
                                              }
                                              
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                              
                                           }
                                           else if ((appdata[0]&0xF0)==0x10){
                                            sc.printf("RD_L_FLASH2\r\r\n"); //tm is lmb
                        //P_CDMS_RD_FLASH

                                              for(int i=0;i<128;i++){
                                                telemetry_type1[i]=long_memory_block_tm[i-1];
                                              }
                                              for(int i=128;i<130;i++){
                                                telemetry_type1[i]=crc_tm[i-128];
                                              }
                                              
                                                
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                           }
                                           else if (appdata[0]==0x22){
                                            sc.printf("RD_S_FLASH1\r\r\n"); //tm is smb
                        //P_CDMS_RD_FLASH

                                            telemetry_type2[0]=tmid3_spr_tm;
                                            telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                            telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                            for(int i=4;i<11;i++){
                                                  telemetry_type2[i]=small_memory_block_tm[i-4];
                                                }
                                              for(int i=11;i<13;i++){
                                                  telemetry_type2[i]=crc_tm[i-11];
                                                }
                                                
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                           }
                                           else if ((appdata[0]&0xF0)==0x30){
                                            sc.printf("RD_S_FLASH2\r\r\n"); //tm is smb
                        //P_CDMS_RD_FLASH

                                            telemetry_type2[0]=tmid3_spr_tm;
                                            telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                            telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                            for(int i=3;i<11;i++){
                                                  telemetry_type2[i]=small_memory_block_tm[i-3];
                                                }
                                              for(int i=11;i<13;i++){
                                                  telemetry_type2[i]=crc_tm[i-11];
                                                }
                                                
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                           }
                                           else if (appdata[0]==0x42){
                                            sc.printf("RD_L_RAM1\r\r\n"); //tm is lmb
                            //P_CDMS_RD_RAM

                                              for(int i=0;i<128;i++){
                                                telemetry_type1[i]=long_memory_block_tm[i-1];
                                              }
                                              for(int i=128;i<130;i++){
                                                telemetry_type1[i]=crc_tm[i-128];
                                              }
                                              
                                                
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                           }
                                           else if ((appdata[0]&0xF0)==0x50){
                                            sc.printf("RD_L_RAM2\r\r\n"); //tm is lmb
                        //P_CDMS_RD_RAM

                                              for(int i=0;i<128;i++){
                                                telemetry_type1[i]=long_memory_block_tm[i-1];
                                              }
                                              for(int i=128;i<130;i++){
                                                telemetry_type1[i]=crc_tm[i-128];
                                              }
                                              
                                                
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                           }
                                           else if (appdata[0]==0x62){
                                            sc.printf("RD_S_RAM\r\r\n"); //tm is smb
                        //P_CDMS_RD_RAM

                                            telemetry_type2[0]=tmid3_spr_tm;
                                            telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                            telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                            for(int i=3;i<11;i++){
                                                  telemetry_type2[i]=small_memory_block_tm[i-3];
                                                }
                                              for(int i=11;i<13;i++){
                                                  telemetry_type2[i]=crc_tm[i-11];
                                                }
                                                
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                           }
                                           else if ((appdata[0]&0xF0)==0x70){
                                            sc.printf("RD_S_RAM2\r\r\n"); //tm is smb
                        //P_CDMS_RD_RAM

                                            telemetry_type2[0]=tmid3_spr_tm;
                                            telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                            telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                            for(int i=3;i<11;i++){
                                                  telemetry_type2[i]=small_memory_block_tm[i-3];
                                                }
                                              for(int i=11;i<13;i++){
                                                  telemetry_type2[i]=crc_tm[i-11];
                                                }
                                                
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                           }
                    else {
                        sc.printf("INVALID TC");
                        //Send Invalid TC Telemetry
                          
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                    }
                                    break;
                                    }
                                    case 5:
                                    {
                                           sc.printf("WRITE ON MEMORY\r\r\n");
                                           switch(appdata[0]){
                                                case 0:sc.printf("WR_S_FLASH\r\r\n");
                        //P_CDMS_WR_FLASH
                                                 telemetry_type2[0]=0XB0;
                                                 telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                                 telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                                 telemetry_type2[3]=ackcode_tm;
                                            for(int i=4;i<11;i++){
                                                  telemetry_type2[i]=0X00;
                                                }
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);

                                                break;
                                                case 1:sc.printf("WR_S_RAM\r\r\n");
                        //P_CDMS_WR_RAM
                                                 telemetry_type2[0]=0XB0;
                                                 telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                                 telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                                 telemetry_type2[3]=ackcode_tm;
                                            for(int i=4;i<11;i++){
                                                  telemetry_type2[i]=0X00;
                                                }

                                                break;
                                                case 16:sc.printf("WR_L_FLASH\r\r\n");
                                                 telemetry_type2[0]=0XB0;
                                                 telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                                 telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                                 telemetry_type2[3]=ackcode_tm;
                                            for(int i=4;i<11;i++){
                                                  telemetry_type2[i]=0X00;
                                                }
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                        //P_CDMS_WR_FLASH

                                                break;
                                                case 17:sc.printf("WR_L_RAM\r\r\n");
                                                //P_CDMS_WR_RAM
                                                 telemetry_type2[0]=0XB0;
                                                 telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                                 telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                                 telemetry_type2[3]=ackcode_tm;
                                            for(int i=4;i<11;i++){
                                                  telemetry_type2[i]=0X00;
                                                }
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);

                                                break;
                        default:{sc.printf("INVALID TC");
                            //send invalid TC TM
                              
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                             break;}
                                           }
                                    break;
                                    }
                                    case 6:
                                    {
                                           sc.printf("WRITE FROM ONE MEMORY TO ANOTHER\r\r\n");
                                           switch(appdata[0]){
                                                case 0:sc.printf("WR_S_FLASH\r\r\n");
                        //P_CDMS_WR_FLASH
                                                 telemetry_type2[0]=0XB0;
                                                 telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                                 telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                                 telemetry_type2[3]=ackcode_tm;
                                            for(int i=4;i<11;i++){
                                                  telemetry_type2[i]=0X00;
                                                }
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                                break;
                                                case 1:sc.printf("WR_S_RAM\r\r\n");
                        //P_CDMS_WR_RAM
                                                 telemetry_type2[0]=0XB0;
                                                 telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                                 telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                                 telemetry_type2[3]=ackcode_tm;
                                            for(int i=4;i<11;i++){
                                                  telemetry_type2[i]=0X00;
                                                }
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                                break;
                                                case 16:sc.printf("WR_L_FLASH\r\r\n");
                        //P_CDMS_WR_FLASH
                                                 telemetry_type2[0]=0XB0;
                                                 telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                                 telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                                 telemetry_type2[3]=ackcode_tm;
                                            for(int i=4;i<11;i++){
                                                  telemetry_type2[i]=0X00;
                                                }
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                                break;
                                                case 17:sc.printf("WR_L_RAM\r\r\n");
                        //P_CDMS_WR_RAM
                                                 telemetry_type2[0]=0XB0;
                                                 telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                                 telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                                 telemetry_type2[3]=ackcode_tm;
                                            for(int i=4;i<11;i++){
                                                  telemetry_type2[i]=0X00;
                                                }
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                                break;
                        default:{sc.printf("INVALID TC");
                            //send invalid TC TM
                              
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                             break;}
                                           }
                                    break;
                                    }
                                    case 9:
                                    {
                                           sc.printf("SEND CRC OF FLASH MEMORY\r\r\n");
                                           if(appdata[0]==2){
                                            sc.printf("GET_FLASH_CRC\r\r\n"); //tm is crc_flash
                        //P_CDMS_GET_FLASH_CRC

                                          for(int i=0;i<2;i++){
                                                telemetry_type1[i]=crc1_tm[i];
                                              }
                                            for(int i=2;i<4;i++){
                                                telemetry_type1[i]=crc2_tm[i-2];
                                              }
                                            for(int i=128;i<130;i++){
                                                telemetry_type1[i]=crc_tm[i-128];
                                              }
                                                
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                           }
                    else {
                        sc.printf("INVALID TC");
                        //Send Invalid TC Telemetry
                          
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                    }
                                    break;
                                    }
                    default:{sc.printf("INVALID TC");
                            //send invalid TC TM
                              
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                             break;}
                                }
                        break;
                        }
                        case 8:
                        {
                               sc.printf("FCTNTION MANAGEMENT SERVICE\r\r\n"); 
                               if(sub_service_type==1){
                                if((appdata[0]&0xF0)==0x00){
                                    sc.printf("RUN_PRCS\r\r\n");
                                    switch(appdata[0]){
                                        case 1:sc.printf("P_PL_INIT\r\r\n");//tm is ack_l234
                    //P_PL_INIT
                                        telemetry_type2[0]=tmid2_spr_tm;
                                            telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                            telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                            telemetry_type2[3]=ackcode_tm;
                                            for(int i=3;i<11;i++){
                                                  telemetry_type2[i]=0x00;
                                                }
                                              for(int i=11;i<13;i++){
                                                  telemetry_type2[i]=crc_tm[i-11];
                                                }
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                        break;
                                        case 2:sc.printf("P_PL_MNGR\r\r\n");//tm is ack_l234
                    //P_PL_MNGR
                                        telemetry_type2[0]=tmid2_spr_tm;
                                            telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                            telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                            telemetry_type2[3]=ackcode_tm;
                                            for(int i=3;i<11;i++){
                                                  telemetry_type2[i]=0x00;
                                                }
                                              for(int i=11;i<13;i++){
                                                  telemetry_type2[i]=crc_tm[i-11];
                                                }
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                        break;
                                        case 3:sc.printf("P_COM_INIT\r\r\n");//tm is ack_l234
                    //P_COM_INIT
                                        telemetry_type2[0]=tmid2_spr_tm;
                                            telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                            telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                            telemetry_type2[3]=ackcode_tm;
                                            for(int i=3;i<11;i++){
                                                  telemetry_type2[i]=0x00;
                                                }
                                              for(int i=11;i<13;i++){
                                                  telemetry_type2[i]=crc_tm[i-11];
                                                }
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                        break;
                                        case 4:sc.printf("P_CDMS_HK_MNGR\r\r\n");//tm is ack_l234
                    //P_CDMS_HK_MNGR
                                        telemetry_type2[0]=tmid2_spr_tm;
                                            telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                            telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                            telemetry_type2[3]=ackcode_tm;
                                            for(int i=3;i<11;i++){
                                                  telemetry_type2[i]=0x00;
                                                }
                                              for(int i=11;i<13;i++){
                                                  telemetry_type2[i]=crc_tm[i-11];
                                                }
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                        break;
                    default:{sc.printf("INVALID TC");
                    
                            //send invalid TC TM
                              
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                             break;}
                                    }
                                }
                                else if((appdata[0]&0xF0)==0x10){
                                    sc.printf("PWR_SWCH\r\r\n");
                    //P_CDMS_SWCH_PWR

                                }
                                else if((appdata[0]&0xF0)==0x20){
                                    sc.printf("PWR_Rservice_type\r\r\n");
                    //P_CDMS_RST_PWR

                                }
                                        else if((appdata[0]&0xF0)==0xE0){
                                        sc.printf("RD_RTC\r\n"); //tm is func_mngmt_service_tm
                                        telemetry_type2[0]=tmid4_spr_tm;
                                        telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                        telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                        for(int i=11;i<13;i++)
                                        {
                                              telemetry_type2[i]=crc_tm[i-11];
                                        }
                                        CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                        //Send IM
                                        //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                         CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                    } 
                                else if((appdata[0]&0xF0)==0xF0){
                                    sc.printf("SD_MNGR\r\r\n"); //tm is func_mngmt_service_tm
                    //P_CDMS_MNG_SD

                                    telemetry_type2[0]=tmid4_spr_tm;
                                    telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                    telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                    for(int i=3;i<11;i++){
                                          telemetry_type2[i]=func_mngmt_service_tm[i-3];
                                        }
                                      for(int i=11;i<13;i++){
                                          telemetry_type2[i]=crc_tm[i-11];
                                        }
                                        
                                          
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                }
                else {
                        sc.printf("INVALID TC");
                        //Send Invalid TC Telemetry
                          
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                    }
                               }
                else {
                        sc.printf("INVALID TC");
                        //Send Invalid TC Telemetry
                          
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                    }
                        break;
                        }
                        case 7:
                        {
                               sc.printf("PAYLOAD MANAGEMENT SERVICE\r\r\n"); //TM is ACKL234
                               switch(sub_service_type){
                                    case 1:sc.printf("INSERT PL SCHEDULE\r\r\n");
                                      telemetry_type2[0]=tmid2_spr_tm;
                                            telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                            telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                            telemetry_type2[3]=ackcode_tm;
                                            for(int i=3;i<11;i++){
                                                  telemetry_type2[i]=0x00;
                                                }
                                              for(int i=11;i<13;i++){
                                                  telemetry_type2[i]=crc_tm[i-11];
                                                }
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                    break;
                                    case 2:sc.printf("DELETE PL SCHEDULE\r\r\n");
                                        telemetry_type2[0]=tmid2_spr_tm;
                                            telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                            telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                            telemetry_type2[3]=ackcode_tm;
                                            for(int i=3;i<11;i++){
                                                  telemetry_type2[i]=0x00;
                                                }
                                              for(int i=11;i<13;i++){
                                                  telemetry_type2[i]=crc_tm[i-11];
                                                }
                                                  
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                    break; 
                       default:{sc.printf("INVALID TC");
                            //send invalid TC TM
                              
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                             break;}
                               }
                        break;
                        }
                        case 11:
                        {
                                sc.printf("ONBOARD OPERATIONS SCHEDULING SERVICE\r\r\n");
                                switch(sub_service_type){
                                    case 1:
                                    {
                                           sc.printf("DISABLE RELEASE OF TCs\r\r\n"); //tm is ack_l1
                                           telemetry_type2[0]=tmid1_spr_tm;
                                           telemetry_type2[1]=tc_exec_tm;
                                           telemetry_type2[2]=tc_service_typeatus_tm;
                                           for(int i=3;i<11;i++){
                                                telemetry_type2[i]=pac_seq_cnt_of_tc_tm[i-3];
                                               }
                                             for(int i=11;i<13;i++){
                                                telemetry_type2[i]=crc_tm[i-11];
                                              }
                                                
                                             
                                    break;
                                    }
                                    case 2:
                                    {
                                      sc.printf("ENABLE RELEASE OF TCs\r\r\n");
                                    break;
                                    }
                                    case 5:
                                    {
                                      sc.printf("DELETE TELECOMMANDS\r\r\n");
                                    break;
                                    }
                                    case 6:
                                    {
                                      sc.printf("REPORT TC LIST IN DETAILED FORM\r\r\n"); //tm is tc_liservice_type 
                                           for(int i=0;i<9;i++){
                                              telemetry_type1[i]=tc_liservice_type_packet1_tm[i];
                                               }
                                           for(int i=9;i<18;i++){
                                              telemetry_type1[i]=tc_liservice_type_packet2_tm[i-9];
                                              }
                                           for(int i=128;i<130;i++){
                                              telemetry_type1[i]=crc_tm[i-128];
                                            }
                                    break;
                                    }
                                    case 8:
                                    {
                                           sc.printf("REPORT STATUS OF TC LIST\r\r\n"); //tm is ack_l1
                                           telemetry_type2[0]=tmid1_spr_tm;
                                           telemetry_type2[1]=tc_exec_tm;
                                           telemetry_type2[2]=tc_service_typeatus_tm;
                                           for(int i=3;i<11;i++){
                                                telemetry_type2[i]=pac_seq_cnt_of_tc_tm[i-3];
                                               }
                                             for(int i=11;i<13;i++){
                                                telemetry_type2[i]=crc_tm[i-11];
                                              }
                                    break;
                                    }
                                    case 15:
                                    {
                                            sc.printf("REPORT STATUS OF LAST UNEXECUTED TC\r\r\n"); //tm is ack_l234
                                            telemetry_type2[0]=tmid2_spr_tm;
                                            telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                            telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                            telemetry_type2[3]=ackcode_tm;
                                            for(int i=3;i<11;i++){
                                                  telemetry_type2[i]=0x00;
                                                }
                                              for(int i=11;i<13;i++){
                                                  telemetry_type2[i]=crc_tm[i-11];
                                                }
                                    break;
                                    }
                     default:{sc.printf("INVALID TC");
                            //send invalid TC TM
                             break;}
                                }
                        break;
                        }
                        case 13:
                        {
                               sc.printf("LARGE DATA TRANSFER\r\r\n");  //tm is ack_l234
                                telemetry_type2[0]=tmid2_spr_tm;
                                            telemetry_type2[1]=tc_pac_seq_cnt_tm;
                                            telemetry_type2[2]=tm_pac_seq_cnt_tm;
                                            telemetry_type2[3]=ackcode_tm;
                                            for(int i=3;i<11;i++){
                                                  telemetry_type2[i]=0x00;
                                                }
                                              for(int i=11;i<13;i++){
                                                  telemetry_type2[i]=crc_tm[i-11];
                                                }
                        break;
                        }
                        case 15:
                        {
                                sc.printf("ONBOARD STORAGE AND RETRIEVAL SERVICE\r\r\n");
                                switch(sub_service_type){
                                    case 0:
                                    {
                                           sc.printf("SCF\r\r\n"); //tm is obsrs
                                           telemetry_type1[0]=frmseqcnt_fileheadpointer_tm;
                                           for(int i=1;i<128;i++){
                                             telemetry_type1[i]=multi_obsrs_tm_packets[i-1];
                                           }
                                           for(int i=128;i<130;i++){
                                             telemetry_type1[i]=crc_tm[i-128];
                                           }
                                    break;
                                    }
                                    case 1:
                                    {
                                           sc.printf("SFF-AT\r\r\n");
                                           telemetry_type1[0]=frmseqcnt_fileheadpointer_tm; //tm is obsrs
                                           for(int i=1;i<128;i++){
                                             telemetry_type1[i]=multi_obsrs_tm_packets[i-1];
                                           }
                                           for(int i=128;i<130;i++){
                                             telemetry_type1[i]=crc_tm[i-128];
                                           }
                                             
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                    break;
                                    }
                                    case 2:
                                    {
                                           sc.printf("SFF-BT\r\r\n"); //tm is obsrs
                                           telemetry_type1[0]=frmseqcnt_fileheadpointer_tm;
                                           for(int i=1;i<128;i++){
                                             telemetry_type1[i]=multi_obsrs_tm_packets[i-1];
                                           }
                                           for(int i=128;i<130;i++){
                                             telemetry_type1[i]=crc_tm[i-128];
                                           }
                                             
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                    break;
                                    }
                                    case 3:
                                    {
                                           sc.printf("LOG\r\r\n"); //tm is obsrs
                                           telemetry_type1[0]=frmseqcnt_fileheadpointer_tm;
                                           for(int i=1;i<128;i++){
                                             telemetry_type1[i]=multi_obsrs_tm_packets[i-1];
                                           }
                                           for(int i=128;i<130;i++){
                                             telemetry_type1[i]=crc_tm[i-128];
                                           }
                                             
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                    break;
                                    }
                                    case 4:
                                    {
                                           sc.printf("HK_ARCHIVE\r\r\n"); //tm is obsrs
                                           telemetry_type1[0]=frmseqcnt_fileheadpointer_tm;
                                           for(int i=1;i<128;i++){
                                             telemetry_type1[i]=multi_obsrs_tm_packets[i-1];
                                           }
                                           for(int i=128;i<130;i++){
                                             telemetry_type1[i]=crc_tm[i-128];
                                           }
                                             
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                                    break;
                                    }
                                   default:{sc.printf("INVALID TC");
                            //send invalid TC TM
                              
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                            break;
                             }
                                } 
                        break;
                        }
                 default:{sc.printf("INVALID TC");
                         //send invalid TC TM
                           
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                        break;
                         }
                   }
            break;
            }
          default:{sc.printf("INVALID TC");
                   //send invalid TC TM
                     
                                              CDMS_TC_TM_FLAG|= TX_TM_STATUS;
                                              //Send IM
                                              //if ERR in TM CDMS_TC_TM_FLAG|= TX_TM_ERROR
                                               CDMS_TC_TM_FLAG &=~(CDMS_TC_TM_STATUS);
                   break;
                   }
        }

}
