#include "mbed.h"
#include "PL.h"
#include "all_funcs.h"
#include "Flags.h"
#include "pin_config.h"

SPISlave pl_spi(PIN16, PIN17, PIN15, PIN14); // mosi, miso, sclk, ssel --> using SPI1

Serial sr(USBTX,USBRX);

void FCTN_PL_RCV_SC_DATA()
{
    sr.printf("in FCTN_PL_RCV_SC_DATA\r\n");
    uint8_t scienceRawPacket[payloadBins];
    for(int i=0; i<payloadBins; i++) 
    {
        while(!pl_spi.receive()); // blocking statement --> waiting for data from Payload
        uint8_t v = pl_spi.read();   // Read byte from master
        scienceRawPacket[i] = v;
    }
    // serial feedback
    sr.printf("Packet recieved\r\r\n");
    for(int i=0; i<payloadBins; i++) 
    {
        sr.printf("%0x\t",scienceRawPacket[i]);
        scienceRawPacket[i] = 0;
    }
    sr.printf("\r\r\n");
}

void FCTN_PL_SCIENCE()
{
   all_flags|=PL_SCIENCE_STATUS;
   FCTN_PL_RCV_SC_DATA();
   if(all_flags&IS_FIRST_TIME_SC_DATA == 0)                          //What happens to TIME_ELAPSED_LAST_SRP on reset? Should it be stored in Flash?  
   {
         TIME_ELAPSED_LAST_SRP=SRP_INTER_VAL_COUNTER;
         SRP_INTER_VAL_COUNTER.reset();
   }
   else
   {
         SRP_INTER_VAL_COUNTER.start();
         all_flags&=(~IS_FIRST_TIME_SC_DATA);
   }
   if(all_flags&IS_PL_FRAME_SIZE_CORRECT == 1)                      //How to identify FRAME_SIZE or size of data that is received via SPI?
   {
    //FCTN_COM_COMP_SC_DATA(scienceRawPacket);       
    //FCTN_WR_SD(const uint8_t *, uint64_t)        //Store SD     
    //FCTN_CDMS_WR_FLASH();                        //
    all_flags|=PL_FRAME_SIZE_CORRECT;
  }
   if(all_flags&IS_PL_FRAME_SIZE_CORRECT == 0)
    {
        //FCTN_WR_SD(const uint8_t *, uint64_t)
        //FCTN_CDMS_WR_FLASH();
          all_flags&=~(PL_FRAME_SIZE_CORRECT);
    }
    if(TIME_ELAPSED_LAST_SRP>4)
    {
        //FCTN_CDMS_WR_FLASH();
        all_flags|= TIME_ELAPSED_LAST_SRP_INTERVAL_HIGH;
    }
    if(TIME_ELAPSED_LAST_SRP<2)
    {
        //FCTN_CDMS_WR_FLASH();
        all_flags|= TIME_ELAPSED_LAST_SRP_INTERVAL_LOW;
    }
    all_flags&=~(PL_SCIENCE_STATUS);
}
        
void FCTN_PL_MAIN()
{
    all_flags|=PL_MAIN_STATUS;
    all_flags&=~(PL_LOW_POWER);
    all_flags = all_flags|((all_flags&PL_STATE)<<2); //pl_prev_state = pl_state;
    if(all_flags&IS_PL_SCHEDULE == 1)  //is pl_schedule == 1
    {
        all_flags = (all_flags&(~PL_STATE))|pl_schedule_TC;
    } 
    else 
    {
        if((all_flags&PL_PREV_STATE) == PL_SCIENCE) 
        {
            all_flags = (all_flags&(~PL_STATUS))|PL_HIBERNATE;
        } 
        else
        {
            all_flags = (all_flags&(~PL_STATE))|((all_flags&PL_PREV_STATE)>>2); //pl_state = pl_prev_state;
        }
    }
    switch(all_flags&PL_STATE) 
    {
        case PL_OFF: 
        {
            if(all_flags&PL_PREV_STATE!=PL_OFF) 
            {
                sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
            }
            sr.printf("Power off SPEED\r\n");
            all_flags = (all_flags&(~PL_STATUS))|PL_OFF;
            sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
            all_flags = all_flags&(~PL_MAIN_STATUS);
        }
        case PL_STANDBY: 
        {
            if(power_level<0) 
            {
                all_flags = all_flags|PL_LOW_POWER;
                if(all_flags&PL_PREV_STATE!=PL_OFF) 
                {
                    sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
                }
                sr.printf("Power off SPEED\r\n");
                all_flags = (all_flags&(~PL_STATUS))|PL_OFF;
                sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
                all_flags = all_flags&(~PL_MAIN_STATUS);
            } 
            else 
            {
                if(all_flags&PL_PREV_STATE!=PL_OFF) 
                {
                    sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
                    sr.printf("Power OFF SPEED PMTs\r\n");
                    if(all_flags&IS_I2C_ACK == 1) 
                    {
                        all_flags = (all_flags&(~PL_STATUS))|PL_STANDBY;                   } 
                    else 
                    {
                        all_flags = (all_flags&(~PL_STATUS))|PL_ERR_I2C;
                    }
                    sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
                    all_flags = all_flags&(~PL_MAIN_STATUS);
                } 
                else 
                {
                    sr.printf("Power on SPPED DL\r\n");
                    sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
                    if(all_flags&IS_I2C_ACK == 1) 
                    {
                        all_flags = (all_flags&(~PL_STATUS))|PL_STANDBY;
                    } 
                    else 
                    {
                        all_flags = (all_flags&(~PL_STATUS))|PL_ERR_I2C;
                    }
                    sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
                    all_flags = all_flags&(~PL_MAIN_STATUS);
                }
            }
        }
        case PL_HIBERNATE: 
        {
            if(power_level<1) 
            {
                all_flags = all_flags|PL_LOW_POWER;
                if(power_level<0) 
                {
                    if(all_flags&PL_PREV_STATE!=PL_OFF) 
                    {
                        sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
                    }
                    sr.printf("Power off SPEED\r\n");
                    all_flags = (all_flags&(~PL_STATUS))|PL_OFF;
                    sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
                    all_flags = all_flags&(~PL_MAIN_STATUS);
                } 
                else 
                {
                    if(all_flags&PL_PREV_STATE!=PL_OFF) 
                    {
                        sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
                        sr.printf("Power OFF SPEED PMTs\r\n");
                        if(all_flags&IS_I2C_ACK == 1) 
                        {
                            all_flags = (all_flags&(~PL_STATUS))|PL_STANDBY;                   } 
                        else 
                        {
                            all_flags = (all_flags&(~PL_STATUS))|PL_ERR_I2C;
                        }
                        sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
                        all_flags = all_flags&(~PL_MAIN_STATUS);
                    } 
                    else 
                    {
                        sr.printf("Power on SPPED DL\r\n");
                        sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
                        if(all_flags&IS_I2C_ACK == 1) 
                        {
                            all_flags = (all_flags&(~PL_STATUS))|PL_STANDBY;
                        } 
                        else 
                        {
                            all_flags = (all_flags&(~PL_STATUS))|PL_ERR_I2C;
                        }
                        sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
                        all_flags = all_flags&(~PL_MAIN_STATUS);
                    }
                }
            }
            else if(power_level>1) 
            {
                if(all_flags&PL_PREV_STATE==PL_OFF) 
                {
                    sr.printf("Power on SPEED DL\r\n");
                }
                sr.printf("Power on Speed PMT with reduced Voltage\r\n");
                sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
                if(all_flags&IS_I2C_ACK == 1) 
                {
                    all_flags = (all_flags&(~PL_STATUS))|PL_HIBERNATE;                   
                } 
                else 
                {
                    all_flags = (all_flags&(~PL_STATUS))|PL_ERR_I2C;
                }
                sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
                all_flags = all_flags&(~PL_MAIN_STATUS);
            }
        }
        case PL_SCIENCE: 
        {
            if(power_level<2) 
            {
                if(power_level<1) 
                {
                    all_flags = all_flags|PL_LOW_POWER;
                    if(power_level<0) 
                    {
                        if(all_flags&PL_PREV_STATE!=PL_OFF) 
                        {
                            sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
                        }
                        sr.printf("Power off SPEED\r\n");
                        all_flags = (all_flags&(~PL_STATUS))|PL_OFF;
                        sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
                        all_flags = all_flags&(~PL_MAIN_STATUS);
                    } 
                    else 
                    {
                        if(all_flags&PL_PREV_STATE!=PL_OFF) 
                        {
                            sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
                            sr.printf("Power OFF SPEED PMTs\r\n");
                            if(all_flags&IS_I2C_ACK == 1) 
                            {
                                all_flags = (all_flags&(~PL_STATUS))|PL_STANDBY;                   } 
                            else 
                            {
                                all_flags = (all_flags&(~PL_STATUS))|PL_ERR_I2C;
                            }
                            sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
                            all_flags = all_flags&(~PL_MAIN_STATUS);
                        } 
                        else 
                        {
                            sr.printf("Power on SPPED DL\r\n");
                            sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
                            if(all_flags&IS_I2C_ACK == 1) 
                            {
                                all_flags = (all_flags&(~PL_STATUS))|PL_STANDBY;
                            } 
                            else 
                            {
                                all_flags = (all_flags&(~PL_STATUS))|PL_ERR_I2C;
                            }
                            sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
                            all_flags = all_flags&(~PL_MAIN_STATUS);
                        }
                    }
                }
                else if(power_level>1) 
                {
                    if(all_flags&PL_PREV_STATE==PL_OFF) 
                    {
                        sr.printf("Power on SPEED DL\r\n");
                    }
                    sr.printf("Power on Speed PMT with reduced Voltage\r\n");
                    sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
                    if(all_flags&IS_I2C_ACK == 1) 
                    {
                        all_flags = (all_flags&(~PL_STATUS))|PL_HIBERNATE;                   } 
                    else 
                    {
                        all_flags = (all_flags&(~PL_STATUS))|PL_ERR_I2C;
                    }
                    sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
                    all_flags = all_flags&(~PL_MAIN_STATUS);
                }
            }
            else if(power_level>2) 
            {
                if(all_flags&PL_PREV_STATE==PL_SCIENCE) 
                {
                    all_flags = (all_flags&(~PL_STATUS))|PL_SCIENCE;
                    all_flags = all_flags&(~PL_MAIN_STATUS);
                } 
                else if(all_flags&PL_PREV_STATE==PL_HIBERNATE) 
                {
                    sr.printf("Power on SPEED PMT with high voltage \r\n");
                    sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
                    if(all_flags&IS_I2C_ACK == 1) 
                    {
                        sr.printf("Enable SRP_INTERVAL_COUNTER\r\n");
                        all_flags = (all_flags&(~PL_STATUS))|PL_SCIENCE;
                        all_flags = all_flags&(~PL_MAIN_STATUS);
                    } 
                    else 
                    {
                        all_flags = (all_flags&(~PL_STATUS))|PL_ERR_I2C;
                        sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
                        all_flags = all_flags&(~PL_MAIN_STATUS);
                    }
                } 
                else

                {
                    if(all_flags&PL_PREV_STATE!=PL_OFF) 
                    {
                        sr.printf("Power on SPEED DL\r\n");
                    }
                    sr.printf("Power on Speed PMT with reduced Voltage\r\n");
                    sr.printf("Command SPEED DL to go to Standby State (I2C) \r\n");
                    if(all_flags&IS_I2C_ACK == 1) 
                    {
                        all_flags = (all_flags&(~PL_STATUS))|PL_HIBERNATE;                   
                    } 
                    else 
                    {
                        all_flags = (all_flags&(~PL_STATUS))|PL_ERR_I2C;
                    }
                    sr.printf("Disable SRP_INTERVAL_COUNTER\r\n");
                    all_flags = all_flags&(~PL_MAIN_STATUS);
                }
            }
        }
    }
}