
class WatchDog {
	static const uint8_t WDT_TIMEOUT = 10; // sec

public:
	static void init() {
		// timeout [s] = (CRV + 1) / 32768;
		// crv = 32768 * timeout - 1
		NRF_WDT->CRV = 32768 * WDT_TIMEOUT - 1;
		NRF_WDT->CONFIG = WDT_CONFIG_SLEEP_Pause << WDT_CONFIG_SLEEP_Pos;
		NRF_WDT->TASKS_START = 1;
		NRF_WDT->RREN = WDT_RREN_RR0_Enabled << WDT_RREN_RR0_Pos;
	}

	static void reload() {
		NRF_WDT->RR[0] = WDT_RR_RR_Reload;
	}

};
