
#ifndef __HIDController_H__
#define __HIDController_H__

enum Status_t {
	DISCONNECTED,
	CONNECTING,
	CONNECTED,
	TIMEOUT,
	ADVERTISING,
};

class HIDController {
public:
	static void init();
	static void waitForEvent();
	static bool connected();
	static Status_t status();
	static const char* statusString();

	static void appendReportData(const uint8_t key);
	static void deleteReportData(const uint8_t key);
	static void pressConsumerKey(const uint16_t key);
	static void releaseConsumerKey();
	static void queueCurrentReportData();
	static void updateBatteryLevel(const uint8_t percentage, const uint16_t voltage);
	static void initializeConnection(const bool ignoreWhiteList);
};

#endif
