//E233SideLED E233系側面LED再現
//Ver:0.90

//簡単な説明,また表示データを以下で配布しています。
//https://chirashitech.wordpress.com/

//このソースはSDカードが存在することが前提です。
//SDカードがない状態で停車駅スクロールが有効になっている場合エラー文が出力されるため起動までに時間がかかります。
//SDカードがない場合ScrollEnableを0にしてください。


#include "mbed.h"
#include "SDFileSystem.h"

#define bitRead(value, bit) (((value) >> (bit)) & 0x01)
#define bitSet(value, bit) ((value) |= (1UL << (bit)))
#define bitClear(value, bit) ((value) &= ~(1UL << (bit)))
#define bitWrite(value, bit, bitvalue) (bitvalue ? bitSet(value, bit) : bitClear(value, bit))

#define LOW 0
#define HIGH 1

#define R_Debug1 0
#define R_Debug2 0
#define R_Debug3 0
#define R_Debug4 0

#define G_Debug1 0
#define G_Debug2 0
#define G_Debug3 0
#define G_Debug4 0

#define B_Debug1 0
#define B_Debug2 0
#define B_Debug3 0
#define B_Debug4 0

//表示幅を増やす場合ここ以外も変更が必要
#define LED_Width 128
#define LED_Height 16

//表示処理Wait
//ここを変更することで輝度調整可能
//ただし消費電力も変動します。出力に余裕のない電源を利用している場合変更しないでください
#define DisplayWait 15

//最大停車駅数
#define MaxStopStation 100

//将来的な複数機器連動用の機器ID
//0:全機器一斉送信用 1:前面LED 2:側面LED(暫定)
#define DeviceID 2 


//SDCard
//MOSI - D11(PA7)
//MISO - D12(PA6)
//SCK  - D13(PA5)
//CS   - D10(PB6)

SDFileSystem sd(D11, D12, D13, D10, "sd");

//Serial USB
Serial pc(USBTX,USBRX );

//Bluetooth Serial6
//Serial pc(PA_11,PA_12 );


//LEDModule
//R1,R2,G1,G2,B1,B2はモジュールによりコネクタのピンアサインが異なります。
//色が違う場合DigitalOutのピンアサインを変更してください。

//R1  - D4(PB5)
//R2  - D5(PB4)
//G1  - D6(PB10)
//G2  - D7(PA8)
//B1  - D2(PA10)
//B2  - D3(PB3)
//or
//R1  - D6(PB5)
//R2  - D7(PB4)
//G1  - D2(PB10)
//G2  - D3(PA8)
//B1  - D4(PA10)
//B2  - D5(PB3)

//A   - D8(PA9)
//B   - D9(PC7)
//C   - PB13
//D   - PC5

//CLK - PB14
//LAT - PB15
//OE  - PB1

BusOut ABC(D8,D9,PB_13,PC_5); // Row address.
DigitalOut CLK(PB_14);    //  Data clock    - rising edge
DigitalOut LAT(PB_15);    //  Data latch    - active low (pulse up after data load)
DigitalOut OE(PB_1);     //  Output enable - active low (hold high during data load, bring low after LAT pulse)

DigitalOut R1(D4);     //  RED   Serial in for upper half
DigitalOut R2(D5);     //  RED   Serial in for lower half
DigitalOut G1(D6);      //  GREEN Serial in for upper half
DigitalOut G2(D7);      //  GREEN Serial in for lower half
DigitalOut B1(D2);      //  BLUE  Serial in for upper half
DigitalOut B2(D3);      //  BLUE  Serial in for lower half


//SumSW(現状未使用)
DigitalOut SCK(PB_7); 
DigitalOut SI(PC_13); 
DigitalOut RCK(PC_14); 

DigitalIn SumSW1(PA_0);
DigitalIn SumSW2(PA_1);
DigitalIn SumSW4(PA_4);
DigitalIn SumSW8(PB_0);
//BusIn SumSWNum(PA_0,PA_1,PA_4,PB_0);

DigitalIn Button1 (USER_BUTTON);

//表示切替用タイマ
Ticker ChangeTimer;
//表示切替用タイマ(テスト表示用)
Ticker ChangeTimerTest;


//スクロール用タイマ
Ticker ScrollTimer;






//Debug
bool Debug = 0;


//Mode(未使用?)
//1固定
int WriteMode = 1;



//1:3段階 LEDBuffer-LEDBuffer2-LEDBuffer3
//2:2段階 LEDBuffer5-LEDBuffer6
//3:固定  LEDBuffer
//4:2段階 LEDBuffer2-LEDBuffer3(次駅あり)
//5:4段階 LEDBuffer-LEDBuffer4-LEDBuffer2-LEDBuffer3
int DisplayMode = 1;

//スクロール有効/無効
bool Scroll = 1;

//起動時スクロール読み込み有効/無効(SDがない場合0にする)
//(1になっている場合SDカードが刺さっていないと起動に数分かかります)
bool ScrollEnable = 1;


int ChangeCount = 0;
//テスト表示用
int ChangeCountTest = 0;
//路線コード
int LineNumber = 1;
//種別コード
int KindNumber = 22;
//行先コード
int ForNumber = 114;
//次駅コード
int NextStaNumber = 1;
//運用パターン番号
int RoutePatternNumber = 1;
//始発駅コード
int DeptStaNumber = 3;
//終着駅コード
int TermStaNumber = 32;


char SerialBuffer[60];
//シリアル処理用バッファ
char ABuffer[60];
bool busyflag = false;
int count = 0;

//スクロール用変数
int ScrollCount = 0;
int ScrollWriteCount = 80;


//SDCardFilePath
char SDFilePath[80]= "/sd/a.txt";

unsigned long CT;         

//StopStationCode:停車駅コード(最大100駅 それ以上の場合MaxStopStationを増やしてください)
//停車駅コード終端は0にする
//StationNameLength:駅名の文字数(最大8文字)
int StopStationCode[MaxStopStation] = {320,319,318,317,316,315,314,313,312,311,310,309,308,307,306,305,304,303,302,301,351,352,353,354,355,356,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,416,417,418,419,420,421,422,423,424,425,426,0};
int StationNameLength[100] = {0,2,2,4,3,3,3,3,3,4,3,2,3,3,2,3,4,2,3,3,2,3,4,5,3,4,2,2,2,2,3,4,2,3,2,3,3,2,2,2,2,3,3,2,2,3,3,7,4,2,3,1,5,3,3,3,8,3}; 




int8_t LEDBuffer [32][LED_Width] = {
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,15,15,15,15,15,15,15,15,7,7,7,7,7,7,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,15,15,15,15,15,15,15,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{15,15,15,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,15,15,15,15,15,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,0,0,0,0,0,0,0,0,7,7,7,0,0,7,7,7,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,0,0,0,0,0,0,0,0,7,7,7,0,0,7,7,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,7,7,7,15,0,0,0,0,0,0,0,0,0,15,7,7,7,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,7,0,0,0,0,0,0,0,7,7,7,0,0,7,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,7,7,7,15,0,0,0,0,0,0,0,15,7,7,7,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,7,7,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,15,0,0,0,0,0,15,7,7,7,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,7,7,7,0,0,0,0,0,7,7,7,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,15,0,0,0,15,7,7,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,7,7,7,7,0,0,0,0,7,7,7,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,15,0,15,7,7,7,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,7,7,7,7,7,0,0,0,7,7,7,0,0,0,0,0,0,7,7,7,15,15,15,15,15,15,15,15,15,15,15,0,0,0,0,0,0,0,7,7,15,1,15,7,7,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,0,7,7,7,7,7,0,0,7,7,7,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,0,0,7,7,7,7,7,0,7,7,7,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,0,0,0,7,7,7,7,7,7,7,7,0,0,0,0,0,0,7,7,7,15,15,15,15,15,15,15,15,15,15,15,0,0,0,0,0,0,0,15,7,1,1,1,7,15,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,0,0,0,0,7,7,7,7,7,7,7,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,0,7,7,7,15,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,0,0,0,0,0,7,7,7,7,7,7,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,0,0,0,7,7,7,15,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,0,0,0,0,0,0,7,7,7,7,7,0,0,0,0,0,0,7,7,7,15,15,15,15,15,15,15,15,15,15,15,0,0,0,0,15,7,7,7,0,0,0,0,0,7,7,7,15,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,7,7,7,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,15,7,7,7,0,0,0,0,0,0,0,7,7,7,15,0,0,0,0,0,0},
{14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,7,7,7,14,14,14,14,14,14,14,14,7,7,7,14,14,14,14,14,14,7,7,7,7,7,7,7,7,7,7,7,7,7,7,14,14,15,7,7,7,14,14,14,14,14,14,14,14,14,7,7,7,15,14,14,14,14,14},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,7,7,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1},
{14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}


};

int8_t LEDBuffer2[32][LED_Width] = {
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0},      
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,7,7,7,7,0,0,7,7,7,7,7,7,7,7,7,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,7,7,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0},      
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,7,7,7,7,0,7,7,7,7,7,7,7,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,7,7,0,0,7,7,0,0,0,7,0,0,0,0,0,0,0,0,0,0},      
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,7,7,0,0,7,7,7,0,0,0,0,0,0,0,0,0},      
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,7,0,0,0,0,0,7,7,7,7,7,7,7,7,7,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,7,7,7,7,7,7,0,0,7,7,0,7,7,7,0,0,0,0,0,0,0,0,0,0},      
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,7,7,7,7,0,0,0,7,7,7,7,7,7,7,7,7,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,7,7,7,7,7,7,0,0,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0},      
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,0,0,0,7,7,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,7,7,7,7,0,0,7,7,0,0,7,7,0,0,0,0,0,0,0,7,7,0,0,0,7,7,0,0,0,7,7,0,0,0,0,0,0,0,0,0,7,7,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0},      
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,7,0,0,0,7,7,0,0,7,7,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,7,7,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0},      
{9,7,7,9,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,7,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,7,0,0,7,7,0,0,7,7,0,0,0,0,0,0,0,7,7,0,0,0,7,7,0,0,0,7,7,0,0,0,0,0,0,0,0,0,7,7,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0},      
{9,7,7,9,7,7,9,7,9,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,7,7,7,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0},      
{9,7,7,9,7,7,9,7,7,9,9,9,9,9,7,7,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,0,0,0,0,7,0,0,0,7,7,0,0,0,7,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,7,7,7,7,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0},      
{9,7,7,9,7,7,9,7,7,9,9,9,9,9,7,7,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,7,7,9,9,9,9,7,7,9,9,0,0,0,7,7,7,0,0,7,7,0,0,7,7,7,0,0,0,0,0,0,7,7,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,7,7,7,7,7,7,0,0,7,7,0,0,0,7,7,0,0,0,0,0,0,0,0,0},      
{9,7,7,9,7,7,9,7,7,9,9,9,9,9,7,7,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,7,7,9,9,9,9,7,7,9,9,0,0,7,7,7,0,0,0,7,7,0,0,0,7,7,7,7,0,0,0,7,7,7,0,7,7,7,7,0,0,0,7,7,7,7,0,0,0,0,0,7,7,7,0,7,7,0,7,7,7,0,0,0,0,0,7,7,7,7,0,7,7,0,0,7,7,0,0,0,7,7,0,0,0,0,0,0,0,0,0},      
{9,7,7,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,7,7,9,9,9,9,7,7,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,0,7,7,7,0,0,7,7,7,7,0,0,0,0,7,7,7,7,0,7,7,7,0,7,7,7,7,0,0,0,0,0,7,7,7,7,0,7,7,7,7,7,0,0,7,7,0,0,7,7,7,7,7,0,0,0,7,0,0,0,7,7,0,0,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0},      
{9,7,7,9,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,7,7,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,0,0,7,0,0,0,0,7,7,0,0,0,0,0,0,7,7,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,0,0,7,0,0,7,7,7,7,0,0,0,7,7,0,0,0,7,7,7,7,0,0,0,0,0,0,0,7,7,0,0,0,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0},      
{9,9,9,9,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,7,7,9,9,9,9,9,9,9,7,7,7,7,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},      
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,7,7,7,7,7,7,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,7,7,0,0,0,0,0},      
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,7,7,7,7,7,7,7,7,0,0,0,0,0,0,7,7,0,0,0,7,7,0,0,0,7,7,0,0,0,0,0,7,7,7,0,0,0,7,7,7,7,7,7,7,7,0,0},      
{9,9,9,9,7,7,9,9,9,9,9,9,9,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,7,7,7,7,9,7,7,9,7,7,7,7,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,7,7,7,7,7,7,7,7,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,7,7,0,7,0,0,7,7,7,7,7,7,7,7,0,0},      
{9,9,9,9,7,7,9,9,9,9,9,9,9,7,7,9,7,7,9,9,9,9,9,9,9,9,9,9,7,7,9,7,7,7,7,7,9,9,7,7,9,9,7,7,7,7,7,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,0,0,0,0,7,7,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,7,7,0,7,7,0,0,7,7,0,0,0,0,7,7,0,0},      
{9,9,9,9,7,7,9,9,9,9,9,9,7,7,7,9,7,7,7,9,9,9,9,9,9,9,9,9,7,7,9,7,7,7,9,9,9,9,7,7,9,9,9,9,7,7,7,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,0,0,7,7,7,7,7,7,7,7,0,0},      
{9,9,9,9,7,7,9,9,9,9,9,7,7,7,9,9,9,7,7,7,9,9,9,9,9,9,9,7,7,7,7,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,7,7,7,7,7,7,7,7,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,7,7,7,7,0,0,0,7,7,0,0,0,0,7,7,0,0},      
{9,9,9,9,7,7,9,9,9,7,7,7,7,9,9,9,9,9,7,7,7,9,9,9,9,9,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,7,7,7,0,0,7,7,0,0,0,0,7,7,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,7,7,0,7,7,0,7,7,7,7,7,7,7,7,0,0},      
{9,9,9,9,7,7,9,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,9,9,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,7,7,7,7,0,7,7,7,7,7,7,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,0,7,7,7,7,7,7,7,7,0,0},      
{9,9,9,9,7,7,9,7,7,7,9,9,9,9,9,9,9,9,9,9,7,7,7,9,9,9,7,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,7,7,0,0,7,7,0,7,7,7,7,7,7,7,7,7,7,0,0,0,7,7,7,7,7,7,7,7,0,0,0,7,7,0,0,0,7,0},      
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,7,7,7,7,7,0,7,7,7,0,7,7,0,0,0,7,7,0,0,0,7,7,0,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,7,7,0,7,7,7,7,0,7,7,7,0,0,7,0},      
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,7,7,0,0,7,7,0,7,7,7,0,7,7,0,0,0,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,7,7,0,7,7,7,0,0,0,7,0,7,7,7,0,7,0,0},      
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,7,7,0,0,7,7,7,7,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,7,7,0,7,7,0,7,0,0,7,0,7,7,7,7,0,0,0},      
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,7,7,0,0,0,7,7,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,7,7,0,7,7,0,7,0,7,7,0,7,7,0,7,0,0,0},      
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,7,7,7,7,0,7,7,7,0,0,0,0,7,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,7,7,0,7,7,0,0,0,7,0,0,7,7,0,7,7,0,0},      
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,7,7,0,0,0,7,7,7,7,0,7,7,7,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,7,7,0,0,7,7,0},      
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,0,0,0,0,0,7,7,0,0,0,7,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0}

};

int8_t LEDBuffer3[32][LED_Width] = {
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,7,7,0,7,7,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,7,7,0,7,7,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,0,0,0,7,7,0,7,7,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,0,0,0,7,7,0,7,7,7,0,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,7,7,0,0,7,7,0,0,0,7,7,0,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,0,7,7,0,0,0,7,7,0,0,0,0,0,0,0,0,0},
{9,7,7,9,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,7,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,7,0,0,0,7,7,7,0,0,0,0,0,0,0,0},
{9,7,7,9,7,7,9,7,9,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0},
{9,7,7,9,7,7,9,7,7,9,9,9,9,9,7,7,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,7,7,7,7,7,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0},
{9,7,7,9,7,7,9,7,7,9,9,9,9,9,7,7,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,7,7,9,9,9,9,7,7,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,0,7,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0},
{9,7,7,9,7,7,9,7,7,9,9,9,9,9,7,7,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,7,7,9,9,9,9,7,7,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,7,7,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,7,7,9,9,9,9,7,7,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,7,7,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0},
{9,7,7,9,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,7,7,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,7,7,9,9,9,9,9,9,9,7,7,7,7,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,7,7,7,7,7,7,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,7,7,7,7,9,7,7,9,7,7,7,7,9,9,9,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,7,7,9,7,7,9,9,9,9,9,9,9,9,9,9,7,7,9,7,7,7,7,7,9,9,7,7,9,9,7,7,7,7,7,9,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,7,7,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,7,7,7,9,7,7,7,9,9,9,9,9,9,9,9,9,7,7,9,7,7,7,9,9,9,9,7,7,9,9,9,9,7,7,7,9,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,7,7,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,7,7,7,9,9,9,7,7,7,9,9,9,9,9,9,9,7,7,7,7,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,0,0,0,0,0,0,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,7,7,7,7,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,7,7,7,7,9,9,9,9,9,7,7,7,9,9,9,9,9,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,7,7,7,0,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,9,9,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,7,7,7,9,9,9,9,9,9,9,9,9,9,7,7,7,9,9,9,7,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,7,0,7,7,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,7,0,0,7,7,7,0,0,7,0,0,0,7,0,7,7,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,7,0,0,0,7,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,7,7,0,7,0,0,0,7,0,7,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,7,0,0,0,0,7,7,0,7,0,7,0,0,0,7,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}

};

int8_t LEDBuffer4[32][LED_Width] = {
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,7,7,0,7,7,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,7,7,0,7,7,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,0,0,0,7,7,0,7,7,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,0,0,0,7,7,0,7,7,7,0,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,7,7,0,0,7,7,0,0,0,7,7,0,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,0,7,7,0,0,0,7,7,0,0,0,0,0,0,0,0,0},
{9,7,7,9,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,7,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,7,0,0,0,7,7,7,0,0,0,0,0,0,0,0},
{9,7,7,9,7,7,9,7,9,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0},
{9,7,7,9,7,7,9,7,7,9,9,9,9,9,7,7,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,7,7,7,7,7,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0},
{9,7,7,9,7,7,9,7,7,9,9,9,9,9,7,7,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,7,7,9,9,9,9,7,7,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,0,7,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0},
{9,7,7,9,7,7,9,7,7,9,9,9,9,9,7,7,9,9,9,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,7,7,9,9,9,9,7,7,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,7,7,9,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,7,7,9,9,9,9,7,7,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,7,7,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0},
{9,7,7,9,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,7,7,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,7,7,9,9,9,9,9,9,9,7,7,7,7,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,7,7,7,7,7,7,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,7,7,9,9,9,7,7,7,7,9,7,7,9,7,7,7,7,9,9,9,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,7,7,0,7,7,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,9,7,7,9,7,7,9,9,9,9,9,9,9,9,9,9,7,7,9,7,7,7,7,7,9,9,7,7,9,9,7,7,7,7,7,9,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,7,7,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,9,7,7,7,9,7,7,7,9,9,9,9,9,9,9,9,9,7,7,9,7,7,7,9,9,9,9,7,7,9,9,9,9,7,7,7,9,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,7,7,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,9,9,7,7,7,9,9,9,7,7,7,9,9,9,9,9,9,9,7,7,7,7,9,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,0,0,0,0,0,0,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,7,7,7,7,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,9,9,7,7,7,7,9,9,9,9,9,7,7,7,9,9,9,9,9,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,7,7,7,0,0,7,7,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,9,9,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,7,7,9,7,7,7,9,9,9,9,9,9,9,9,9,9,7,7,7,9,9,9,7,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,7,0,7,7,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,7,0,0,7,7,7,0,0,7,0,0,0,7,0,7,7,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,7,0,0,0,7,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,7,7,0,7,0,0,0,7,0,7,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,7,0,0,0,0,7,7,0,7,0,7,0,0,0,7,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}

};

int8_t LEDBuffer5[32][LED_Width] = {

};

int8_t LEDBuffer6[32][LED_Width] = {

};
int8_t LEDMainBuffer[32][LED_Width] = {

};

int8_t ScrollBuffer[16][2048] = {

};
    

//01 Red
//02 Green
//03 Blue
//04 Yellow(R,G)
//05(G,B)
//06 purple(R,B)
//07 White(R,G,B)
//08 Blue(Keihin-tohoku Line)
//10 Yellow(Nambu Local)
//11 Green (Yokohama Line)
//12 Orange(Rapid Acty,Urban)
//13 Green(Saikyo Line)
//14
//15
//16 Green(Utsunomiya Line)
//17 Green(Joban Local Local)
//18 Keikyu Logo(Gray

bool R1Data[8][32]={
{0,1,0,0,1,0,1,1,0,1,1,1,1,0,1,1,0,0,1},
{0,1,0,0,1,0,1,1,0,1,1,0,1,0,0,0,0,0,1},
{0,1,0,0,1,0,1,1,0,1,1,0,1,0,0,0,0,0,0},
{0,1,0,0,1,0,1,1,0,1,0,0,1,0,0,0,0,0,0},

{0,1,0,0,1,0,1,1,0,1,1,1,1,0,1,1,0,0,1},
{0,1,0,0,1,0,1,1,0,1,1,0,1,0,0,0,0,0,1},
{0,1,0,0,1,0,1,1,0,1,1,0,1,0,0,0,0,0,0},
{0,1,0,0,1,0,1,1,0,1,0,0,1,0,0,0,0,0,0}
};

bool G1Data[8][32]={
{0,0,1,0,1,1,0,1,1,0,1,1,1,1,0,1,1,1,1},
{0,0,1,0,1,1,0,1,1,0,1,1,0,0,0,0,1,1,1},
{0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,1,0},

{0,0,1,0,1,1,0,1,1,0,1,1,1,1,0,1,1,1,1},
{0,0,1,0,1,1,0,1,1,0,1,1,0,0,0,0,1,1,1},
{0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,1,0}
};

bool B1Data[8][32]={
{0,0,0,1,0,1,1,1,1,1,0,0,0,0,0,1,0,1,1},
{0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1},
{0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
{0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0},

{0,0,0,1,0,1,1,1,1,1,0,0,0,0,0,1,0,1,1},
{0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1},
{0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
{0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0}
};



void Init()
{
    //pc.baud(9600);
    // Set up things to a known state
    CLK = LOW;
    LAT = LOW;
    OE = HIGH; //display off
    ABC = 0;
    CT=0;

}

void WriteRow(unsigned char Row, int8_t Buffer[32][LED_Width], int8_t index2)
{
    ABC = 15-Row; 
    for(int col=0; col<LED_Width; col++) { 
        R1 = R1Data[index2][(Buffer [(15-Row)][col])];
        G1 = G1Data[index2][(Buffer [(15-Row)][col])];   
        B1 = B1Data[index2][(Buffer [(15-Row)][col])];                        
        R2 = R1Data[index2][(Buffer [(31-Row)][col])]; 
        G2 = G1Data[index2][(Buffer [(31-Row)][col])];
        B2 = B1Data[index2][(Buffer [(31-Row)][col])];                  
        CLK = HIGH;                 
        CLK = LOW;                  
    }
    LAT = HIGH; 
    LAT = LOW;
}

void WrRowOFF(unsigned char Row)
{
    // Write specified row (and row+8) to display. Valid input: 0 to 7.
    ABC = 15-Row; // Set row address
    for(int col=0; col<LED_Width; col++) { // To daisychain more displays, I guess you would have to increase this counter to n*32 columns. Might mirror though.
        R1 = 0; // Red bit, upper half
        G1 = 0; // Green bit, upper half
        B1 = 0; // Blue bit, upper half
        R2 = 0; // Red bit, lower half
        G2 = 0; // Green bit, lower half
        B2 = 0; // Blue bit, lower half
        CLK = HIGH;                 // tick (clock bit in)
        CLK = LOW;                  // tock
    }
    LAT = HIGH; // Latch entire row
    LAT = LOW;
}

void Paint(int8_t Buffer2[32][LED_Width])
{
    for(int index = 0; index < 4; index++){
        for(int Row=0; Row<LED_Height; Row++) {
            OE = HIGH; // Disable output
            WriteRow(Row,Buffer2,index);
            //wait_us(5);
            OE = LOW; // Enable output
            wait_us(DisplayWait); // Wasting some time. Use for whatever else. Probably better with a ticker for the display refresh.
            OE = HIGH; // Disable output
        }     
    }
}


void PaintOFF()
{
    // Write graphics memory to display
    for(int Row=0; Row<8; Row++) {
        OE = HIGH; // Disable output
        WrRowOFF(Row);
        OE = LOW; // Enable output
        wait_us(50); // Wasting some time. Use for whatever else. Probably better with a ticker for the display refresh.
    }
}

void CopyBuffer(int8_t ReadBuffer[32][LED_Width],int8_t WriteBuffer[32][LED_Width]){
    for(int y = 0; y < LED_Height * 2; y++){
        if(Scroll != 0 && y > 15 ){
            for(int x = 0; x < LED_Width - 80;  x++){
                WriteBuffer[y][x] = ReadBuffer[y][x];    
            }              
        }else{
            for(int x = 0; x < LED_Width;  x++){
                WriteBuffer[y][x] = ReadBuffer[y][x];    
            }    
        }      
    }
}

//バッファ初期化
void ClearBuffer(int8_t TargetBuffer[32][LED_Width]){
    for(int y = 0; y < LED_Height * 2; y++){
        for(int x = 0; x < LED_Width;  x++){
            TargetBuffer[y][x] = 0;    
        }    
    }      
    
}    
    

void CopyScrollBuffer(int8_t ReadBuffer[16][2048],int8_t WriteBuffer[32][LED_Width],int Startx){
    for(int y = 0; y < 16; y++){
        int xCount = 0;       
        for(int x = 0; x < 80; x++){
                if(bitRead(ScrollBuffer[y][(x + Startx) / 8 ], (x + Startx)% 8) != 0){
                    LEDMainBuffer[y + 16][x + 48] = 4;   
                }else{
                    LEDMainBuffer[y + 16][x + 48] = 0;   
                }                   
                xCount = xCount + 1;
        }    
    }     
}

//1文字256byte 
void CopyScrollBuffer2(int8_t ReadBuffer[16][2048],int8_t WriteBuffer[32][LED_Width],int Startx){
    for(int y = 0; y < 16; y++){
        for(int x = 0; x < 80; x++){
            LEDMainBuffer[y + 16][x + 48] = ScrollBuffer[y][x + Startx];   
        }    
    }     
} 

//書込み対象バッファ,書込み開始位置x,書込み開始位置y,読み出し幅x,読み出し高さy,読み出し開始位置(バイト)
bool SDBufferWrite(int8_t TargetBuffer[32][LED_Width], int Startx, int Starty, int Readx, int Ready, int StartByte ){
    FILE *fp = fopen(SDFilePath, "r");
        if(fp == NULL) {
            pc.printf("SDFileOpen Error %s\r\n",SDFilePath);
            //error("Could not open file for write\r\n");
            return 1;
        }else{
            //pc.printf("SDFileOpen Success %s\r\n",SDFilePath);
        
            //SDDataReadtest
            int8_t Data;
            //先頭2バイトはヘッダ
            fseek(fp, 2 + StartByte, SEEK_SET);
            
            for(int y = Starty; y < Starty + Ready; y++){  
                for(int x = Startx; x < Startx + Readx; x++){
                    Data = getc(fp);
                    TargetBuffer[y][x] = Data;    
                }           
            }           
            fclose(fp); 
            return 0;
        }
}

//スクロールバッファへの書込み用 読み出し高さは16固定
//書込み対象バッファ,書込み開始位置x,書込み開始位置y,読み出し幅x,読み出し高さy
void SDScrollBufferWrite(int8_t TargetBuffer[16][2048], int Startx, int Starty, int Readx, int Ready){
    //pc.printf("SDScrollBufferWrite\r\n");
    FILE *fp = fopen(SDFilePath, "r");
        if(fp == NULL) {
            pc.printf("SDFileOpen Error %s\r\n",SDFilePath);
            //error("Could not open file for write\r\n");
        }else{
            //pc.printf("SDFileOpen Success %s\r\n",SDFilePath);
        
            //SDDataReadtest
            int8_t Data;
            //先頭2バイトはヘッダ
            fseek(fp, 2, SEEK_SET);
            for(int y = Starty; y < Starty + Ready; y++){  
                for(int x = Startx; x < Startx + Readx; x++){
                    Data = getc(fp);
                    
                    
                    //TargetBuffer[y][x] = Data;   
                    
                    if(Data != 0){
                        bitSet(TargetBuffer[y][x / 8],x % 8);
                    }else{
                        bitClear(TargetBuffer[y][x / 8],x % 8);
                    }
                }           
            }           
            fclose(fp); 
        }
}

//路線名表示の使用領域チェック
//路線名表示時に次停車駅を表示するかどうかの判断に使用
//路線名が下半分も使用しているなら次停車駅は表示しない
bool BufferBlankCheck(){
    bool NotBlankflag = 0;
    for(int y = 16; y < 32; y++){
        for(int x = 48; x < 128; x++){
            if(LEDBuffer[y][x] != 0){
                NotBlankflag = 1;   
            } 
            if(NotBlankflag == 1){
                break;
            }
        }
        if(NotBlankflag == 1){
            break;
        }    
    }
    if(NotBlankflag == 0){
        pc.printf("Blank\r\n"); 
        return 0;     
    }else{
        pc.printf("Not Blank\r\n");  
        return 1;   
    }
}

void TimerTick(){
    //OE = HIGH;
    //DisplayMode = 1 3段階表示ならば
    if(DisplayMode == 1){
        if (ChangeCount == 0){
            CopyBuffer(LEDBuffer,LEDMainBuffer);
            ChangeCount = ChangeCount + 1;
        }else if(ChangeCount == 1 ){
            CopyBuffer(LEDBuffer2,LEDMainBuffer);
            ChangeCount = ChangeCount + 1;
            //ChangeCount = 0;
        }else if(ChangeCount == 2){
            CopyBuffer(LEDBuffer3,LEDMainBuffer);
            ChangeCount = 0;
        }else{
            ChangeCount = 0;
        }   
    }
    //DisplayMode = 2 2段階表示ならば
    //次駅表示なし2段階表示に使用
    
    if (DisplayMode == 2){
        
        if(ChangeCount == 0 ){
            //CopyBuffer(LEDBuffer,LEDMainBuffer);
            CopyBuffer(LEDBuffer5,LEDMainBuffer);
            ChangeCount = ChangeCount + 1;
        }else if(ChangeCount == 1){
            //CopyBuffer(LEDBuffer2,LEDMainBuffer);
            CopyBuffer(LEDBuffer6,LEDMainBuffer);     
            ChangeCount = 0;
        }else{
            ChangeCount = 0;
        }    
    }
    //DisplayMode = 3 ならば LEDBuffer2を固定表示
    if (DisplayMode == 3){
        CopyBuffer(LEDBuffer,LEDMainBuffer);
        ChangeCount = 1;
    }
    
    //2段階表示 次駅表示あり、路線名なしパターンに使用
    if(DisplayMode == 4){    
        if(ChangeCount == 1 ){
            CopyBuffer(LEDBuffer2,LEDMainBuffer);
            ChangeCount = ChangeCount + 1;
        }else{
            CopyBuffer(LEDBuffer3,LEDMainBuffer);
            ChangeCount = 1;
        }  
    }

    //DisplayMode = 5 5段階表示ならば
    if(DisplayMode == 5){
        if (ChangeCount == 0){
            CopyBuffer(LEDBuffer,LEDMainBuffer);
            ChangeCount = ChangeCount + 1;
        }else if(ChangeCount == 1 ){
            CopyBuffer(LEDBuffer4,LEDMainBuffer);
            ChangeCount = ChangeCount + 1;
            //ChangeCount = 0;
        }else if(ChangeCount == 2){
            CopyBuffer(LEDBuffer2,LEDMainBuffer);
            ChangeCount = ChangeCount + 1;
        }else if(ChangeCount == 3){
            CopyBuffer(LEDBuffer3,LEDMainBuffer);
            ChangeCount = 0;
        }else{
            ChangeCount = 0;
        }
    }

    //OE = LOW;
    //クロック確認
    //pc.printf("CPU SystemCoreClock is %.2f MHz\r\n", (float)SystemCoreClock/1000/1000); 
}

void TestDisplayTimerTick(){
    
    if (ChangeCountTest <= 10){
        sprintf(SDFilePath,"/sd/E233/LEDTest/LEDTest%d.bin",ChangeCountTest);
        OE = HIGH;
        SDBufferWrite(LEDMainBuffer,0,0,128,32,0);
        OE = LOW;
        ChangeCountTest = ChangeCountTest + 1;
    }else{
        ChangeCountTest = 0;
    }
    
}

void ScrollTimerTick(){
    if(ScrollCount < ScrollWriteCount + 80){    
        CopyScrollBuffer(ScrollBuffer,LEDMainBuffer,ScrollCount);
        ScrollCount = ScrollCount + 1;
    }else{
        ScrollCount = 0;
    }
}





void ScrollRead2(){
    //スクロールカウンタを0に戻す
    ScrollCount = 0;
    //スクロールバッファ初期化
    for(int i = 0; i < 2048; i++){
        for(int j = 0; j < 16; j++){
            ScrollBuffer[j][i] = 0;
        }
    }

    
    //test
    //Initialize StopStationCode
    for (int x = 0; x < MaxStopStation; x++){
        StopStationCode[x]= 0;
    }
    
    int DeptStaIndex = 0;
    int TermStaIndex = 0;
    //sprintf(SDFilePath,"/sd/E233/RoutePattern/RoutePattern%d.bin",1);
    //sprintf(SDFilePath,"/sd/E233/RoutePattern/RoutePattern001001.bin");
    sprintf(SDFilePath,"/sd/E233/RoutePattern/RoutePattern%03d%03d.bin",LineNumber,RoutePatternNumber);
    pc.printf("%s\r\n",SDFilePath);
     
    //始発駅インデックス取得
    for(int i = 0; i < MaxStopStation; i++){
        FILE *fp = fopen(SDFilePath, "r");
        if(fp == NULL) {
            //停車駅データを読み込めないならスクロールを無効にする
            pc.printf("SDFileOpen Error %s\r\n",SDFilePath);
            Scroll = 0;
            break;   
        }else{
            //停車駅コード取得
            int test = 0;
            int test2 = 0;
            fseek(fp, i*2 + 4, SEEK_SET);
            test = getc(fp);
            test = test << 8;

            fseek(fp, i*2 + 4 + 1, SEEK_SET);
            test2 = getc(fp); 
            test = test ^ test2;    
            fclose(fp); 
            if(test == DeptStaNumber){
                DeptStaIndex = i + 1;
                pc.printf("DeptStaIndex:%d\r\n",DeptStaIndex);
                pc.printf("break\r\n");
                break;
                
            }
        }
        pc.printf("DeptSta-loopcount:%d\r\n",i);
    }
    
    //終着駅インデックス取得
    for(int i = 0; i < MaxStopStation; i++){
        FILE *fp = fopen(SDFilePath, "r");
        if(fp == NULL) {
            //停車駅データを読み込めないならスクロールを無効にする
            pc.printf("SDFileOpen Error %s\r\n",SDFilePath);
            Scroll = 0;
            break;   
        }else{
            //停車駅コード取得
            int test = 0;
            int test2 = 0;
            fseek(fp, i*2 + 4, SEEK_SET);
            test = getc(fp);
            test = test << 8;

            fseek(fp, i*2 + 4 + 1, SEEK_SET);
            test2 = getc(fp); 
            test = test ^ test2;    
            fclose(fp); 
            if(test == TermStaNumber){
                TermStaIndex = i + 1;
                pc.printf("TermStaIndex:%d\r\n",TermStaIndex);
                pc.printf("break\r\n");
                break;
                
            }
        }
        pc.printf("TermSta-loopcount:%d\r\n",i);
    }
        
    
    if(DeptStaIndex != 0 && TermStaIndex != 0){
        //SDRead StopStationCode
        //始発駅インデックス < 終着駅インデックスなら
        if(DeptStaIndex < TermStaIndex){
            for(int i = 0; i < MaxStopStation; i++){
                //停車駅コード取得
                int test = 0;
                int test2 = 0;
        
                FILE *fp = fopen(SDFilePath, "r");
                if(fp == NULL) {
                    //停車駅データを読み込めないならスクロールを無効にする
                    pc.printf("SDFileOpen Error %s\r\n",SDFilePath);
                    Scroll = 0;
                    break;    
                }else{
                    //pc.printf("SDFileOpen Success %s\r\n",SDFilePath);
                    fseek(fp, DeptStaIndex*2 + i*2 + 4, SEEK_SET);
                    test = getc(fp);
                    test = test << 8;

                    fseek(fp, DeptStaIndex*2 + i*2 + 4 + 1, SEEK_SET);
                    test2 = getc(fp); 
                    test = test ^ test2;
            
                    StopStationCode[i] = test;
                    pc.printf("StopStationCode[%d]:%d\r\n",i,StopStationCode[i]);
              
                    //読み込んだ駅名コードが終着駅コードと同じならばループを抜ける  
                    if(StopStationCode[i] == TermStaNumber){
                        break;
                    }           
                    fclose(fp); 
                }
            }
        }
        
        
              
    }else{
    //始発駅インデックス、終着駅インデックスのどちらか、または両方が0の場合運用パターンデータに駅名コードが存在しない
        pc.printf("Error DeptStaIndex or TermStaIndex = 0\r\n");
        pc.printf("Error DeptStaIndex:%d,TermStaIndex:%d",DeptStaIndex,TermStaIndex);
        Scroll = 0;
    }  
        
    //test end    
             
    //ScrollDebug
     ScrollWriteCount = 80;
    
    //この電車の停車駅は、
    sprintf(SDFilePath,"/sd/E233/StopStation/StopStation%d.bin",1);
    SDScrollBufferWrite(ScrollBuffer,ScrollWriteCount,0,80,16);
    ScrollWriteCount = ScrollWriteCount + 80;   
    sprintf(SDFilePath,"/sd/E233/StopStation/StopStation%d.bin",2);
    SDScrollBufferWrite(ScrollBuffer,ScrollWriteCount,0,80,16);       
    ScrollWriteCount = ScrollWriteCount + 80;  

    int StaNameLength = 0;
    for(int i = 0; i < MaxStopStation; i++){        
        if(StopStationCode[i] == 0){
            //駅名コードが0ならScrollWriteCountから終着駅の文字数 x 16 + 16 を引いてループを抜ける
            ScrollWriteCount = ScrollWriteCount - (StaNameLength * 16 + 16);  
            break;
        }
        //駅名
        sprintf(SDFilePath,"/sd/E233/StationName/%d.bin",StopStationCode[i]);
        SDScrollBufferWrite(ScrollBuffer,ScrollWriteCount,0,128,16);
        
        //駅名文字数取得
        //int test = 0;
        sprintf(SDFilePath,"/sd/E233/StationNameLength.bin");
        FILE *fp = fopen(SDFilePath, "r");
        if(fp == NULL) {
            pc.printf("SDFileOpen Error %s\r\n",SDFilePath);
        }else{
            //pc.printf("SDFileOpen Success %s\r\n",SDFilePath);
            fseek(fp, StopStationCode[i], SEEK_SET);
            StaNameLength = getc(fp);
            //pc.printf("StationNameLength:%d\r\n",StaNameLength);
            fclose(fp); 
        }
               
        ScrollWriteCount = ScrollWriteCount + (StaNameLength * 16);  
        sprintf(SDFilePath,"/sd/E233/StopStation/0x8132.bin");
        SDScrollBufferWrite(ScrollBuffer,ScrollWriteCount,0,16,16);       
        ScrollWriteCount = ScrollWriteCount + 16;      
    }
    
    
    
    ScrollWriteCount = ScrollWriteCount - 16;
    sprintf(SDFilePath,"/sd/E233/StopStation/StopStation%d.bin",3);
    SDScrollBufferWrite(ScrollBuffer,ScrollWriteCount,0,80,16);       
    ScrollWriteCount = ScrollWriteCount + 80;     
    sprintf(SDFilePath,"/sd/E233/StopStation/StopStation%d.bin",4);
    SDScrollBufferWrite(ScrollBuffer,ScrollWriteCount,0,80,16);       
    ScrollWriteCount = ScrollWriteCount + 80;   
    
    }


void SDFileRead(){
    //バッファ初期化
    ClearBuffer(LEDBuffer);
    ClearBuffer(LEDBuffer2);
    ClearBuffer(LEDBuffer3);
    ClearBuffer(LEDBuffer4);
    ClearBuffer(LEDBuffer5);
    ClearBuffer(LEDBuffer6);
    
    
    //3段階表示 LEDBuffer  [種別]路線名(･次駅)
    //         LEDBuffer2 [種別]行先･次駅
    //         LEDBuffer3 [種別(英)]行先(英)･次駅(英)
    //路線コードが0なら2段階表示に変更
    if(LineNumber == 0){
        DisplayMode = 4;
    }else{
        DisplayMode = 1;
    }

    //SDCard
    //種別
    sprintf(SDFilePath,"/sd/E233/Kind/%d.bin",KindNumber);
    SDBufferWrite(LEDBuffer,0,0,48,32,0);
    sprintf(SDFilePath,"/sd/E233/Kind/%d.bin",KindNumber);
    SDBufferWrite(LEDBuffer2,0,0,48,32,0);    
    //種別(英語)
    sprintf(SDFilePath,"/sd/E233/KindE/%d.bin",KindNumber);
    SDBufferWrite(LEDBuffer3,0,0,48,32,0); 
           
    //路線名
    sprintf(SDFilePath,"/sd/E233/Line/%d.bin",LineNumber);
    //路線名データが読み込めない場合(返って来た値が0でない場合)2段階表示に変更
    if(SDBufferWrite(LEDBuffer,48,0,80,32,0) != 0){
        DisplayMode = 4;
    }
    
    //行先
    sprintf(SDFilePath,"/sd/E233/For/%d.bin",ForNumber);
    SDBufferWrite(LEDBuffer2,48,0,80,16,0);
    //行先(英語)
    //sprintf(SDFilePath,"/sd/E233/ForE/%d.bin",ForNumber);
    //SDBufferWrite(LEDBuffer3,48,0,80,16,0);
    sprintf(SDFilePath,"/sd/E233/For/%d.bin",ForNumber);
    SDBufferWrite(LEDBuffer3,48,0,80,16,1280);    
    
    //次停車駅(路線名表示)
    //路線名表示の次停車駅は路線名表示が上半分に収まるときのみ表示
    if(BufferBlankCheck() == 0){
        sprintf(SDFilePath,"/sd/E233/NextStation/%d.bin",NextStaNumber);
        SDBufferWrite(LEDBuffer,48,16,80,16,0);
    }else if(Scroll == 1){
        //路線名が下半分も使用している&スクロール有効の場合4段階表示に切り替え
        DisplayMode = 5;
        sprintf(SDFilePath,"/sd/E233/Kind/%d.bin",KindNumber);
        SDBufferWrite(LEDBuffer4,0,0,48,32,0);       
        sprintf(SDFilePath,"/sd/E233/Line/%d.bin",LineNumber);
        SDBufferWrite(LEDBuffer4,48,0,80,16,1280);        
    }
    //次停車駅
    sprintf(SDFilePath,"/sd/E233/NextStation/%d.bin",NextStaNumber);
    SDBufferWrite(LEDBuffer2,48,16,80,16,0);    
    //次停車駅(英語)
    //sprintf(SDFilePath,"/sd/E233/NextStationE/%d.bin",NextStaNumber);
    //SDBufferWrite(LEDBuffer3,48,16,80,16,0);   
    sprintf(SDFilePath,"/sd/E233/NextStation/%d.bin",NextStaNumber);
    SDBufferWrite(LEDBuffer3,48,16,80,16,1280);     
    
        

    
    //2段階(次駅なし)
    //次駅コードが0なら次駅なしの2段階表示に変更
    // 2段階表示 LEDBuffer5 [種別]行先(次駅表示なし) 
    //          LEDBuffer6 [種別]路線名
    //路線名がない場合(E233-0など)は固定表示

    if(NextStaNumber == 0){
        //種別
        sprintf(SDFilePath,"/sd/E233/Kind/%d.bin",KindNumber);
        //SDBufferWrite(LEDBuffer,0,0,48,32,0);
        //SDBufferWrite(LEDBuffer2,0,0,48,32,0);
        SDBufferWrite(LEDBuffer5,0,0,48,32,0);
        SDBufferWrite(LEDBuffer6,0,0,48,32,0);        
    
       //路線名
        sprintf(SDFilePath,"/sd/E233/Line2/%d.bin",LineNumber);
        //SDBufferWrite(LEDBuffer2,48,0,80,32,0);
        SDBufferWrite(LEDBuffer6,48,0,80,32,0);
        //行先
        sprintf(SDFilePath,"/sd/E233/For2/%d.bin",ForNumber);
        //SDBufferWrite(LEDBuffer,48,0,80,32,0);
        SDBufferWrite(LEDBuffer5,48,0,80,32,0);       
        
        //路線コードが0なら行先で固定表示       
        if(LineNumber == 0){
            DisplayMode = 3;
        }else{
            DisplayMode = 2;
        }    
    }
    
    
    //全面種別固定表示
    //路線名、行先、次駅がすべて0なら種別を全面に固定表示
    if(LineNumber == 0 && ForNumber == 0 && NextStaNumber == 0){
        
        //種別
        sprintf(SDFilePath,"/sd/E233/Kind/%d.bin",KindNumber);
        SDBufferWrite(LEDBuffer,0,0,48,32,0);
        sprintf(SDFilePath,"/sd/E233/Kind2/%d.bin",KindNumber);
        SDBufferWrite(LEDBuffer,0,0,128,32,0);        
        //固定表示に変更       
        DisplayMode = 3;
    }
    
    //全面行先固定表示
    //DisplayMode:3 固定表示 LEDBuffer 行先(次駅表示なし 32x128)
    //路線名、種別、次駅がすべて0なら行先を全面に固定表示
    if(LineNumber == 0 && KindNumber == 0 && NextStaNumber == 0){
        //データ作ってないからとりあえず80x32の行先データを表示
        //前面行先データフォルダ:For3
        
        sprintf(SDFilePath,"/sd/E233/For3/%d.bin",ForNumber);
        SDBufferWrite(LEDBuffer,0,0,128,32,0);          
        //固定表示に変更 
        DisplayMode = 3;
    }
    
        //Debug
    if(Debug == 1){
        //DataSerialOut
        for(int y = 0; y < 32; y++){
            for(int x = 0; x <128; x++){
                if(LEDBuffer[y][x]== 0){
                    //pc.printf("0,"); 
                    pc.printf("  "); 
                }else{
                    //pc.printf("#"); 
                    pc.printf("%.02d",LEDBuffer[y][x]); 
                }
            }
            pc.printf("\r\n");           
        }
    }
    
}


int CharToInt(unsigned char Sertemp1,unsigned char Sertemp2,unsigned char Sertemp3){
    int n1 = 0 ;
    int n2 = 0 ;
    int n3 = 0 ;
    int n = 0;
    
    if ( Sertemp1 < '0' || Sertemp1 > '9' ) {
        // error
    } else {
        n1 = (int)(Sertemp1 - '0') ;
        //pc.printf("%d,",n1); 
    }      
    if ( Sertemp2 < '0' || Sertemp2 > '9' ) {
        // error
    } else {
        n2 = (int)(Sertemp2 - '0') ;
        //pc.printf("%d,",n2); 
    }         
    if ( Sertemp3 < '0' || Sertemp3 > '9' ) {
        // error
    } else {
        n3 = (int)(Sertemp3 - '0') ;
        //pc.printf("%d\r\n",n3); 
    }
    n = (n1 * 100) + (n2 * 10) + n3;
    return n;
    }
    
    
void pc_rx(){
    //pc.putc(pc.getc());
    
    OE = HIGH;
    
    if (pc.readable() == 1) { // 受信したデータが存在する
        if (busyflag == false){
            SerialBuffer[count] = pc.getc(); // 受信データを読み込む
            
        }else{
            pc.printf("busy\r\n");
        }
        
        if (count > 29 || SerialBuffer[count] == '$') { // 文字数が既定の個数を超えた場合、又は終了文字を受信した場合
            busyflag = true;
            
            //SerialBuffer[count] = '\0';                    // 末尾に終端文字を入れる
            
            for(int a = 0; a < count; a++){
                ABuffer[a] = SerialBuffer[a];
            }
            
            count = 0; 
            
            //路線名 L
            if(ABuffer[0] == 'L'){
                //路線名 L
                //ABuffer[0]は'L'
                LineNumber = CharToInt(ABuffer[1],ABuffer[2],ABuffer[3]);
                pc.printf("Line:%d\r\n",LineNumber);     
            }
            
            //種別 K
            if(ABuffer[0] == 'K'){
                //種別 K
                //ABuffer[0]は'K'
                KindNumber = CharToInt(ABuffer[1],ABuffer[2],ABuffer[3]);
                pc.printf("Kind:%d\r\n",KindNumber); 
            }
            
            //行先 F
            if(ABuffer[0] == 'F'){
                //行先 F
                //ABuffer[0]は'F'
                ForNumber = CharToInt(ABuffer[1],ABuffer[2],ABuffer[3]);
                pc.printf("For:%d\r\n",ForNumber);  
            }
            
            //次停車駅 N
            if(ABuffer[0] == 'N'){
                //次停車駅 N
                //ABuffer[0]は'N'                  
                NextStaNumber = CharToInt(ABuffer[1],ABuffer[2],ABuffer[3]);
                pc.printf("NextStation:%d\r\n",NextStaNumber);
            }
            

            
            //起動 Set
            if(ABuffer[0] == 'S' && ABuffer[1] == 'e' && ABuffer[2] == 't'){
                pc.printf("Set\r\n"); 
                SDFileRead();
            }else if(ABuffer[0] == 'S'){
                //スクロール有効/無効 S
                unsigned char Sertemp1 = ABuffer[1];
                int n1 = 0 ;
                int n = 0;
                
                if ( Sertemp1 < '0' || Sertemp1 > '9' ) {
                    // error
                } else {
                    n1 = (int)(Sertemp1 - '0') ;
                    //pc.printf("%d,",n1); 
                } 
                     
                n = n1;
                Scroll = n;
                pc.printf("Scroll:%d\r\n",n);     
            }
            
            //データ一括設定
            //先頭文字:'A'
            if(ABuffer[0] == 'A'){
                //路線名 L
                //ABuffer[1]は'L'
                LineNumber = CharToInt(ABuffer[2],ABuffer[3],ABuffer[4]);
                pc.printf("Line:%d\r\n",LineNumber);
                
                //種別 K
                //ABuffer[5]は'K'
                KindNumber = CharToInt(ABuffer[6],ABuffer[7],ABuffer[8]);
                pc.printf("Kind:%d\r\n",KindNumber);
                
                //行先 F
                //ABuffer[9]は'F'
                ForNumber = CharToInt(ABuffer[10],ABuffer[11],ABuffer[12]);
                pc.printf("For:%d\r\n",ForNumber); 
                
                //次停車駅 N
                //ABuffer[13]は'N'                  
                NextStaNumber = CharToInt(ABuffer[14],ABuffer[15],ABuffer[16]);
                pc.printf("NextStation:%d\r\n",NextStaNumber);
                
                //一括設定時は続けてSDからの読み込み
                pc.printf("Set\r\n"); 
                SDFileRead(); 
                Scroll = 0;
                //即時反映
                TimerTick();                                
            }
            
            //データ一括設定2
            //先頭文字:'B'
            //BLxxxNxxxPxxxyyyzzzKxxxFxxxSx$
            //Lxxx:路線コード
            //Nxxx:次駅コード
            //Pxxxyyyzzz:停車駅パターン(xxx:運用パターン番号 yyy:始発駅コード zzz:終着駅コード)
            //Kxxx:種別コード
            //Fxxx:行先コード
            //Sx:スクロール(1:有効 0:無効)
            if(ABuffer[0] == 'B'){
                //路線名 L
                //ABuffer[1]は'L'
                LineNumber = CharToInt(ABuffer[2],ABuffer[3],ABuffer[4]);
                pc.printf("Line:%d\r\n",LineNumber);
                
                //次停車駅 N
                //ABuffer[5]は'N'                  
                NextStaNumber = CharToInt(ABuffer[6],ABuffer[7],ABuffer[8]);
                pc.printf("NextStation:%d\r\n",NextStaNumber);
                
                //運用パターン P
                //Pxxxyyyzzz
                //x:運用パターン番号(3桁)
                //y:始発駅(3桁)
                //z:終着駅(3桁)
                //ABuffer[9]は'P'                  
                RoutePatternNumber = CharToInt(ABuffer[10],ABuffer[11],ABuffer[12]);
                pc.printf("RoutePattern:%d\r\n",RoutePatternNumber);                
                
                DeptStaNumber = CharToInt(ABuffer[13],ABuffer[14],ABuffer[15]);
                pc.printf("DeptStaNumber:%d\r\n",DeptStaNumber); 
                TermStaNumber = CharToInt(ABuffer[16],ABuffer[17],ABuffer[18]);
                pc.printf("TermStaNumber:%d\r\n",TermStaNumber); 
                
                //種別 K
                //ABuffer[19]は'K'                  
                KindNumber = CharToInt(ABuffer[20],ABuffer[21],ABuffer[22]);
                pc.printf("Kind:%d\r\n",KindNumber); 
                
                //行先 F
                //ABuffer[23]は'F'                  
                ForNumber = CharToInt(ABuffer[24],ABuffer[25],ABuffer[26]);
                pc.printf("For:%d\r\n",ForNumber);      
                
                //スクロール S
                if(ABuffer[27] == 'S'){
                //スクロール有効/無効 S
                    unsigned char Sertemp1 = ABuffer[28];
                    int n1 = 0 ;
                    int n = 0;
                
                    if ( Sertemp1 < '0' || Sertemp1 > '9' ) {
                        // error
                    } else {
                        n1 = (int)(Sertemp1 - '0') ;
                        //pc.printf("%d,",n1); 
                    } 
                     
                        n = n1;
                    Scroll = n;
                    pc.printf("Scroll:%d\r\n",n);     
                }                           
                       
                
                //一括設定時は続けてSDからの読み込み
                pc.printf("Set\r\n"); 
                SDFileRead(); 
                ScrollRead2();
                //Scroll = 1;
                //即時反映
                TimerTick();                                
            }  
            busyflag = false;
        }else{
            count++;
        }
    }
    OE = LOW;
}

void ScrollRead(){
    //test
    //Initialize StopStationCode
    for (int x = 0; x < MaxStopStation; x++){
        StopStationCode[x]= 0;
    }
    
    //SDRead StopStationCode
    for(int i = 0; i < MaxStopStation; i++){

        //停車駅コード取得
        int test = 0;
        int test2 = 0;
        sprintf(SDFilePath,"/sd/E233/StopStationList/%d.bin",1);
        FILE *fp = fopen(SDFilePath, "r");
        if(fp == NULL) {
            pc.printf("SDFileOpen Error %s\r\n",SDFilePath);
            break;
            
        }else{
            //pc.printf("SDFileOpen Success %s\r\n",SDFilePath);
            fseek(fp, i*2, SEEK_SET);
            test = getc(fp);
            test = test << 8;

            fseek(fp, i*2 + 1, SEEK_SET);
            test2 = getc(fp); 
            test = test ^ test2;
            
            StopStationCode[i] = test;
            pc.printf("StopStationCode[%d]:%d\r\n",i,StopStationCode[i]);
              
        if(StopStationCode[i] == 0){
            break;
        }           
            fclose(fp); 
        }
    }        
        
    //test end    
             
    //ScrollDebug
     ScrollWriteCount = 80;
    
    //この電車の停車駅は、
    sprintf(SDFilePath,"/sd/E233/StopStation/StopStation%d.bin",1);
    SDScrollBufferWrite(ScrollBuffer,ScrollWriteCount,0,80,16);
    ScrollWriteCount = ScrollWriteCount + 80;   
    sprintf(SDFilePath,"/sd/E233/StopStation/StopStation%d.bin",2);
    SDScrollBufferWrite(ScrollBuffer,ScrollWriteCount,0,80,16);       
    ScrollWriteCount = ScrollWriteCount + 80;  

    for(int i = 0; i < MaxStopStation; i++){        
        if(StopStationCode[i] == 0){
            break;
        }
        //駅名
        sprintf(SDFilePath,"/sd/E233/StationName/%d.bin",StopStationCode[i]);
        SDScrollBufferWrite(ScrollBuffer,ScrollWriteCount,0,128,16);
        
        //駅名文字数取得
        int test = 0;
        sprintf(SDFilePath,"/sd/E233/StationNameLength.bin");
        FILE *fp = fopen(SDFilePath, "r");
        if(fp == NULL) {
            pc.printf("SDFileOpen Error %s\r\n",SDFilePath);
        }else{
            //pc.printf("SDFileOpen Success %s\r\n",SDFilePath);
            fseek(fp, StopStationCode[i], SEEK_SET);
            test = getc(fp);
            //pc.printf("StationNameLength:%d\r\n",test);
            fclose(fp); 
        }
               
        ScrollWriteCount = ScrollWriteCount + (test * 16);  
        sprintf(SDFilePath,"/sd/E233/StopStation/0x8132.bin");
        SDScrollBufferWrite(ScrollBuffer,ScrollWriteCount,0,16,16);       
        ScrollWriteCount = ScrollWriteCount + 16;      
    }
    ScrollWriteCount = ScrollWriteCount - 16;
    sprintf(SDFilePath,"/sd/E233/StopStation/StopStation%d.bin",3);
    SDScrollBufferWrite(ScrollBuffer,ScrollWriteCount,0,80,16);       
    ScrollWriteCount = ScrollWriteCount + 80;     
    sprintf(SDFilePath,"/sd/E233/StopStation/StopStation%d.bin",4);
    SDScrollBufferWrite(ScrollBuffer,ScrollWriteCount,0,80,16);       
    ScrollWriteCount = ScrollWriteCount + 80;   
    
    }






int main(){
    Init(); // Set things up
    //Serial
    pc.printf("Power ON\r\n");
    
    if(Button1 == 0){
        //起動時にボタンが押されているならテスト表示モードに移行
        pc.printf("DisplayTestMode\r\n");
        ChangeTimerTest.attach(&TestDisplayTimerTick,1);
        Scroll=0;
    
    }else{
        //通常モード
        //SDカードから表示データを読み込み
        SDFileRead();
    
        //起動時にスクロールデータを読み込み
        if(ScrollEnable == 1){
            ScrollRead2();
        }
        //表示切替タイマ有効
        ChangeTimer.attach(&TimerTick,3);

    }

    
    //2段階表示に変更
    //DisplayMode = 2;
    
    //test
    //sprintf(SDFilePath,"/sd/E233/whitetest.bin");
    //SDBufferWrite(LEDBuffer,0,0,128,32);   
    

    //Serial割り込み有効     
    pc.attach(pc_rx, Serial::RxIrq);
    

    
    
    while(1) { 
        //CT++;
        //表示切替は切り替え時にメインバッファに書き込む
        Paint(LEDMainBuffer);
        
        //スクロール
        //スクロールが有効なら
        if(Scroll == 1){
            //if(CT>0) {
                //CT=0; // Start all over.
                OE = HIGH;
                ScrollTimerTick();
                OE = LOW;
            //}
        //}else{
            //if(CT>4160){
            //    CT=0;
            //}
        }
        //PaintOFF();
    }
}
