#include "mbed.h"

DigitalOut select0_mux1(p24);
DigitalOut select1_mux1(p23);
DigitalOut select2_mux1(p22);
DigitalOut select3_mux1(p21);
AnalogIn analog_read_1(p20);

int getBit(int num, int bitNo) {
        return ((num&(1<<bitNo)) > 0)?1:0;
}

int main() {
    while(1) {
        
        for (int i = 0; i< 16; i++) {
            printf("Select Line: %d ", i);
            
            // This code will select the select lines on the mbed
            select0_mux1 = getBit(i, 0);
            select1_mux1 = getBit(i, 1);
            select2_mux1 = getBit(i, 2);
            select3_mux1 = getBit(i, 3);
            wait(0.01);
            printf("Analog Read Value: %f\n ", analog_read_1.read());
            wait(3);   
        }
    }
}
