#include "mbed.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "SMTPClient.h"
#include "SHTx/sht15.hpp"
#include "TextLCD.h"
#include <string>

#define HOSTNAME "mbedSE"

// server is domain name eg. mail.authsmtp.com
// port is smtp port eg. 25 or 23
// domain must be acceptable to server (but often is not strictly enforced since does not affect FROM address)
#define SERVER "*"
#define PORT 26
#define USER "*"
#define PASSWORD "*"
#define DOMAIN "*"
#define FROM_ADDRESS "*"
#define TO_ADDRESS "*"
 
TextLCD lcd(p14, p16, p17, p18, p19, p20);
SHTx::SHT15 sensor(p28, p27);
EthernetNetIf eth(HOSTNAME);
NTPClient ntp;
Host host(IpAddr(), PORT, SERVER);
SMTPClient smtp(host, DOMAIN, USER, PASSWORD, SMTP_AUTH_PLAIN);
DigitalOut PTControl(p25);
DigitalOut Sprayer(p24);

DigitalIn enter(p22);
DigitalIn cancel(p21);
DigitalIn send(p23);
AnalogIn timeSelector(p15);
DigitalOut led1(LED1);
DigitalOut led2(LED2);

void sendEmail(SMTPClient &smtp, string subject, string message);
void selectorMenu();
//extern "C" void mbed_mac_address(char *mac) { mac[0]=0x00; mac[1]=0x25; mac[2]=0x00; mac[3]=0x4e; mac[4]=0x6b; mac[5]=0x94; }

int selectedTime = 0;
int selectedTemp = 0;
int onTime = 6, offTime = 6, minTemp = 70, maxTemp = 95, minH = 60, maxH = 80;
 
int main(){
    float humidity = 0.0, temperature = 0.0;
    int emailhour = 12;
    time_t lastSprayTime;
    
    enter.mode(PullDown);
    cancel.mode(PullDown);
    send.mode(PullDown);

    // Set up sensor, clear lcd
    sensor.setOTPReload(false);
    sensor.setResolution(true);
    lcd.cls();
    
    // Set up ethernet
    EthernetErr ethErr;
    int count = 0;
    do {
        lcd.cls();
        printf("Setting up %d...\r\n", ++count);
        lcd.printf("Setting up connection...");
        ethErr = eth.setup(600000);
        if (ethErr) printf("Timeout\r\n", ethErr);
    } while (ethErr != ETH_OK);
    
    printf("\rConnected OK\r\n");
    lcd.cls();
    lcd.printf("Connected OK\n");
    const char* hwAddr = eth.getHwAddr();
    printf("HW address : %02x:%02x:%02x:%02x:%02x:%02x\r\n",
           hwAddr[0], hwAddr[1], hwAddr[2],
           hwAddr[3], hwAddr[4], hwAddr[5]);

    IpAddr ethIp = eth.getIp();
    printf("IP address : %d.%d.%d.%d\r\n", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);
    lcd.cls();
    lcd.printf("IP address : %d.%d.%d.%d\n", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);
    
    // Get time from NTP server
    Host server(IpAddr(), 123, "0.uk.pool.ntp.org");
    ntp.setTime(server);
    time_t ctTime = time(NULL)-4*60*60;
    tm *thetime;
    thetime = localtime(&ctTime);
    lastSprayTime = ctTime - 10*60;
    
    int hour = 0;
    int tw_hour = 0;
    int minute = 0;
    int seconds = 0;
    string ampm = "AM";
    count = 0;
    while(1) {
        sensor.update();
        selectorMenu();
        led1 = enter; led2 = cancel;
        
        // Temperature in fahrenheit
        sensor.setScale(true);
        
        // Get readings from sensor
        humidity = sensor.getHumidity();
        temperature = sensor.getTemperature();
        ctTime = time(NULL)-4*60*60;
        thetime = localtime(&ctTime);
        hour = thetime->tm_hour;
        minute = thetime->tm_min;
        seconds = thetime->tm_sec;
        if(thetime->tm_hour >= 12)
        {
            tw_hour = hour-12;
            if(tw_hour == 0) {tw_hour = 12;}
            ampm = "PM";
        }
        else{ampm = "AM";}
        
        // Update LCD
        lcd.cls();
        
        lcd.printf("%02d:%02d %s\nT:%3.1f%cF H:%3.1f%%\n", tw_hour, minute, ampm, temperature,223, humidity);
        if(seconds%10==0)
        {
            printf("Current time is (UTC): %s\r\n", ctime(&ctTime));
        }
        
        // Light switching
        if(seconds==0)//hour == onTime && minute == 0 && seconds == 0)
        {PTControl = 0;}
        else if(seconds%30==0)//hour == offTime && minute == 0 && seconds == 0)
        {PTControl = 1;}
        
        // Humidity switcher
        if(humidity<minH && ctTime-lastSprayTime > 1*60)
        { 
            lcd.cls();
            lcd.printf("Spraying for 5 seconds...");
            printf("Spraying because humidity is %f and minimum is %d.\r\n", humidity, minH);
            printf("Last Spray:%d", ctTime-lastSprayTime);
            Sprayer = 1; 
            wait(5); 
            Sprayer = 0;
            lastSprayTime = ctTime;
        }
        else{Sprayer = 0;}
        
        // Send out E-mail at desired time
        if(send)//hour == emailhour && minute == 0 && seconds == 0)
        {
            count = 1;
            char subject[50];
            char message[50];
            
            sprintf(subject, "Subject: Humidity and Temperature Update at %d:%02d %s\n", tw_hour, minute, ampm);
            sprintf(message, "Humidity = %2.2f \nTemperature = %3.2f", humidity, temperature);
            sendEmail(smtp, subject, message);
        }
        //wait(0.5); 
    }
}

void sendEmail(SMTPClient &smtp, string subject, string message)
{
    printf("Sending email.\n");
    //Host host(IpAddr(), PORT, SERVER);
    //SMTPClient smtp(host, DOMAIN, USER, PASSWORD, SMTP_AUTH_PLAIN);
    
    EmailMessage msg;                                                                                        
    msg.setFrom(FROM_ADDRESS);
    msg.addTo(TO_ADDRESS);
    msg.printf("%s\n", subject);
    msg.printf("%s\n", message);

    printf("Send result %d\n", smtp.send(&msg));
    printf("Last response | %s", smtp.getLastResponse().c_str());
    msg.clearContent();
    //smtp.close();
    printf("Done.\n");
}

void selectorMenu()
{
    if(cancel)
        {
            wait(0.75);
            // Enter setup routine
            // Light on Time
            while(!enter)
            {
                selectedTime = timeSelector*24;
                lcd.cls();
                lcd.printf("Light on time?  %d", selectedTime); 
                wait(0.1);
                
                if(cancel){
                    lcd.cls();
                lcd.printf("Cancelled.         ");
                    wait(0.25);
                    return;
                }
            }
            onTime = selectedTime;
            wait(0.75);
            // Light off Time
            while(!enter)
            {
                selectedTime = timeSelector*24;
                lcd.cls();
                lcd.printf("Light off time? %d", selectedTime); 
                wait(0.1);
                
                if(cancel){
                    lcd.cls();
                lcd.printf("Cancelled.         \r");
                    wait(0.25);
                    return;
                }
            }
            offTime = selectedTime;
            wait(0.75);
            /* Min Temp
            while(!enter)
            {
                selectedTemp = timeSelector*50+70;
                lcd.cls();
                lcd.printf("Minimum temperature? %d", selectedTemp); 
                wait(0.1);
                
                if(cancel){
                    printf("Cancelled.         ");
                    wait(0.25);
                    return;
                }
            }
            minTemp = selectedTemp;
            wait(0.75);
            // Max Temp
            while(!enter)
            {
                selectedTemp = timeSelector*50+70;
                lcd.cls();
                lcd.printf("Maximum Temperature? %d", selectedTemp); 
                wait(0.1);
                
                if(cancel){
                    printf("Cancelled.         ");
                    wait(0.25);
                    return;
                }
            }
            maxTemp = selectedTemp;
            wait(0.75);
            */
            // Min Humidity
            while(!enter)
            {
                selectedTemp = timeSelector*50+30;
                lcd.cls();
                lcd.printf("Minimum Humidity? %d", selectedTemp); 
                wait(0.1);
                
                if(cancel){
                    printf("Cancelled.         ");
                    wait(0.25);
                    return;
                }
            }
            minH = selectedTemp;
            wait(0.75);
            // Max Temp
            while(!enter)
            {
                selectedTemp = timeSelector*50+30;
                lcd.cls();
                lcd.printf("Maximum Humidity? %d", selectedTemp); 
                wait(0.1);
                
                if(cancel){
                    printf("Cancelled.         ");
                    wait(0.25);
                    return;
                }
            }
            maxH = selectedTemp;
            wait(0.75);
            
            lcd.cls();
            lcd.printf("On:%d Off:%d\nMinH: %d MaxH:%d", onTime, offTime, minH, maxH);
            wait(2);
        }
}
