#include "eeprom.h"
#include "mbed.h"
class USER{
    public:
        USER(PinName,PinName,uint8_t);
        void save(uint32_t ,char*,char* ,char*);
        void rfid(int8_t ,char *);
        void pass(int8_t ,char *);
        void time(int8_t ,char *);
        void savepos(char);
        char getpos();
        void savenum(char);
        char getnum();
        void saveprice(int32_t);
        int32_t getprice();
    private:  
        EEPROM rom;
};
USER::USER(PinName sda,PinName scl,uint8_t adr):rom(sda,scl,adr){}
void USER::save(uint32_t id,char  *rfid,char *pass,char *time){
    uint32_t _id = id/2*((id-1)*96);
    rom.write(_id,rfid,16);wait_ms(10);
    rom.write(_id+32,pass,4);wait_ms(10);
    rom.write(_id+32+32,time,6);wait_ms(10);
    
}
void USER::savepos(char pos){
    rom.write(1000,pos);wait_ms(10); 
}
char USER::getpos(){
    int8_t pos;
    rom.read(1000,pos);wait_ms(10); 
    return (char)pos;
}
void USER::savenum(char pos){
    rom.write(1005,pos);wait_ms(10); 
}
char USER::getnum(){
    int8_t pos;
    rom.read(1005,pos);wait_ms(10); 
    return (char)pos;
}
void USER::saveprice(int32_t price){
    rom.write(1010,price);wait_ms(10); 
}
int32_t USER::getprice(){
    int32_t price;
    rom.read(1010,price);wait_ms(10); 
    return price;
}
void USER::rfid(int8_t id,char *rfid){
    uint32_t  _id = id/2*((id-1)*96);
    rom.read(_id,rfid,16); 
    wait_ms(10);
}
void USER::pass(int8_t id,char *pass){
    uint32_t  _id = id/2*((id-1)*96);
    rom.read(_id+32,pass,4); 
    wait_ms(10);
}
void USER::time(int8_t id,char *time){
    uint32_t  _id = id/2*((id-1)*96);
    rom.read(_id+32+32,time,6); 
    wait_ms(10);
}