#include "mbed.h"
#include "DigitDisplay.h"
#define DS1307_ADDR 0xD0 
class DS1307{
    public:
        DS1307(PinName,PinName);
        int bcdtodec(int);
        int dectobcd(int);
        void gettime(int *sec,int *mins,int *hour,int *day,int *date,int *month,int *year);
        void settime(int sec,int mins,int hour,int day,int date,int month,int year);
        void displays();
    private:  
        I2C rtc;
        DigitDisplay display;
        bool col;
};
DS1307::DS1307(PinName sda,PinName scl):rtc(sda,scl),display(D7, D8){
    col=1;
    display.clear();
}
void DS1307::displays(){
    
    if(col){display.setColon(1);col=0;}
    else {display.setColon(0);col=1;}
    int sec,mins,hour,day,date,month,year;
    gettime(&sec,&mins,&hour,&day,&date,&month,&year);
    display.write(0, hour / 10);
    display.write(1, hour % 10);
    display.write(2, mins / 10);
    display.write(3, mins % 10);
}
void DS1307::settime(int sec,int mins,int hour,int day,int date,int month,int year){
    char cmd[2];
    cmd[0] = 0x00;
    cmd[1] = dectobcd(sec);
    rtc.write(DS1307_ADDR, cmd, 2);
    cmd[0] = 0x01;
    cmd[1] = dectobcd(mins);
    rtc.write(DS1307_ADDR, cmd, 2);
    cmd[0] = 0x02;
    cmd[1] = dectobcd(hour);
    rtc.write(DS1307_ADDR, cmd, 2);
    cmd[0] = 0x03;
    cmd[1] = dectobcd(day);
    rtc.write(DS1307_ADDR, cmd, 2);
    cmd[0] = 0x04;
    cmd[1] = dectobcd(date);
    rtc.write(DS1307_ADDR, cmd, 2);
    cmd[0] = 0x05;
    cmd[1] = dectobcd(month);
    rtc.write(DS1307_ADDR, cmd, 2);
    cmd[0] = 0x06;
    cmd[1] = dectobcd(year);
    rtc.write(DS1307_ADDR, cmd, 2);
}
void DS1307::gettime(int *sec,int *mins,int *hour,int *day,int *date,int *month,int *year){
    char cmd = 0;
    char v[7];
    for(int x=0;x<=6;x++){
        rtc.write(DS1307_ADDR, &cmd, 1);
        rtc.read(DS1307_ADDR, &v[x], 1);
        cmd++;
    }
     *sec=bcdtodec(v[0]);
     *mins=bcdtodec(v[1]);
     *hour=bcdtodec(v[2]);
     *day=bcdtodec(v[3]);
     *date=bcdtodec(v[4]);
     *month=bcdtodec(v[5]);
     *year=bcdtodec(v[6]);
}
int DS1307::bcdtodec( int bcd) {
    int low = 0;
    int high = 0;

    high = bcd / 16;
    low = bcd - (high * 16);
    return ((high * 10) + low);
}
int DS1307::dectobcd( int dec) {
    int low = 0;
    int high = 0;

    high = dec / 10;                // this gives the high nibble value
    low = dec - (high * 10);        // this gives the lower nibble value
    return ((high *16) + low);      // this is the final bcd value but in interger format
}