#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include "I2CSlave.h"
#include "CmdHandler.h"
#include "DUT_RegConfig.h"
#include "AVDD_CONFIG.h"
#include "ServoRun.h"

extern DigitalOut PULSE;
extern DigitalOut DI;

uint32_t servo_run = 0;

void ServoRunThread(void)
{    
    uint32_t step = 0;
    
    while(1)
    {    
        if(servo_run)
        {
            step = servo_run * 40;
            while(step--)
            {
                PULSE = 1;
                wait_ms(1);
                PULSE = 0;
                wait_ms(1);
            }  
            servo_run = 0;          
        }        
        wait_ms(100);
    }    
}

void ServoRun(uint8_t dir, uint32_t mm)
{
     DI = dir;
     servo_run = mm;   
}

uint32_t CheckUntil(void)
{
    return servo_run;
}

