#ifndef __DUT_REGCONFIG__
#define __DUT_REGCONFIG__

#include "mbed.h"
#include "cmsis_os.h"
#include "max32630fthr.h"

#define DUT_DEV_ADDR  0xD8

#define DUT_REG_NUM     256

#define REG_MCU_CFG          0x00
#define REG_SYS_CFG          0x01
#define REG_PW_CTRL          0x07
#define REG_CMD              0x0a
#define REG_SIZE             0x0b
#define REG_SCRATCH_PAD_BASE 0x0c 
#define REG_INTEG_CNT_L      0x45
#define REG_INTEG_CNT_M      0x46
#define REG_INTEG_CNT_H      0x47
#define REG_RANGING_CTRL     0x50
#define REG_RANGING_ANA_CTRL 0xbd


typedef struct DUTREG
{
        uint8_t addr;
        uint8_t value;
}DUTREG;

void DeviceAllInit(uint8_t rco, uint8_t tdc, uint8_t dcr);

void DUT_FirmwareInit(void);
void ChipInitReset(void);
void DUT_RegInit(uint8_t rco, uint8_t tdc, uint8_t dcr);
void Enable_DUT_Interrupt(void);
void Disable_DUT_Interrupt(void);
void InterruptHandle(void);

void ContinuousMeasureReport();
void HistogramReport();

uint8_t WriteOneReg(uint8_t addr, uint8_t data);
uint8_t ReadOneReg(uint8_t addr, uint8_t *data);
uint8_t ReadAllRegToTable(void);
uint8_t WriteFW(uint16_t size);
uint8_t vangogh_ram_rd(uint8_t tdc);
uint8_t OneTimeMeasure(uint16_t *lsb, uint16_t *milimeter, uint32_t *peak, uint16_t *noise_level);
uint8_t ContinuousMeasure(void);
uint8_t RaadContinuousMeasure(uint16_t *lsb, uint16_t *milimeter, uint32_t *peak, uint16_t *noise_level);
uint8_t StopContinuousMeasure(void);
uint8_t DCRTest(uint8_t vspad, uint8_t test_time);
uint8_t DelayLineTest(uint8_t phase, uint8_t* buf);
uint8_t GetTdcPhase(uint8_t* buf);
uint8_t SetWindow(uint8_t* pd);
uint8_t RCO_Trim(uint8_t *rco);
uint8_t BVD_Trim(uint8_t *bvd);
uint8_t Pixel_Enable(uint8_t *buf);


void StoreHistogram(uint16_t histogram_pos, uint16_t histogram_num, uint8_t tdc);

#endif




