#ifndef _CMD_HANDLER_
#define _CMD_HANDLER_

#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"

#define CMD_QUEUE_LEN  2048
#define CMD_BUF_LEN      2048

typedef struct cmd_global {
    uint8_t one_package_done;
    uint8_t valid_flag;
    uint8_t send_flag;
    uint16_t package_len;
    uint8_t buf[CMD_BUF_LEN];
    //uint8_t

} GLOBAL_CMD_VAR;

#define UPDATA_CMD                0x06
#define UPDATA_CMD_ACK            0x86

#define UPDATA_DATA_CMD           0x07
#define UPDATA_DATA_CMD_ACK       0x87

#define WRITE_CMD                 0x01  //写
#define WRITE_CMD_ACK             0x81

#define READ_CMD                  0x00  //读
#define READ_CMD_ACK              0x80
#define READ_ERROR_CMD_ACK        0X10

#define SPI_AUTO_TRANSF_CMD       0x03 //SPI数据主动上传
#define MEASURE_AUTO_TRANSF_CMD   0x07

#define REGISTER_CMD                       0x01  //寄存器操作命令
#define CHUCHANG_SET_CMD                   0x02  //出厂设置
#define CHUCHANG_SET_RESET_CMD             0x03  //恢复出厂设置
#define DISTANCE_OFFSET_CALIBRATION_CMD    0x04  //距离offset校准命令
#define GAOFAN_OFFSET_CALIBRATION_CMD      0x05  //高反offset校准命令
#define LSB_REALDISTANCE_CHANGE            0x06  //LSB 真实距离切换
#define SINGLE_COLLECT                     0x07  //单次采集
#define CONTINUE_COLLECT                   0x08  //连续采集 开始/停止
#define HISTORGRAM_READ                    0x09  // Historgram读取
#define RAWDATA_READ                       0x0A  // RawData读取
#define SPI_DATA_TRANSF_SHUANGFENG         0x0B  //SPI TOF PEAK上传
#define SPI_DATA_TRANSF_DANFENG            0x0C  //SPI TOF PEAK上传
#define REGISTER_CONTROL_CMD               0x0D  //寄存器直接读写操作
#define HISTOGRAM_READ_CASSATT             0x0E  //CASSATT芯片读取Histogram
#define SINGLE_PIXEL_CMD                   0x0F  //单PIXEL模式PEKA值读取   
#define DELAYLINE_TEST_CMD                 0x11  //单PIXEL模式PEKA值读取  

#define SWITCH_CMD                         0x40
#define MEASURE_CALI_CMD                   0x41
#define TC_GPIO_CMD                        0x42
#define MCU_OSC_OUT_CMD                    0x43
#define INT_ENABLE_CMD                     0x44
#define CHIP_RST_CMD                       0x45
#define CHIP_EN_CMD                        0x46
#define FREQ_REPORT                        0x47

#define VAN_SCRATCH_CMD                    0x50
#define VAN_RAW_REG_CMD                    0x51
#define VAN_AVDD_CMD                       0x53
#define VAN_HISTOGRAM                      0x54
#define VAN_RANGE_CMD                      0x55
#define VAN_DOWN_FW_CMD                    0x56
#define VAN_READ_HIST_CMD                  0x57
#define VAN_SINGLE_MEAS                    0x58
#define VAN_CONTIU_MEAS                    0x59
#define VAN_STEP_HISTOGRAM_CMD             0x5A
#define VAN_MOVING_CTL_CMD                 0x5B
#define VAN_DCR_TEST_CMD                   0x5C
#define VAN_DELAYLINE_TEST_CMD             0x5D
#define VAN_GET_TDC_PHASE_CMD              0x5E
#define VAN_SET_WINDOW_CMD                 0x5F

#define VAN_RCO_TRIM_CMD                   0x60
#define VAN_BVD_TRIM_CMD                   0x61
#define VAN_PIXEL_EN_CMD                   0x62





void CmdHandleTask(void);

void DealUart1OnePackage(uint8_t *pd, uint16_t cmdLen);

uint8_t HandleWriteReg(uint8_t *pd, uint16_t cmdLen);
uint8_t HandleReadReg(void);
uint8_t HandleOneTimeMeasure(void);
uint8_t HandleContinuousMeasure(uint8_t *pd);
uint8_t HandleReadHistogram(uint8_t tdc_idx);
uint8_t HandleDownloadFW(uint8_t *pd, uint16_t cmdLen);
uint8_t HandleContinuousMeasureReport(uint16_t lsb, uint16_t milimeter, uint32_t peak, uint16_t noise_level);

uint8_t HandleSwitch(uint8_t *pd, uint16_t cmdLen);
void HandleChipReset(void);
void HandleChipEnable(uint8_t en);
void HandleInterruptEnable(uint8_t en);

void HandleFreqReport(float* V_I_Value);

void UART_CmdAckSend(uint8_t ack_cmd, uint8_t register_addr, uint8_t *pbuff, uint16_t pbuff_len);

#endif


