/*******************************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/
#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include "I2CSlave.h"
#include "CmdHandler.h"
#include "DUT_RegConfig.h"
#include "AVDD_CONFIG.h"
#include "ServoRun.h"
#include "SDFileSystem.h"
#include "AnalogIn.h"

#define EVIC

void usb_rx_callback(void);
void usb_receive(void);

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

// Hardware serial port over DAPLink
//Serial uart(P3_1, P3_0);

I2C i2c_v(P3_4, P3_5);

// Virtual serial port over USB
USBSerial microUSB;
DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);

//======for EVIC
#ifdef EVIC
AnalogIn ain(AIN_1);
DigitalOut xSHUT(P5_3);
InterruptIn  chip_int(P3_2);
//AnalogIn()
DigitalOut AVDDEN(P3_3);
DigitalOut HIGH_EN(P5_6);
DigitalOut A0(P4_0);

DigitalOut PULSE(P3_0);
DigitalOut DI(P3_1);

DigitalOut TRIM_EN(P5_5);

SDFileSystem sd(P0_5, P0_6, P0_4, P0_7, "sd");  // mosi, miso, sclk, cs
#endif
//======

//======for Ofilm
#ifdef OFILM
DigitalOut xSHUT(P5_4);
DigitalOut EN_Power(P5_3);
DigitalOut EN_OSC(P5_5);
InterruptIn  chip_int(P3_3); 
#endif
//======



//Queue<uint8_t, 2048> cmd_queue;

Thread cmd_handle_thread;
Thread coutinu_measure_thread;
Thread Histogram_thread;
Thread Sevo_Thread;
//Thread usb_receive_thread;

Semaphore usb_semph(32);

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main()
{
    //microUSB.printf("micro USB serial port\r\n");
    
    float v = 2.7;
    uint8_t test = 0;
    float V_I[10];
    
    #ifdef EVIC
    xSHUT = 1;
    AVDDEN = 1;
    HIGH_EN = 0;
    A0 = 0;
    DI = 0;
    PULSE = 0;
    TRIM_EN = 0;
    #endif
    
    #ifdef OFILM
    xSHUT = 1;
    EN_Power = 0;
    EN_OSC = 0;
    #endif
    
    //uart.baud(115200);
    microUSB.attach(usb_rx_callback);
    chip_int.rise(InterruptHandle);

    rLED = LED_OFF;
    gLED = LED_OFF;
    bLED = LED_OFF;

    i2c_v.frequency(100000);
    
    SetVoltageAVDD(3.3);
    
    wait(1);    
    //DUT_RegInit();
    //wait(1);
    //DUT_FirmwareInit();
    DeviceAllInit(0x68, 0xE2, 0x31);

    cmd_handle_thread.start(CmdHandleTask);
    coutinu_measure_thread.start(ContinuousMeasureReport);
    Histogram_thread.start(HistogramReport);
    //usb_receive_thread.start(usb_receive);
    Sevo_Thread.start(ServoRunThread);

    while(1) {
        //microUSB.printf("micro USB serial port\r\n");
        //microUSB.writeBlock((uint8_t*)"Hello", 5);
        bLED =  !bLED;
        
        V_I[0] = ain.read()*5000.0f;
        HandleFreqReport(V_I);
        //SetVoltageAVDD(v);
        //v = v + 0.1;
        //if(v > 3.7)
        //    v = 2.7;
        wait(2);
        
        //if(test < 10)
        //    ServoRun(1,10);//Back 10mm
        //else if(test > 10)
        //    ServoRun(0,10);//Forward 10mm
        //test++;
        //if(test == 20)
        //    test = 0;
    }
}

void usb_rx_callback(void)
{
    //usb_semph.release();
}



