#include "mbed.h"
#include "cmsis_os.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include "CmdHandler.h"

#include "DUT_RegConfig.h"
//#include "Config.h"
#include "ServoRun.h"

GLOBAL_CMD_VAR g_cmd;

//extern CONFIG g_config;
extern DUTREG dut_reg[DUT_REG_NUM];
extern uint8_t histogram[10][1024];
extern uint8_t histogram_mode;
extern uint8_t histogram_tdc;
extern uint8_t Firmware[8192];
extern uint8_t dcr_matrix[17][9*2];

uint8_t  _uart_send_pbuff[CMD_BUF_LEN] = {0x00};

uint8_t UserTxBufferFS[2048];

uint8_t sys_cfg_save = 0;

//extern Queue<uint8_t, 2048> cmd_queue;
extern USBSerial microUSB;
extern DigitalOut rLED;
extern DigitalOut xSHUT;
extern InterruptIn  chip_int;

extern uint16_t histogram_pos_num;
extern uint16_t histogram_per_pos;

extern uint16_t range_step_num;
extern uint16_t range_per_step;

void CmdHandleTask(void)
{
    uint8_t ret;
    uint16_t i=0;
    uint8_t uart_val = 0;
    uint16_t _pbuff_len = 0;

    while(1) {
        ret = microUSB.buf.dequeue(&uart_val);
        if(ret == 1) {
            if(g_cmd.valid_flag == 0) {  //None Header
                if(uart_val == 0x5A) { //Already find header
                    g_cmd.valid_flag = 1;
                    i=0;
                    g_cmd.buf[i++] = uart_val;
                } else {
                    i=0;
                }
            } else if(g_cmd.valid_flag == 1) { //已经找到了帧头
                if(i < CMD_BUF_LEN) {
                    g_cmd.buf[i++] = uart_val;
                    if(i>=4) { //根据协议长度区判断接收的协议帧大小
                        _pbuff_len = ((g_cmd.buf[3]&0x00ff)<<8) + g_cmd.buf[2];
                        if(i == (_pbuff_len+5)) { //一包结束
                            g_cmd.package_len = i;
                            DealUart1OnePackage(g_cmd.buf, g_cmd.package_len);
                            i = 0;
                            g_cmd.valid_flag  = 0;
                            continue;
                        } else if((_pbuff_len+5)>=CMD_BUF_LEN) {
                            i = 0;
                            g_cmd.valid_flag  = 0;
                            continue;
                        }
                    }
                } else {
                    i = 0;
                    g_cmd.valid_flag  = 0;;
                }
            }
        } else {
            i = 0;
            g_cmd.valid_flag = 0;
            wait_ms(50);
            //osDelay(50);
        }
    }

}

uint8_t Check_Sum(uint8_t *_pbuff, uint16_t _cmdLen)
{
    uint8_t cmd_sum=0;
    uint16_t i;

    for(i=0; i<_cmdLen; i++) {
        cmd_sum += _pbuff[i];
    }
    cmd_sum = (~cmd_sum);

    return  cmd_sum;
}

//协议相关命令的发送
void UART_CmdAckSend(uint8_t ack_cmd, uint8_t register_addr, uint8_t *pbuff, uint16_t pbuff_len)
{
    while(g_cmd.send_flag == 1) {
        wait_ms(50);
    }

    g_cmd.send_flag = 1;

    UserTxBufferFS[0] = 0x5a;
    UserTxBufferFS[1] = 0x00;
    uint16_t i=1, j=0;
    uint16_t _uart_pbuff_len = 0;

    _uart_pbuff_len = pbuff_len+1;
    UserTxBufferFS[i++]= ack_cmd;
    UserTxBufferFS[i++]= (_uart_pbuff_len&0x00ff);
    UserTxBufferFS[i++]= (_uart_pbuff_len>>8);
    UserTxBufferFS[i++]= register_addr;
    for(j=0; j<pbuff_len; j++) {
        UserTxBufferFS[i++] = pbuff[j];
    }
    UserTxBufferFS[i++] = Check_Sum(&UserTxBufferFS[1], _uart_pbuff_len+3);

    uint16_t k = 0;

    while(i > 64) {
        microUSB.writeBlock(&UserTxBufferFS[k], 64);
        i -= 64;
        k += 64;
    }
    microUSB.writeBlock(&UserTxBufferFS[k], i);
    g_cmd.send_flag = 0;
}


void DealUart1OnePackage(uint8_t *pd, uint16_t cmdLen)
{
    uint16_t _pd_len = 0;

    _pd_len = ((pd[3]&0x00ff)<<8) + pd[2];

    if(pd[_pd_len+4] != Check_Sum(&pd[1],_pd_len+3)) { //校验不正确，直接返回
        return;
    }

    switch(pd[4]) {
        case REGISTER_CMD:  //寄存器操作
            if(pd[1] == 0x00) { //读
                //rLED = LED_ON;
                if(HandleReadReg() == 0)
                    UART_CmdAckSend(READ_CMD | 0x80, REGISTER_CMD, _uart_send_pbuff, DUT_REG_NUM*2);
                else
                    UART_CmdAckSend(READ_CMD | 0x10, REGISTER_CMD, _uart_send_pbuff, 2);
            } else if(pd[1] == 0x01) { //写
                //rLED = LED_OFF;
                if(HandleWriteReg(pd, cmdLen) == 0)
                    UART_CmdAckSend(WRITE_CMD | 0x80, REGISTER_CMD, _uart_send_pbuff, 2);
                else
                    UART_CmdAckSend(WRITE_CMD | 0x10, REGISTER_CMD, _uart_send_pbuff, 2);
            }
            break;

        case VAN_SINGLE_MEAS:// 单次测量
            if(HandleOneTimeMeasure() == 0)
                UART_CmdAckSend(READ_CMD | 0x80, VAN_SINGLE_MEAS, _uart_send_pbuff, 10);
            else
                UART_CmdAckSend(READ_CMD | 0x10, VAN_SINGLE_MEAS, _uart_send_pbuff, 2);
            break;

        case VAN_CONTIU_MEAS:// 连续测量
            if(HandleContinuousMeasure(pd) == 0)
                UART_CmdAckSend(READ_CMD | 0x80, VAN_CONTIU_MEAS, _uart_send_pbuff, 2);
            else
                UART_CmdAckSend(READ_CMD | 0x10, VAN_CONTIU_MEAS, _uart_send_pbuff, 2);
            break;

        case VAN_READ_HIST_CMD://读取Histogram
            if(pd[5] == 0xF0)
            {
                WriteOneReg(REG_SYS_CFG, sys_cfg_save);
                histogram_mode = 0;
            }
            else if(pd[5] == 0xF1)
            {
                ReadOneReg(REG_SYS_CFG, &sys_cfg_save);
                WriteOneReg(REG_SYS_CFG, 0x01);
                histogram_mode = 2;
            }
            else if(pd[5] == 0xF2)
            {
                ReadOneReg(REG_SYS_CFG, &sys_cfg_save);
                WriteOneReg(REG_SYS_CFG, 0x01);
                histogram_mode = 4;
            }
            else 
            {
                ReadOneReg(REG_SYS_CFG, &sys_cfg_save);
                WriteOneReg(REG_SYS_CFG, 0x01);
                histogram_mode = 1;
                histogram_tdc  = pd[5];
            }

            break;
        case VAN_STEP_HISTOGRAM_CMD:
            if(pd[5] == 0xF0) {
                WriteOneReg(REG_SYS_CFG, sys_cfg_save);
                histogram_mode = 0;
            } else if(pd[5] == 0xF1) {
                ReadOneReg(REG_SYS_CFG, &sys_cfg_save);
                WriteOneReg(REG_SYS_CFG, 0x01);
                histogram_mode = 3;
                histogram_pos_num = pd[6] + pd[7]*256;
                histogram_per_pos = pd[8] + pd[9]*256;
            }
            else if(pd[5] == 0xF2)
            {
                histogram_mode = 5;
                range_step_num = pd[6] + pd[7]*256;
                range_per_step = 0;
                //histogram_per_pos = pd[8] + pd[9]*256;
            }
            break;

        case VAN_MOVING_CTL_CMD:
            ServoRun(pd[5], pd[6] + pd[7]*256);
            break;

        case VAN_DOWN_FW_CMD:
            if(HandleDownloadFW(pd, cmdLen) == 0)
                UART_CmdAckSend(WRITE_CMD | 0x80, VAN_DOWN_FW_CMD, _uart_send_pbuff, 2);
            else
                UART_CmdAckSend(WRITE_CMD | 0x10, VAN_DOWN_FW_CMD, _uart_send_pbuff, 2);
            break;

        case CHIP_RST_CMD:
            HandleChipReset();
            break;

        case CHIP_EN_CMD:
            //HandleChipEnable(pd[5]);
            break;

        case INT_ENABLE_CMD:
            if(pd[5] == 1)
                chip_int.disable_irq();
            break;

        case VAN_DCR_TEST_CMD:
            if(DCRTest(pd[5], pd[6]) == 0)
                UART_CmdAckSend(READ_CMD | 0x80, VAN_DCR_TEST_CMD, (uint8_t*)dcr_matrix, 17*9*2);
            else
                UART_CmdAckSend(READ_CMD | 0x10, VAN_DCR_TEST_CMD, _uart_send_pbuff, 2);
            break;

        case VAN_DELAYLINE_TEST_CMD:
            if(DelayLineTest(pd[5], _uart_send_pbuff) == 0)
                UART_CmdAckSend(READ_CMD | 0x80, VAN_DELAYLINE_TEST_CMD, _uart_send_pbuff, 144);
            else
                UART_CmdAckSend(READ_CMD | 0x10, VAN_DELAYLINE_TEST_CMD, _uart_send_pbuff, 2);
            break;

        case VAN_GET_TDC_PHASE_CMD:
            if(GetTdcPhase(_uart_send_pbuff) == 0)
                UART_CmdAckSend(READ_CMD | 0x80, VAN_GET_TDC_PHASE_CMD, _uart_send_pbuff, 2);
            else
                UART_CmdAckSend(READ_CMD | 0x10, VAN_GET_TDC_PHASE_CMD, _uart_send_pbuff, 2);
            break;
            
        case VAN_SET_WINDOW_CMD:
            if(SetWindow(pd) == 0)
                UART_CmdAckSend(WRITE_CMD | 0x80, VAN_SET_WINDOW_CMD, _uart_send_pbuff, 2);
            else
                UART_CmdAckSend(WRITE_CMD | 0x10, VAN_SET_WINDOW_CMD, _uart_send_pbuff, 2);
        break;
        
        case VAN_RCO_TRIM_CMD:
            if(RCO_Trim(_uart_send_pbuff) == 0)
            {
                _uart_send_pbuff[1] = _uart_send_pbuff[0];
                _uart_send_pbuff[0] = 0;
                UART_CmdAckSend(READ_CMD | 0x80, VAN_RCO_TRIM_CMD, _uart_send_pbuff, 2);
            }
            else
            {
                _uart_send_pbuff[1] = _uart_send_pbuff[0];
                _uart_send_pbuff[0] = 1;
                UART_CmdAckSend(READ_CMD | 0x10, VAN_RCO_TRIM_CMD, _uart_send_pbuff, 2);    
            }    
        break;
        
        case VAN_BVD_TRIM_CMD:
            if(BVD_Trim(_uart_send_pbuff) == 0)
            {
                _uart_send_pbuff[1] = _uart_send_pbuff[0];
                _uart_send_pbuff[0] = 0;
                UART_CmdAckSend(READ_CMD | 0x80, VAN_BVD_TRIM_CMD, _uart_send_pbuff, 2);
            } 
            else
            {
                _uart_send_pbuff[1] = _uart_send_pbuff[0];
                _uart_send_pbuff[0] = 0;
                UART_CmdAckSend(READ_CMD | 0x10, VAN_BVD_TRIM_CMD, _uart_send_pbuff, 2);  
            }      
        break;
        
        case VAN_PIXEL_EN_CMD:
            if(Pixel_Enable(_uart_send_pbuff) == 0)
                UART_CmdAckSend(READ_CMD | 0x80, VAN_PIXEL_EN_CMD, _uart_send_pbuff, 2);
            else
                UART_CmdAckSend(READ_CMD | 0x10, VAN_PIXEL_EN_CMD, _uart_send_pbuff, 2);        
        break;

        default:

            break;
    }

}


uint8_t HandleWriteReg(uint8_t *pd, uint16_t cmdLen)
{
    uint16_t _pd_len = 0;
    uint16_t reg_num = 0;

    _pd_len = ((pd[3]&0x00ff)<<8) + pd[2];

    reg_num = (_pd_len - 1)/2;

    for(uint16_t i = 0; i < reg_num; i++) {
        //dut_reg[pd[5+2*i]].value = pd[5+2*i+1];
        WriteOneReg(pd[5+2*i], pd[5+2*i+1]);
    }

    return 0;
}

uint8_t HandleReadReg(void)
{
    uint8_t ret = 0;

    ret = ReadAllRegToTable();
    if(ret == 0) {
        memcpy(_uart_send_pbuff, &dut_reg, DUT_REG_NUM*2);
    }

    return ret;
}

uint8_t HandleOneTimeMeasure(void)
{
    return OneTimeMeasure((uint16_t*)_uart_send_pbuff, (uint16_t*)(_uart_send_pbuff + 2), (uint32_t*)(_uart_send_pbuff + 4), (uint16_t*)(_uart_send_pbuff + 8));
}

uint8_t HandleContinuousMeasure(uint8_t *pd)
{
    if(pd[5] == 0x00)
        return StopContinuousMeasure();
    else
        return ContinuousMeasure();
}

uint8_t HandleReadHistogram(uint8_t tdc_idx)
{
    _uart_send_pbuff[0] = tdc_idx;

    memcpy(&_uart_send_pbuff[1], histogram[tdc_idx], 1024);

    UART_CmdAckSend(READ_CMD | 0x80, VAN_READ_HIST_CMD, _uart_send_pbuff, 1025);
    return 0;
}

uint8_t HandleDownloadFW(uint8_t *pd, uint16_t cmdLen)
{
    static uint8_t pkg_num = 0;
    uint8_t ret = 0;
    uint8_t pkg_idx = pd[5];
    uint16_t pkg_len = ((pd[3]&0x00ff)<<8) + pd[2] - 2;
    static uint16_t pkg_saved = 0;

    if(pkg_idx == 0) { //第一包固件
        printf("Fist Pkg of FW arrived.\n");
        memset(Firmware, 0x00, 8192);
        pkg_num = 0;
        pkg_saved = 0;

        memcpy(Firmware + pkg_saved, &pd[6], pkg_len);
        pkg_num++;
        pkg_saved += pkg_len;
    } else if(pkg_idx == 0xF0) {
        printf("Last Pkg of FW arrived. Begin to Download to Chip.\n");
        //DebugArray(Firmware, pkg_saved);//For Debug
        ret = WriteFW(pkg_saved);
    } else if(pkg_idx == 0xF1) {
        printf("Firmware transmission has been halt.\n");
        memset(Firmware, 0x00, 8192);
        pkg_num = 0;
        pkg_saved = 0;
    } else {
        memcpy(Firmware + pkg_saved, &pd[6], pkg_len);
        pkg_num++;
        pkg_saved += pkg_len;
    }

    if(ret == 0) {
        printf("Firmware download successfully.\n");
    }

    _uart_send_pbuff[0] = pkg_idx;

    return ret;
}

uint8_t HandleContinuousMeasureReport(uint16_t lsb, uint16_t milimeter, uint32_t peak, uint16_t noise_level)
{
    memcpy(_uart_send_pbuff, &lsb, 2);
    memcpy(_uart_send_pbuff + 2, &milimeter, 2);
    
    memcpy(_uart_send_pbuff + 4, &peak, 4);
    memcpy(_uart_send_pbuff + 8, &noise_level, 2);
    

    UART_CmdAckSend(READ_CMD | 0x80, VAN_CONTIU_MEAS, _uart_send_pbuff, 10);

    return 0;
}

void HandleChipReset(void)
{
    xSHUT = 0;
    wait_ms(30);
    xSHUT = 1;
}

void HandleFreqReport(float* V_I_Value)
{
    uint32_t temp_byte = 0;

    _uart_send_pbuff[0] = 0;
    _uart_send_pbuff[1] = 0;
    memset(&_uart_send_pbuff[2], 0x00, 11);

    for(uint8_t i = 0; i < 10; i++) {
        temp_byte = V_I_Value[i];
        memcpy(_uart_send_pbuff + 13 + 4*i, &temp_byte, 4);
    }

    UART_CmdAckSend(READ_CMD | 0x80, FREQ_REPORT, _uart_send_pbuff, 53);
}
