#ifndef __VAN_DEFINES_H__
#define __VAN_DEFINES_H__

#include "mbed.h"
#include "max32630fthr.h"
//#include "Van_Types.h"
#include "Van_Config.h"

#define VAN_DEVICE_ADDR          0xD8

#define VAN_REG_MCU_CFG          0x00
#define VAN_RET_INT_STATUS       0x03
#define VAN_REG_SYS_CFG          0x01
#define VAN_REG_PW_CTRL          0x07
#define VAN_REG_CMD              0x0a
#define VAN_REG_SIZE             0x0b
#define VAN_REG_SCRATCH_PAD_BASE 0x0c 

#define VAN_WRITEFW_CMD          0x03
#define VAN_USER_CFG_CMD         0x09
#define VAN_START_RANG_CMD       0x0E

#define VAN_CFG_SUBCMD           0x01
#define VAN_OTPW_SUBCMD          0x02
#define VAN_OTPR_SUBCMD          0x03

#define VAN_CHECK_RET(a)   if(a != VAN_OK) return a


typedef struct DISTANCE
{
    uint32_t millimeter;
    uint32_t peak;
    uint32_t noise;
    uint32_t histcnt;
    uint32_t confidence;
    uint32_t dmax;
    uint32_t retCode;
} Van_Dist_TypeDef;

typedef struct CONFIG
{
    //预设模式：VAN_HIGH_PRECISION, VAN_LONG_DISTANCE, VAN_HIGH_SPEED, VAN_ANTI_SUNLIGHT
    //模组上电后默认是VAN_HIGH_PRECISION模式
    uint8_t preSetMode;

    //以下用于高级调试功能，普通用户仅使用预设模式即可
    uint8_t pulseWidth;
    uint8_t refSPAD;
    uint8_t cgCorrection;
    uint8_t integalCnt[3];
    uint8_t MA[8];
    uint8_t reserved[17];
    
    //以下默认存储在OTP中，用户通常不用修改
    uint8_t oscTrim;
    uint8_t bvdTrim;
    uint8_t tdcTrim;
    uint8_t mpSelect;
    uint8_t offset;
    uint8_t peak0[3];
    uint8_t pileup[20];
} Van_Config_TypeDef;

typedef struct PILEUP
{
    float a4;
    float a3;
    float a2;
    float a1;
    float a0;
} Van_PileUp_TypeDef;

typedef enum Van_Status
{
    VAN_OK       = 0x00,
    VAN_RANGING  = 0x01,
    VAN_BUSY     = 0x02,
    VAN_BUS_BUSY = 0x03,
    VAN_SLEEP    = 0x04,
    VAN_BOOTING  = 0x05,
    VAN_ERROR    = 0x06
} Van_Status;

typedef enum PRE_MODE
{
    VAN_ADVANCED       = 0x00,
    VAN_HIGH_PRECISION = 0x01,
    VAN_LONG_DISTANCE  = 0x02,
    VAN_HIGH_SPEED     = 0x03,
    VAN_ANTI_SUNLIGHT  = 0x04
} Van_PreMode;

typedef enum RANGINGDATA
{
    VAN_DATA_VALID = 0x00,
    VAN_RAW_DATA   = 0x01,
    VAN_DATA_ERROR = 0x02
} Van_RangingDataStatus;

typedef enum NEXTACTION
{
    VAN_GO_ON = 0x00,
    VAN_STOP  = 0x01
} Van_NextAction;

#endif

