#include "Van_ChipInterface.h"

Van_Status WriteOneReg(uint8_t addr, uint8_t value)
{
    return I2C_WriteXBytes(addr, &value, 1);
}

Van_Status ReadOneReg(uint8_t addr, uint8_t *value)
{
    return I2C_ReadXBytes(addr, value, 1);
}

Van_Status WriteCommand(uint8_t cmd)
{
    return WriteOneReg(VAN_REG_CMD, cmd);
}

Van_Status WriteCommand_SW(uint8_t cmd, uint8_t subcmd, uint8_t start, uint8_t len, uint8_t *data)
{
    Van_Status ret = VAN_OK;
    uint8_t headbuf[3];
    
    headbuf[0] = subcmd;
    headbuf[1] = len;
    headbuf[2] = start;
    
    if(NULL != data)
    {
        ret = I2C_WriteXBytes(VAN_REG_SCRATCH_PAD_BASE + 3, data, len);
        VAN_CHECK_RET(ret);
    }   
    
    ret = I2C_WriteXBytes(VAN_REG_SCRATCH_PAD_BASE, headbuf, 3);
    VAN_CHECK_RET(ret);

    ret =  WriteCommand(cmd);
    VAN_CHECK_RET(ret);

    return VAN_OK; 
}

Van_Status WriteCommand_HW(uint8_t cmd, uint8_t len, uint8_t *data)
{
    Van_Status ret = VAN_OK;

    uint8_t cmd_size[2];

    cmd_size[0] = cmd;
    cmd_size[1] = len;
    
    I2C_WriteXBytes(VAN_REG_CMD, cmd_size, 2);
    VAN_CHECK_RET(ret);

    if(NULL != data)
    {
        ret = I2C_WriteXBytes(VAN_REG_SCRATCH_PAD_BASE, data, len);
        VAN_CHECK_RET(ret);
    }
    
    return VAN_OK; 
}

Van_Status WriteFirmwarePreConfig(void)
{
    Van_Status ret = VAN_OK;
    uint8_t reg_sys_cfg = 0;

    ret = WriteOneReg(VAN_REG_PW_CTRL, 0x08);
    VAN_CHECK_RET(ret);  
    ret = WriteOneReg(VAN_REG_PW_CTRL, 0x0a);
    VAN_CHECK_RET(ret);  
    ret = WriteOneReg(VAN_REG_MCU_CFG, 0x02);
    VAN_CHECK_RET(ret);  
    ret = ReadOneReg (VAN_REG_SYS_CFG, &reg_sys_cfg);
    VAN_CHECK_RET(ret);  
    ret = WriteOneReg(VAN_REG_SYS_CFG, reg_sys_cfg | (0x01<<0));
    VAN_CHECK_RET(ret);  
    ret = WriteOneReg(VAN_REG_CMD, 0x01);
    VAN_CHECK_RET(ret);  
    ret = WriteOneReg(VAN_REG_SIZE, 0x02);
    VAN_CHECK_RET(ret);  
    ret = WriteOneReg(VAN_REG_SCRATCH_PAD_BASE+0x00, 0x00);
    VAN_CHECK_RET(ret);  
    ret = WriteOneReg(VAN_REG_SCRATCH_PAD_BASE+0x01, 0x00);
    VAN_CHECK_RET(ret);  

    return VAN_OK;
}

Van_Status WriteFirmwarePostConfig(void)
{
    Van_Status ret = VAN_OK;

    ret = WriteOneReg(VAN_REG_SYS_CFG, 0x04);
    VAN_CHECK_RET(ret);  
    ret = WriteOneReg(VAN_REG_MCU_CFG, 0x03);
    VAN_CHECK_RET(ret);  
    ret = WriteOneReg(VAN_REG_PW_CTRL, 0x02); 
    VAN_CHECK_RET(ret);  
    ret = WriteOneReg(VAN_REG_PW_CTRL, 0x00); 
    VAN_CHECK_RET(ret);  

    return VAN_OK;
}

Van_Status WriteFirmware32Byte(uint8_t len, uint8_t *data)
{
    Van_Status ret = VAN_OK;

    if(len > 32)
        return VAN_ERROR;

    uint8_t cmd_size[2];
    uint8_t i = 0;

    cmd_size[0] = VAN_WRITEFW_CMD;
    cmd_size[1] = len;
    
    I2C_WriteXBytes(VAN_REG_CMD, cmd_size, 2);
    VAN_CHECK_RET(ret);   
    
    ret = I2C_WriteXBytes(VAN_REG_SCRATCH_PAD_BASE, data, len);
    VAN_CHECK_RET(ret);

    return VAN_OK; 
}

Van_Status GetRawRangingData(Van_Dist_TypeDef *result)
{
    Van_Status ret = VAN_OK;

    uint8_t buf[32];

    ret = I2C_ReadXBytes(VAN_REG_SCRATCH_PAD_BASE, buf, 32);
    VAN_CHECK_RET(ret);

    result->millimeter = *(uint16_t*)(buf + 12);
    result->peak       = *(uint32_t*)(buf + 28);
    result->noise      = *(uint16_t*)(buf + 26);
    result->histcnt    = *(uint8_t*)(buf + 25);
    result->retCode    = VAN_RAW_DATA;

    return VAN_OK;
}

Van_Status GetAndClearInterrupt(uint8_t *status)
{
    return ReadOneReg(VAN_RET_INT_STATUS, status);
}

Van_Status ClearInterrupt(void)
{
    uint8_t tmp;
    return ReadOneReg(VAN_RET_INT_STATUS, &tmp);
}

Van_Status PreReadOTPData(uint8_t start_addr, uint8_t len)
{
    Van_Status ret = VAN_OK;

    if(len > 29)
        return VAN_ERROR;

    ret = WriteCommand_SW(VAN_USER_CFG_CMD, VAN_OTPR_SUBCMD, start_addr, len, NULL);
    VAN_CHECK_RET(ret);

    return VAN_OK;
}

Van_Status ReadOTPDataPage(uint8_t len, uint8_t *buf)
{
    Van_Status ret = VAN_OK;

    if(len > 29)
        return VAN_ERROR;

    ret = I2C_ReadXBytes(VAN_REG_SCRATCH_PAD_BASE + 3, buf, len);
    VAN_CHECK_RET(ret);

    return VAN_OK;
}


