#include "Van_API.h"
#include "Van_Algorithm.h"

uint16_t GetAPIVersion(void)
{
    return APIversion;
}

Van_Status InitRanging(Van_Config_TypeDef *cfg, uint8_t *cg_para)
{
    Van_Status ret = VAN_OK;

    ret = SetRangingMode(cfg);//设置测距模式
    VAN_CHECK_RET(ret);

#if(config_USE_CG_Correction) 
    ret = WriteCGPara(cg_para);//下传 CoverGlass校正参数
    VAN_CHECK_RET(ret);
#endif
    
#if(config_CAL_DMAX || config_CAL_COFF)
    ret = InitAlgorithmParameter(cfg);
    VAN_CHECK_RET(ret);
#endif
    
    return VAN_OK;
}

Van_Status StartRanging(void)
{    
    Van_Status ret = VAN_OK;
    ret = ClearInterrupt();
    VAN_CHECK_RET(ret);
    ret = WriteCommand(VAN_START_RANG_CMD);
    VAN_CHECK_RET(ret);

    return VAN_OK; 
}

Van_Status ReadRangingResult(Van_Dist_TypeDef *result)
{
    Van_Status ret = VAN_OK;
    ret = GetRawRangingData(result);
    VAN_CHECK_RET(ret);

    //这里要进行算法计算
#if(config_CAL_COFF || config_CAL_DMAX)    
    ret = RangingResultAnalysis(result);
    VAN_CHECK_RET(ret);
    //result->confidence = 1234;
#endif
    
    return VAN_OK;
}

Van_Status GetIntStatus(uint8_t *int_status)
{
    return GetAndClearInterrupt(int_status);
}

Van_Status PollingGetRangingResult(Van_Dist_TypeDef *result, uint8_t next_actiong)
{
    Van_Status ret = VAN_OK;
    uint8_t int_status = 0;

    ret = GetAndClearInterrupt(&int_status);
    VAN_CHECK_RET(ret);

    if((int_status & 0x01) == 0x00)
    {
        return VAN_RANGING;
    }

    ret = ReadRangingResult(result);
    VAN_CHECK_RET(ret);

    if(next_actiong == VAN_GO_ON)
    {
        ret = WriteCommand(VAN_START_RANG_CMD);
        VAN_CHECK_RET(ret);
    }
    
    return VAN_OK;
}

Van_Status GetPileUpPara(Van_PileUp_TypeDef *pile_up_para)
{
    return VAN_OK;
}

Van_Status SetRangingMode(Van_Config_TypeDef *cfg)
{
    Van_Status ret = VAN_OK;

    if(cfg->preSetMode == VAN_ADVANCED)
    {
        ret = WriteCommand_SW(VAN_USER_CFG_CMD, VAN_CFG_SUBCMD, 0x00, 0x20, (uint8_t*)cfg);
        VAN_CHECK_RET(ret);
    }
    else
    {
        ret = WriteCommand_SW(VAN_USER_CFG_CMD, VAN_CFG_SUBCMD, 0x00, 0x01, (uint8_t*)cfg);
        VAN_CHECK_RET(ret);
    }

    return VAN_OK;
}

Van_Status WriteCGPara(uint8_t *cg_para)
{
    //这里以后会增加传递CoverGlass的接口

    //
    return VAN_OK;
}

Van_Status SetPileUpPara(Van_PileUp_TypeDef *pile_up_para)
{
    //预留的设置 PileUp计算参数的接口, 当前PileUp校正在芯片内部完成

    //
    return VAN_OK;
}

//这个函数对固件下载做了封装，如果用户的平台不支持8KB的缓冲区，则可以自行分开
//实现下面函数的内容，分段写入固件，每段32 Byte。
//调用次序：
//  1，WriteFirmwarePreConfig()
//  2, 多次调用WriteFirmware32Byte，直到写完全部固件
//  3, WriteFirmwarePostConfig()
Van_Status DownloadFirmware(uint8_t *buf, uint32_t size)
{
    Van_Status ret = VAN_OK;
    uint8_t page = 0;

    ret = WriteFirmwarePreConfig();
    VAN_CHECK_RET(ret);

    while(size >= 32)
    {
        ret = WriteFirmware32Byte(32, buf + page * 32);
        VAN_CHECK_RET(ret);

        size -= 32;
        page++;
    }

    if(size > 0)
    {
        ret = WriteFirmware32Byte(size, buf + page * 32);
        VAN_CHECK_RET(ret);
    }

    ret = WriteFirmwarePostConfig();
    VAN_CHECK_RET(ret);

    return VAN_OK;
}

//下面这个函数实现了从OTP中读取数据，这个函数是Block的，用户需要自行实现在Van_Platform.c中
//的毫秒延时函数Van_Delay_ms()，如果用户自行控制延时，则可以分开执行PreReadOTPData()和ReadOTPDataPage()
//两个函数调用之间间隔5ms以上
Van_Status ReadOTPData(uint8_t addr, uint8_t *buf, uint8_t len)
{
    Van_Status ret = VAN_OK;

    ret = PreReadOTPData(addr, len);
    VAN_CHECK_RET(ret);

    Van_Delay_ms(5);

    ret = ReadOTPDataPage(len, buf);
    VAN_CHECK_RET(ret);

    return VAN_OK;
}


#if(config_CAL_DMAX || config_CAL_COFF)

Van_Status InitAlgorithmParameter(Van_Config_TypeDef *cfg)
{
    Van_Status ret = VAN_OK;
    uint8_t buf[32];

    ret = ReadOTPData(0x61, buf, 10);
    VAN_CHECK_RET(ret);    

    //这里调用算法接口，将算法参数传递至Van_Algorithm.c中，如果用户在其他层次实现算法
    //则用户自行在这里添加保存或传递算法参数的代码
    ret = TransferAlgorithmParameter(cfg, buf);
    VAN_CHECK_RET(ret);

    //
    return VAN_OK;
}
#endif

