#include "Van_UserPlatform.h"
#include "DUT_RegConfig.h"

extern I2C i2c_v;

#define VAN_ECO_2V1 1

#ifdef VAN_ECO_2V1

Van_Status I2C_2V1_WriteOneReg(uint8_t addr, uint8_t value)
{
    uint8_t buf[2];
    buf[0] = addr;
    buf[1] = value;

    i2c_v.write(DUT_DEV_ADDR, (char*)buf, 2);
    
    return VAN_OK;
}

Van_Status I2C_2V1_ReadOneReg(uint8_t addr, uint8_t *value)
{
    uint8_t buf[2];
    buf[0] = addr;

    i2c_v.write(DUT_DEV_ADDR, (char*)buf,  1);
    i2c_v.read (DUT_DEV_ADDR, (char*)value, 1);
    
    return VAN_OK;
}

Van_Status I2C_WriteXByteWraper(uint8_t startaddr, uint8_t *buf, uint8_t len)
{
    Van_Status ret = VAN_OK;
    for(uint8_t i = 0; i < len; i++)
    {
        ret = I2C_2V1_WriteOneReg(startaddr + i, *(buf + i));
        VAN_CHECK_RET(ret);
    }

    return VAN_OK;
}

Van_Status I2C_ReadXByteWraper(uint8_t startaddr, uint8_t *buf, uint8_t len)
{
    Van_Status ret = VAN_OK;
    for(uint8_t i = 0; i < len; i++)
    {
        ret = I2C_2V1_ReadOneReg(startaddr + i, buf + i);
        VAN_CHECK_RET(ret);
    }

    return VAN_OK;
}

#endif

Van_Status I2C_WriteXBytes(uint8_t startaddr, uint8_t *buf, uint8_t len)
{
    return I2C_WriteXByteWraper(startaddr, buf, len);
}

Van_Status I2C_ReadXBytes(uint8_t startaddr, uint8_t *buf, uint8_t len)
{
    return I2C_ReadXByteWraper(startaddr, buf, len);
}

void Van_Delay_us(uint32_t us)
{

}

void Van_Delay_ms(uint32_t ms)
{
    
}




