#ifndef __VAN_CHIPINTERFACE_H__
#define __VAN_CHIPINTERFACE_H__

#include "Van_Defines.h"
#include "Van_UserPlatform.h"

Van_Status WriteCommand(uint8_t cmd);
Van_Status WriteCommand_SW(uint8_t cmd, uint8_t subcmd, uint8_t start, uint8_t len, uint8_t *data);
Van_Status WriteCommand_HW(uint8_t cmd, uint8_t len, uint8_t *data);


Van_Status WriteFirmware32Byte(uint8_t len, uint8_t *data);
Van_Status WriteFirmwarePostConfig(void);
Van_Status WriteFirmwarePreConfig(void);

Van_Status GetRawRangingData(Van_Dist_TypeDef *result);
Van_Status GetAndClearInterrupt(uint8_t *status);
Van_Status ClearInterrupt(void);

Van_Status PreReadOTPData(uint8_t start_addr, uint8_t len);
Van_Status ReadOTPDataPage(uint8_t len, uint8_t *buf);

#endif


