#ifndef __VAN_API_H__
#define __VAN_API_H__

#include "Van_Defines.h"
#include "Van_ChipInterface.h"

uint16_t GetAPIVersion(void);

Van_Status InitRanging(Van_Config_TypeDef *cfg, uint8_t *cg_para);

Van_Status StartRanging(void);

Van_Status ReadRangingResult(Van_Dist_TypeDef *result);

Van_Status GetIntStatus(uint8_t *int_status);

Van_Status PollingGetRangingResult(Van_Dist_TypeDef *result, uint8_t next_actiong);

Van_Status GetPileUpPara(Van_PileUp_TypeDef *pile_up_para);

Van_Status SetRangingMode(Van_Config_TypeDef *cfg);

Van_Status WriteCGPara(uint8_t *cg_para);

Van_Status SetPileUpPara(Van_PileUp_TypeDef *pile_up_para);

Van_Status DownloadFirmware(uint8_t *buf, uint32_t size);

Van_Status ReadOTPData(uint8_t addr, uint8_t *buf, uint8_t len);

Van_Status InitAlgorithmParameter(Van_Config_TypeDef *cfg);


#endif


