#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include "I2CSlave.h"

#define  MCP4561_ADDR   0x5C


extern I2C i2c_v;

void SetVoltageAVDD(float vol)
{
    uint8_t r_value = 0;
    uint8_t buf[2];
    r_value = 256 - 27/(vol/1.235 - 1.0)/50*256;
    
    buf[0] = 0x40;
    buf[1] = 0x0E;
    i2c_v.write(MCP4561_ADDR, (char*)buf, 2);   
    
    buf[0] = 0x00;
    buf[1] = r_value;
    i2c_v.write(MCP4561_ADDR, (char*)buf, 2);   
}




