#include "Van_Algorithm.h"
#include <math.h>

#if(config_CAL_COFF || config_CAL_DMAX)

#define IT0 65535.0
#define rou 0.5
#define rou0 0.88
#define Nma0 126
#define Sigmama0 1360
#define Tdead 20
#define R0 400

float IT = 65535;
float P0 = 0;

#if(config_CAL_COFF)
Van_Status Cal_Confidence(Van_Dist_TypeDef *result)
{
    float Nma = Nma0*result->noise;
    float SigmaNma = sqrt((float)Sigmama0*result->noise);
    float tmp;

    if(result->peak < (Nma + 3*SigmaNma))
    {
        result->confidence = 0;
    }
    else if(result->peak > (Nma + 6*SigmaNma))
    {
        result->confidence = 63;
    }
    else
    {
        tmp = (6*SigmaNma - result->peak + Nma)/(3*SigmaNma);
        tmp = 64 - 64*tmp*tmp;
        result->confidence = tmp;
    }    

    return VAN_OK;
}
#endif

#if(config_CAL_COFF)
Van_Status Cal_Dmax(Van_Dist_TypeDef *result)
{
    float Atte = 1 - result->noise * Tdead / IT;
    float SigmaNma = sqrt((float)Sigmama0*result->noise);
    float den, num;

    num = Atte * P0 * rou * R0 * R0 * IT * 9;
    den = 6 * rou0 * SigmaNma * IT0 * result->histcnt;

    result->dmax = sqrt(num/den);

    return VAN_OK;
}
#endif

Van_Status RangingResultAnalysis(Van_Dist_TypeDef *result) 
{
    Van_Status ret = VAN_OK;

#if(config_CAL_COFF)
    ret = Cal_Confidence(result);
    VAN_CHECK_RET(ret);
#endif

#if(config_CAL_DMAX)
    ret = Cal_Dmax(result);
    VAN_CHECK_RET(ret);
#endif

    return VAN_OK;
}

Van_Status TransferAlgorithmParameter(Van_Config_TypeDef *cfg, uint8_t *buf)
{
    //传递积分次数
    if(cfg->preSetMode == VAN_HIGH_PRECISION || cfg->preSetMode == VAN_LONG_DISTANCE)
        IT = 65535.0;
    else if(cfg->preSetMode == VAN_HIGH_SPEED)
        IT = 20479.0;
    else if(cfg->preSetMode == VAN_ANTI_SUNLIGHT)
        IT = 131071.0;
    else
    {
        IT = cfg->integalCnt[0] + cfg->integalCnt[1]*0x100 + cfg->integalCnt[2]*0x10000;
    }
    
    //传递标定参数
    P0 = buf[0] + buf[1]*0x100 + buf[2]*0x10000;

    return VAN_OK;
}

#endif


