#include "mbed.h"
#include "Led.h"
#include "rtos.h"
#include "TextLCD.h"

//Sets up LCD
Led GreenLed(D5);
TextLCD lcd(A0, A1, A2, A3, A4, A5,TextLCD::LCD16x2); // rs, e, d4-d7 

AnalogueIn LDR(D11);

//Declare Threads
Thread take_sample;

//Declare Thread IDs
OSThreadId tidmain;
OSThreadId take_sample_id;

//Declare Ticker
Ticker sample_interval;

void LCD_Write();
void LDR_Read();

int main() 
{
    take_sample.start(LDR_Read);                        //Start LDR Reading Thread
    sample_interval.attach(&sampling_ISR, 15000);       //Set the sampling interval to 15 seconds

}

void sampling_ISR(){
    osSignalSet(take_sample_id, true);                            //Set the sampling thread signal to true
}

void LDR_Read(){
    osSignalWait(true, osWaitForever);          //Wait until the sampling thread signal is set to true
    osSignalSet(take_sample_id, false);         //Set the sampling signal thread to false
    LCD_Write(LDR);
}

void LCD_Write(float LDR)
{
    lcd.printf("LDR Value is %1.1f \n",LDR);
}



