#include "mbed.h"
#include "rtos.h"
#include "Filter.hpp"


unsigned short ADC_DATA;

//Init  values for difference equation
//MBED Class Instances follows
DigitalOut SampLED(LED1);              //Digital Output  (GREEN LED is PB_3, D13 You can use an Oscilloscope on This pin to confirm sample rate)

//Analog Inputs
AnalogIn QDEF(PA_7);
AnalogIn BDEF(PA_6);
AnalogIn FDEF(PA_5);
AnalogIn  Ain(PA_1);                    //Analog Input (Signal Input 0 to +3 Volts)
AnalogOut Aout(PA_4);                   //Analog Output (Signal Input 0 to +3 Volts)

//Declare Tickers
Ticker sample_timer;
Ticker coeff_change;

//Declare Threads
Thread t1;
Thread t2;

//Declare Ticker Rates
float sample_rate = (1.0/35000);        //Rate of sampling
float coeff_rate = (1.0 / 20);          //Rate of updating coefficients

//Initial Input Value
float input = 0.0;

//Declare Filter
FILTER BP_filter(48000,10000,-16,2);  //Create object of type Filter(Fs,Fo,Boost,Q)

//Declare Fixed Variables
float Fo = 1;
float Boost = 0;
float Q = 1;

//Declare Temporary Coefficient Values
float Fo_Current;
float Boost_Current;
float Q_Current;

//Forward Declarations
void sampler(void);
void coeff_update(void);


int main()
{
    t2.start(sampler);
    t1.start(coeff_update);
    printf("Hello");
}


void coeff_update(void)
{
    while(1){
        Fo_Current = FDEF * 22000 + 10;
        if (abs(Fo_Current - BP_filter.Get_Fo()) > 50)      //If Centre Frequency has changed significantly
        {
            BP_filter.Update_Fo(Fo_Current);                //Update Centre Frequency
        }
        Boost_Current = BDEF * 100 - 50;
        if (abs(Boost_Current - BP_filter.Get_Boost()) > 2) //If Boost has changed significantly
        {
            BP_filter.Update_Boost(Boost_Current);          //Update Boost
        }
        Q_Current = QDEF * 49 + 1;
        if (abs(Q_Current - BP_filter.Get_Q()) > 2)         //If Q has changed significantly
        {
            BP_filter.Update_Q(Q_Current);                  //Update Q
        }
        BP_filter.Define_Filter();                          //Calculate the coefficients
        //BP_filter.Print_Filter();                           //Print the ceofficients
        printf("Q = %d \t Boost = %f \t Fo = %d\n\r", BP_filter.Get_Q(), BP_filter.Get_Boost(), BP_filter.Get_Fo());
        Thread::wait(1000);
    }
}

void sampler(void)
{
    while(1)
    {
        SampLED = 1;                        //LED Indicates start of sampling
    
        input = Ain;
        BP_filter.setvalue(input);          //Input ADC. N.B. ADC in MBED is 0.0 to 1.0 float!!!!!!
        Aout = BP_filter.getvalue();
        
    
        SampLED = 0;      //LED Indicates end of sampling
        Thread::wait(sample_rate/1000);
    }
}