//#define Fs  35000       //Frequency of Sample Rate in Hz
//#define N       5       //Number of Nodes N

class FILTER
{
private:
    // calculate_equation();//calculated the value of the equation

    //Can be interrupt driven
    int _Fs;
    int _Fo;
    double _Boost;
    int _Q;
    double _Wo_d;
    double _Wo_d2;
    float _Com_Den;
    float _NC0;
    float _NC1;
    float _NC2;
    float _DC1;
    float _DC2;
    
    float _FilterOutput;
    float _centreTap; //internal node of filter
    float _b0;
    float _b1;
    float _b2;
    float _b3;
    float _b4;

    // A - Denominator coefficients
    float _a0;
    float _a1;
    float _a2;
    float _a3;
    float _a4;

    float _G;
    float _k;
    float _Wo;

    float _xn;     //this value is the input value
    float _xnm1;
    float _xnm2;
    float _xnm3;
    float _xnm4;

    float _yn;
    float _ynm1;
    float _ynm2;
    float _ynm3;
    float _ynm4;


public:
    FILTER(int Fs, int Fo, double Boost, int Q);    //Constuctor
    ~FILTER();                                      //Destuctor

    //Constuct filter
    
    void Define_Filter();               //Calculates the coefficeints of the filter
    
    void Print_Filter();                //Print Filter Coefficients
    
    void Update_Fo(int Fo_New);                   //Update Centre Frequency
    int Get_Fo();
    
    void Update_Boost(double Boost_New);
    double Get_Boost();
    
    void Update_Q(int Q_New);    
    int Get_Q();
    
    //Setters
    void setvalue(float RAW_input);     //xn sample input

    //Getters
    float getvalue(void);               //returns yn
};


