#include "mbed.h"
#include "C12832.h"

Serial pc (USBTX,USBRX,9600);
BusIn joy(D4,A4,A5,A3,A2);
DigitalOut green(PC_7);
AnalogIn Pot1 (A0);
C12832 ecran (D11,D13,D12,D7,D10);
Ticker ticker;

char caractere = 0;
int etat = 1;

void allumerEteindre()
{
    green.write(etat);   
}

int main() {
    
    ticker.attach(&allumerEteindre,0.25);
  
    
    while(1) {
      
        caractere = (char) (0x5f - 0x20) * Pot1.read() + 0x20;
        ecran.cls();
        ecran.locate(0,0);
        ecran.printf("%c",caractere);
        
        switch (joy) 
        {
           case 0x08 : // en bas
           
                etat = 1;
                    
           break;
           
           case 0x10 : //en haut
           
                if(pc.writeable())
                {
            
                    pc.putc(caractere);
                    etat = 0;
                    while (joy == 0x10){}
                    
                }
                  
           break;
        }
        
        wait(0.1);
        
    }
}
