#include "mbed.h"
#include "C12832.h"

Serial pc(USBTX, USBRX, 4800);
C12832 screen(PA_7,PA_5,PA_6,PA_8,PB_6);
BusOut ledsRGB(D8,D9,D5);
BusIn joy(D4,A4,A5,A3,A2);

char Ordre = 0; // variable de stockage des caracteres
char ready = 0; // Flag qui permet de savoir quand le tableau est rempli
char autorisation = 0;

void rxCallback()
{
        Ordre = pc.getc(); // Stock le cractere recu dans Ordre
}

int main()
{
    pc.attach( &rxCallback, pc.RxIrq); // attach de l'isr de reception


    while (1)
    {
        if (autorisation == 1)
        {
            switch (Ordre)
            {
                case 'b':
                ledsRGB =~0x01;
                break ;
                
                case 'v' :
                ledsRGB = ~0x02;
                break ;
                
                case 'r':
                ledsRGB = ~0x04;
                break ;
                
                case 'j' :
                ledsRGB = ~0x06;
                break ;
                
                case 't' : 
                ledsRGB = ~0x03;
                break ;
                
            }
        }
        if (joy == 0x01){
            autorisation = ! autorisation;
            while (joy == 0x01){}
        }
            


    }
}