#include "mbed.h"
#include "Timer.h"
#include "rtos.h"

unsigned char txFIFO[256];
unsigned char tx_top, tx_end;

// send message define
// 1xyyy ~ 1xyyy : x-button numbeer yyy-button power
// 2xyyy : x PI state number y timing
// 3yxxx : y-1:X 2:Y 3:Z xxx-zyro sensor state

Timer timer[9];

RawSerial xbee(PA_2, PA_3);

DigitalOut LED01(PB_13);
DigitalOut LED02(PB_14);

DigitalIn SW[9][2] = {{PB_1,PC_1}, {PB_2,PC_2}, {PB_3,PC_3},
    {PB_4,PC_4}, {PB_5,PC_5}, {PB_6,PC_6},
    {PB_7,PC_7}, {PB_8,PC_8}, {PB_9,PC_9}
};

DigitalIn PI01(PC_10);
DigitalIn PI02(PC_12);

AnalogIn analog_value0(PA_0);
AnalogIn analog_value1(PA_1);
AnalogIn analog_value2(PA_4);

int check_time[2][9] = {{0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0}};
int int_pi[2] = {0,0};

int checkPI();// check PI state
int checkBT(int checkbtn); // check for button time
int send_pi(int (*pi_ara));
void send_btn(int checkbtn);

int checkPItime = 0;
int sendPItime = 0;

/////////////////////////xbee//////////////////////////
void tx_fifo_check()
{
    if(xbee.writeable() == 1) {
        if(tx_top != tx_end) {
            xbee.putc(txFIFO[tx_end]);
            ++tx_end &= 255;
        }
    }
    return;
}

void tx_fifoset(unsigned char data)
{
    txFIFO[tx_top] = data;
    ++tx_top &= 255;
    return;
}

unsigned char hex_conv(unsigned char data)
{
    data &= 15;
    if(data < 10) return(data+48);
    else return(data+55);
}

void tx_message(int data)
{
    int i;
    for (i=0; i<6; i++) {
        tx_fifoset(hex_conv((data>>(4*(5-i))) & 15));
    }
    tx_fifoset(13);
}
/////////////////////////end xbee//////////////////////////

void xbee_thread(void const *args) // xbee thread
{
    int j;
    j = 0;
    tx_top = tx_end = 0;
    xbee.baud(19200);

    while(1) {
        tx_fifo_check();
        if(++j > 100000) {
            j = 0;

            uint16_t zyrox = analog_value0.read_u16();
            tx_message(31000+(zyrox>>8));
            uint16_t zyroy = analog_value1.read_u16();
            tx_message(32000+(zyroy>>8));
            uint16_t zyroz = analog_value2.read_u16();
            tx_message(33000+(zyroz>>8));
        }

        send_pi(int_pi);

    }

}
int ii = 0;

int main()
{
    Thread thread(xbee_thread);   // define xbee thread

    while(1) {

        if(++ii > 100000) {
            ii = 0;

            LED01 = !LED01;
        }

        check_time[0][0] = checkBT(0);
        send_btn(0);

        check_time[0][1] = checkBT(1);
        send_btn(1);

        check_time[0][2] = checkBT(2);
        send_btn(2);

        check_time[0][3] = checkBT(3);
        send_btn(3);

        check_time[0][4] = checkBT(4);
        send_btn(4);

        check_time[0][5] = checkBT(5);
        send_btn(5);

        check_time[0][6] = checkBT(6);
        send_btn(6);

        check_time[0][7] = checkBT(7);
        send_btn(7);

        check_time[0][8] = checkBT(8);
        send_btn(8);

        int_pi[0] = checkPI();

    }
}

////////////////////////// define function //////////////////////

//check for PIstate
int checkPI()
{
    int checkpt = 0;
    if(PI01 == 1 && PI02 == 1) {
        checkpt = 1;
    } else if(PI01 == 0 && PI02 == 1) {
        checkpt = 2;
    } else if(PI01 == 0 && PI02 == 0) {
        checkpt = 3;
    } else if(PI01 == 1 && PI02 == 0) {
        checkpt = 4;
    } else {
        checkpt = 5; // for error check

    }

    return checkpt;
}

// check for button time
int checkBT(int checkbtn)
{
    int i = 0;

    if(SW[checkbtn][0] == 1 && SW[checkbtn][1] == 0 ) {
        timer[checkbtn].start();
        return i;
    } else if(SW[checkbtn][0] == 1 && SW[checkbtn][1] == 1 ) {
        i = 10002 + (checkbtn * 1000);
        return i;
    } else if(SW[checkbtn][0] == 0 && SW[checkbtn][1] == 0 ) {
        i = 10000 + (checkbtn * 1000);

        check_time[1][checkbtn] = 0;
        return i;
    } else if (SW[checkbtn][0] == 1 && SW[checkbtn][1] == 0 ) {
        return 0;
    }

    else {
        // i = 10003 + (checkbtn * 1);
        return 0;
    }
}
//send pi state
int send_pi(int (*pi_aray))
{
    int i = 0;
    if(pi_aray[0]!= pi_aray[1]) {

        i = 20000 + pi_aray[0];
        tx_message(i);
        pi_aray[1] = pi_aray[0];
        return 0;
    }
    return 0;
}

void send_btn(int checkbtn)
{
    int i = 10002 + (checkbtn * 1000);
    int ii = 0;
    if(check_time[0][checkbtn] == i && check_time[1][checkbtn] == 0) {
        timer[checkbtn].stop();
        ii = timer[checkbtn].read_ms();
        if(ii > 800){
        ii = ii - 800;
        }
        if(ii > 997) {
            ii = 997;

        }
        ii = i+ii;
        
        tx_message(ii);
        timer[checkbtn].reset();
        check_time[1][checkbtn] = 1;

    }
}