#include "mbed.h"
#include "trame.h"
#include "debug.h"

TrameData::TrameData(char idE, char idS, int nbNiveau, char etatP, char niveau, char batterie){
    idEmetteur = idE;
    idStation = idS;
    if(nbNiveau >= 63){
        nombreNiveau = 0x1F;
    }else{
        nombreNiveau = (char) nbNiveau;
    }
    mettreAJourEtatPompe(etatP);
    mettreAJourNiveauCuve(niveau);
    mettreAJourNiveauBatterie(batterie);
    trame[4]=0;
    
}
char getiemebit(char c, int i)
{
     return ((c>>(7-i)) & 1);
}


TrameData::TrameData(char* Buff){
    idStation = Buff[0];
    idEmetteur = Buff[1];
    etatPompe = Buff[2]>>7;
    nombreNiveau = (Buff[2] & 0x7C) >> 2;
    niveauCuve = ((Buff[2] & 0x3)<<3) | ((Buff[3] & 0xE0)>>5);
    niveauBatterie = (Buff[3] & 0xF);
    trame[4]=0;
    
    /*
    
    
    
    //Etat Pompe
    for(int i=0; i < 8; i++){
        if(getiemebit(etatPompe, i)){
            debug("1");
        }
        else{
            debug("0");
        }
    }
    debug("\r\n");
    //nombreNiveau
    for(int i=0; i < 8; i++){
        if(getiemebit(nombreNiveau, i)){
            debug("1");
        }
        else{
            debug("0");
        }
    }
    debug("\r\n niveauCuve \r\n");
    //niveauCuve
    for(int i=0; i < 8; i++){
        if(getiemebit(niveauCuve, i)){
            debug("1");
        }
        else{
            debug("0");
        }
    }
    
    debug("\r\n");
    //niveauBatterie
    for(int i=0; i < 8; i++){
        if(getiemebit(niveauBatterie, i)){
            debug("1");
        }
        else{
            debug("0");
        }
    }*/
}

char TrameData::getIdEmetteur(){
    return idEmetteur;
}
char TrameData::getIdStation(){
    return idStation;
}

char* TrameData::creerTrame(){
    trame[0] = idStation;
    trame[1] = idEmetteur;
    trame[2] = (etatPompe<<7)|(nombreNiveau<<2)|(niveauCuve>>3);
    trame[3] = (niveauCuve<<5)|(niveauBatterie);
    trame[4] = 0;
    
    /*char courant;
    for(int j=0; j<4;j++){
        courant = trame[j];
        for(int i=0; i < 8; i++){
            if(getiemebit(courant, i)){
                debug("1");
            }
            else{
                debug("0");
            }
        }
        debug(" ");
    }
    debug("\r\n");
    
    
    //Etat Pompe
    for(int i=0; i < 8; i++){
        if(getiemebit(etatPompe, i)){
            debug("1");
        }
        else{
            debug("0");
        }
    }
    debug("\r\n");
    //nombreNiveau
    for(int i=0; i < 8; i++){
        if(getiemebit(nombreNiveau, i)){
            debug("1");
        }
        else{
            debug("0");
        }
    }
    debug("\r\n");
    //niveauCuve
    for(int i=0; i < 8; i++){
        if(getiemebit(niveauCuve, i)){
            debug("1");
        }
        else{
            debug("0");
        }
    }
    
    debug("\r\n");
    //niveauBatterie
    for(int i=0; i < 8; i++){
        if(getiemebit(niveauBatterie, i)){
            debug("1");
        }
        else{
            debug("0");
        }
    }
    
    //debug("%c ; %c ; %c\r\n",trame[0],trame[1],trame[2]);
    char courant;
    debug("%d\r\n", sizeof(char));
    for(int j=0; j<3;j++){
        courant = trame[j];
        for(int i=0; i < 8; i++){
            if(getiemebit(courant, i)){
                debug("1");
            }
            else{
                debug("0");
            }
        }
        debug(" ");
    }
    debug("\r\n");
   */
    
    return trame;
}
void TrameData::mettreAJourEtatPompe(char etatP){
    etatPompe = etatP;
}
void TrameData::mettreAJourNiveauCuve(char niveau){
    niveauCuve = niveau;
}
void TrameData::mettreAJourNiveauBatterie(char niveau){
    niveauBatterie = niveau;
}
