#ifndef __TRAME_H
#define __TRAME_H

#include "mbed.h"
#define TAILLE_TRAME_DATA 5 //octets 4+1 for null char

/**
* Represente une trame de donnée
**/

class TrameData {
  private:
    char idEmetteur; // 1 octet
    char idStation; //1 octet
    char etatPompe; //1 bit  
    char nombreNiveau; //5 bits
    char niveauCuve;  //5 bits
    char niveauBatterie; //4bits
    char trame[TAILLE_TRAME_DATA];
  
  public:
    //Creer un objet trame a partir de parametres
    TrameData(char idE, char idS, int nbNiveau, char etatP, char niveau, char batterie);
    //Creer un objet trame a partir d'un tableau de caracteres (ici le buffer)
    char* creerTrame();
    
    //Mise a jour des differents champs
    void mettreAJourEtatPompe(char etatP);
    void mettreAJourNiveauCuve(char niveau);
    void mettreAJourNiveauBatterie(char niveau);
};

#endif // __TRAME_H