#include "mbed.h"
#include "niveau.h"
#include "debug.h"


Niveau::Niveau(PinName GS, PinName pfort, PinName pm, PinName pfaible) : gs(GS), p1(pfort) , p2(pm) , p3(pfaible){
    gs.mode(PullDown);
    p1.mode(PullDown);
    p2.mode(PullDown);
    p3.mode(PullDown);
}

//Retourne le i eme bit du char c
char getiemebit3(char c, int i)
{
     return ((c>>(7-i)) & 1);
}

char Niveau::getNiveauCuve(){
    debug( "GS : %d\n\r",gs.read());
    debug( "p1 : %d\n\r",p1.read());
    debug( "p2 : %d\n\r",p2.read());
    debug( "p3 : %d\n\r",p3.read());
    
    char a = 0;
    if(gs.read()){
        a = (char) (gs.read()<<3);
    }else{
        a = (char) ((p1.read()<<2) | (p2.read()<<1) | (p3.read()));
    }
    //niveauCuve
    /*debug("Niveau cuve : ");
    for(int i=0; i < 8; i++){
        if(getiemebit3(a, i)){
            debug("1");
        }
        else{
            debug("0");
        }
    }
    debug("\r\n");*/
    return a;
}