#ifndef __ORDRE_H
#define __ORDRE_H

#include "mbed.h"
#include "pompe.h"
#include "niveau.h"

#define TAILLE_TRAME_ORDRE 3 //octets

//Representation d'un ordre (format de trame)
class Ordre {
  private:
    char idEmetteur; // 1 octet
    char idRecepteur; //1 octet
    char niveauCuve;  //5 bits
    char ordreAFaire; // 1 bit
    char trame[TAILLE_TRAME_ORDRE];
  
  public:
    Ordre(char* trameRecu);
    //Voir si on peut faire un thread TODO
    void executerOrdre(Pompe p, Niveau n, char niveauCible);
    char getIdEmetteur();
    char getIdRecepteur();
    char getNiveauCuve();
    char getOrdreAFaire();
};

#endif // __ORDRE_H