/*************************************************************
    Author: Derek Cheung
    Email:  cheungderek@hotmail.com
    Web:    http://clients.teksavvy.com/~cheungderek
    Date:   21 Jun 2011
    Note:   Just some testing but working code
            Read NTP time and date to show Time, Date, Month,
            Year automatically using MAX7221 to drive 6 LEDs
            See my home page for details
*************************************************************/

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "TextLCD.h"
#include "NTPClient.h"
#include "Max7221.h"

#define BLINK_PERIOD 1.8        // LED on period (Initial data)
#define END_PERIOD 0.0001       // Finish period

DigitalOut myled1(LED1);        // Assign LED output port LED1 to LED4
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

TextLCD lcd(p15, p16, p17, p26, p25, p24, p23, 16, 2); // rs,rw,e,d0,d1,d2,d3,16char's x 2 lines
SPI max7221_spi(p5, p6, p7, "max7221"); // mosi, miso, sclk
DigitalOut max7221_cs(p8);
Serial pc(USBTX, USBRX); // tx, rx

unsigned int dec2bcd(unsigned int dec);
void max7221_control(unsigned control);
void display_weekOfDay_month(struct tm *tm_ptr);
void display_day_year(struct tm *tm_ptr);


/*
#include "USBHost.h"
#include "Utils.h"
#include "FATFileSystem.h"
void TestShell();
*/
EthernetNetIf eth;

int main() {

    float tim;
    char buf[40];
    struct tm *tm_ptr;
    unsigned int tmp_int;
    char    *test_ptr;
    time_t ctTime;

    NTPClient ntp;

    // Setup the spi for 16 bit data, sample at falling edge clcok at 1MHz
    max7221_spi.format(16,0);
    max7221_spi.frequency(1000000);

    // shutdown operation
    // max7221_spi.write(0x0C00);

    // turn on all display
    max7221_control(0x0F01);

    // set normal operation
    max7221_control(0x0F00);

    // normal operation
    max7221_control(0x0C01);

    // sacn 6 LED
    max7221_control(0x0B05);

    // BCD mode
    max7221_control(0x09FF);

    // full intensity - Derek
    max7221_control(0x0A0F);

    // testing the char display on the LEDs
    /*
    tm_ptr = localtime(&ctTime);
    tm_ptr->tm_mon=1;
     tm_ptr->tm_mday = 0;
    display_weekOfDay_month(tm_ptr);
    tm_ptr->tm_mon=2;
     tm_ptr->tm_mday = 1;
    display_weekOfDay_month(tm_ptr);
    tm_ptr->tm_mon=3;
     tm_ptr->tm_mday = 2;
    display_weekOfDay_month(tm_ptr);
    tm_ptr->tm_mon=4;
     tm_ptr->tm_mday = 3;
    display_weekOfDay_month(tm_ptr);
    tm_ptr->tm_mon=5;
     tm_ptr->tm_mday = 4;
    display_weekOfDay_month(tm_ptr);
    tm_ptr->tm_mon=6;
     tm_ptr->tm_mday = 5;
    display_weekOfDay_month(tm_ptr);
    tm_ptr->tm_mon=7;
     tm_ptr->tm_mday = 6;
    display_weekOfDay_month(tm_ptr);
    tm_ptr->tm_mon=8;
    display_weekOfDay_month(tm_ptr);
    tm_ptr->tm_mon=9;
    display_weekOfDay_month(tm_ptr);
    tm_ptr->tm_mon=10;
    display_weekOfDay_month(tm_ptr);
    tm_ptr->tm_mon=11;
    display_weekOfDay_month(tm_ptr);
    tm_ptr->tm_mon=12;
    display_weekOfDay_month(tm_ptr);
    */

    // BCD mode
    // max7221_control(0x09FF);

    tim = BLINK_PERIOD;
    lcd.cls();
    lcd.locate(0, 0);

    //          0         1
    // lcd.printf("1234567890123456");
    // lcd.locate(0, 1);
    // lcd.printf("Derek Cheung  v2");

    // If you have implemented the "Windows USB Serial Port Driver", you can use follows.
    // http://mbed.org/projects/handbook/wiki/WindowsSerialConfiguration
    // printf("\r\n Derek Cheung Twitter Device Control - Setting up...\r\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        lcd.locate(0, 1);
        lcd.printf("Network Failed  ");
    }
    printf("\r\n Network Connection Setup OK\r\n");
    
    HTTPClient twitter;

    HTTPMap msg;
    msg["status"] = "Twitter Control logon successfully"; //A good example of Key/Value pair use with Web APIs

    twitter.basicAuth("cheungderek", "34563456"); //We use basic authentication, replace with you account's parameters

    //No need to retieve data sent back by the server
    HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL);
    if ( r == HTTP_OK ) {
        printf("Tweet sent with success!\n");
    } else {
        printf("Problem during tweeting, return code %d\n", r);
    }

    lcd.cls();


    unsigned short tmp_left_led_digit, tmp_right_led_digit;
    int     blink_value = 3;
    Host server(IpAddr(), 123, "0.uk.pool.ntp.org");
    ntp.setTime(server);
    int     resyncNtpServerTimer = 0;
    int     mDayDisplayTimer = 0;
    int     monthDisplayTimer = 0;
    HTTPText txt;
    
    while (1) {
        /* for (tim =BLINK_PERIOD; tim >=  END_PERIOD; tim /= 3) {
            myled1 = 1;
            wait(tim);
            myled1 = 0;
            myled2 = 1;
            wait(tim);
            myled2 = 0;
            myled3 = 1;
            wait(tim);
            myled3 = 0;
            myled4 = 1;
            wait(tim);
            myled4 = 0;
        }
        */

        /*
        printf("\r\n trying to get a tweet \r\n");
        twitter.get("http://api.supertweet.net/1/statuses/update.xml", &txt); //Blocking
        printf("\r\n HTTP data %s \r\n", txt);
        */
    
        tmp_left_led_digit = 0;
        tmp_right_led_digit = 0;

        // sprintf(buf,"loop # = %d", count);
        ctTime = time(NULL) - 14400;        // EST is 4  hours behind UTC
        // set_time(ctTime);       // set the RTC clock)
        // printf("%d - RTC time is (UTC): %s \r \n", n++, ctime(&ctTime));
        tm_ptr = localtime(&ctTime);

        strftime(buf, 32, "%a %b %d %Y ", localtime(&ctTime));
        lcd.locate(0,0);    // 1st line
        lcd.printf(buf);

        blink_value++;

        // Display Seconds on the LED1 and LED2
        tmp_int = dec2bcd(tm_ptr->tm_sec);
        // re-sync the NTP clock to RTC every 2 minutes / hours
        resyncNtpServerTimer++;
        if (resyncNtpServerTimer == 100000) {
            lcd.locate(0, 1);
            lcd.printf("NTP Server Sync ");
            wait(1);
            // ethErr = eth.setup();
            if (ethErr) {
                printf("Error %d in setup.\n", ethErr);
                lcd.locate(0, 1);
                lcd.printf("Network Failed  ");
            } else {
                printf("\r\nNetwork Connection Setup OK\r\n");
                // backup the time in case ntp server fails
                ctTime = time(NULL); 
                if (ntp.setTime(server) != 0) {
                    lcd.locate(0,1);
                    lcd.printf("NTP Sync Failed ");
                    set_time(ctTime);
                }
            }
            wait(1);
            resyncNtpServerTimer = 0;
        }
        // lcd.locate(0,1);
        // lcd.printf("                ");
        
        mDayDisplayTimer++;
        if (mDayDisplayTimer == 1200) {
            display_day_year(tm_ptr);
            display_weekOfDay_month(tm_ptr);
            mDayDisplayTimer = 0;
        }
        
        tmp_left_led_digit = (unsigned short) tmp_int >> 4;
        tmp_right_led_digit = (unsigned short) tmp_int & 0x000F;
        max7221_control(LED_DIGIT1 | tmp_right_led_digit);
        max7221_control(LED_DIGIT2 | tmp_left_led_digit);



        // Display Minutes on the LED3 and LED4
        tmp_int = dec2bcd(tm_ptr->tm_min);
        tmp_left_led_digit = (unsigned short) tmp_int >> 4;
        tmp_right_led_digit = (unsigned short) tmp_int & 0x000F;
        max7221_control(LED_DIGIT3 | tmp_right_led_digit | 0x0080);


        /*
        if ((blink_value % 4) == 0)
            max7221_control(LED_DIGIT3 | tmp_right_led_digit | 0x0080);
        else
            max7221_control(LED_DIGIT3 | tmp_right_led_digit & 0xFF7F);
        */
        max7221_control(LED_DIGIT4 | tmp_left_led_digit);

        // Display Hours on the LED5 and LED6
        tmp_int = dec2bcd(tm_ptr->tm_hour);
        tmp_left_led_digit = (unsigned short) tmp_int >> 4;
        tmp_right_led_digit = (unsigned short) tmp_int & 0x000F;
        max7221_control(LED_DIGIT5 | tmp_right_led_digit | 0x0080);



        /*
        if ((blink_value % 4) == 0)
            max7221_control(LED_DIGIT5 | tmp_right_led_digit | 0x0080);
        else
            max7221_control(LED_DIGIT5 | tmp_right_led_digit & 0xFF7F);
        */
        max7221_control(LED_DIGIT6 | tmp_left_led_digit);

        /* Ethernet read Twitter message */


        /*
                tmp_left_led_digit = (unsigned short) tmp_int >> 4;
                tmp_right_led_digit = (unsigned short) tmp_int & 0x000F;

                // printf("\r\n unsigned in  %d, unsigned short int  %d, char %d  - ", sizeof(unsigned int), sizeof(unsigned short int), sizeof(char));


                printf("\r\n tmp_left_led_digit %X \r\n", tmp_left_led_digit | 0x0100);
                max7221_cs = 0;
                max7221_spi.write(tmp_left_led_digit | 0x0200);
                max7221_cs = 1;
                wait(0.01);

                max7221_cs = 0;
                max7221_spi.write(tmp_right_led_digit | 0x0100);
                max7221_cs = 1;

                tmp_int = dec2bcd(tm_ptr->tm_sec);
                max7221_cs = 0;
                max7221_spi.write(0x0100 || (tmp_int & 0x0F));
                max7221_cs = 1;
        */

    }
    return 0;
};

/*
       //  strftime(buf, 16, "%X", localtime(&ctTime));
       // lcd.locate(0, 1);   // 2nd line
       //  lcd.printf(buf);
        //sprintf(buf, ctime(&ctTime));

        // lcd.printf(buf);
        // printf(" Current loop count number = %d \r\n", count);
        // count++;


    pc.baud(460800);
    printf("BlueUSB\nNow get a bunch of usb or bluetooth things and plug them in\n");
    TestShell();
*/

unsigned int dec2bcd(unsigned int dec) {
    unsigned int bits, bcd = 0;
    for ( bits = 0; dec; bits += 4, dec /= 10 ) {
        bcd |= dec % 10 << bits;
    }
    return bcd;
}


void max7221_control(unsigned control) {
    max7221_cs = 0;
    max7221_spi.write(control);
    max7221_cs = 1;
    wait(0.001);
}

void display_weekOfDay_month(struct tm *tm_ptr) {

    // no decode
    max7221_control(0x0900);
    
    max7221_control(LED_DIGIT6 | LED__);
    max7221_control(LED_DIGIT5 | LED__);
    max7221_control(LED_DIGIT4 | LED__);
 
    switch(tm_ptr->tm_mon + 1) {
    case 1 : 
        max7221_control(LED_DIGIT6 | LED_J);
        max7221_control(LED_DIGIT5 | LED_A);
        max7221_control(LED_DIGIT4 | LED_N);
        max7221_control(LED_DIGIT3 | LED_U);
        max7221_control(LED_DIGIT2 | LED_A);
        max7221_control(LED_DIGIT1 | LED_r);       
        break;
    case 2 :
        max7221_control(LED_DIGIT6 | LED_F);
        max7221_control(LED_DIGIT5 | LED_E);
        max7221_control(LED_DIGIT4 | LED_b);
        max7221_control(LED_DIGIT3 | LED_U);
        max7221_control(LED_DIGIT2 | LED_A);
        max7221_control(LED_DIGIT1 | LED_r);
        break;
    case 3 : 
        max7221_control(LED_DIGIT5 | LED_M);
        max7221_control(LED_DIGIT4 | LED_A);
        max7221_control(LED_DIGIT3 | LED_r);
        max7221_control(LED_DIGIT2 | LED_C);
        max7221_control(LED_DIGIT1 | LED_H);
        break;
    case 4 :
        max7221_control(LED_DIGIT5 | LED_A);
        max7221_control(LED_DIGIT4 | LED_P);
        max7221_control(LED_DIGIT3 | LED_r);
        max7221_control(LED_DIGIT2 | LED_i);
        max7221_control(LED_DIGIT1 | LED_I);
        break;
    case 5 :
        max7221_control(LED_DIGIT3 | LED_M);
        max7221_control(LED_DIGIT2 | LED_A);
        max7221_control(LED_DIGIT1 | LED_y);
        break;
    case 6 :
        max7221_control(LED_DIGIT4 | LED_J);
        max7221_control(LED_DIGIT3 | LED_U);
        max7221_control(LED_DIGIT2 | LED_N);
        max7221_control(LED_DIGIT1 | LED_E);
        break;
    case 7 :
        max7221_control(LED_DIGIT4 | LED_J);
        max7221_control(LED_DIGIT3 | LED_U);
        max7221_control(LED_DIGIT2 | LED_L);
        max7221_control(LED_DIGIT1 | LED_y);
        break;
    case 8 :
        max7221_control(LED_DIGIT6 | LED_A);
        max7221_control(LED_DIGIT5 | LED_U);
        max7221_control(LED_DIGIT4 | LED_g);
        max7221_control(LED_DIGIT3 | LED_U);
        max7221_control(LED_DIGIT2 | LED_S);
        max7221_control(LED_DIGIT1 | LED_r);
        break;
    case 9 :
        max7221_control(LED_DIGIT6 | LED_S);
        max7221_control(LED_DIGIT5 | LED_E);
        max7221_control(LED_DIGIT4 | LED_P);
        max7221_control(LED_DIGIT3 | LED_t);
        max7221_control(LED_DIGIT2 | LED_E);
        max7221_control(LED_DIGIT1 | LED_M);
        break;
    case 10 :
        max7221_control(LED_DIGIT6 | LED_O);
        max7221_control(LED_DIGIT5 | LED_C);
        max7221_control(LED_DIGIT4 | LED_t);
        max7221_control(LED_DIGIT3 | LED_O);
        max7221_control(LED_DIGIT2 | LED_b);
        max7221_control(LED_DIGIT1 | LED_E);
        break;
    case 11 :
        max7221_control(LED_DIGIT6 | LED_N);
        max7221_control(LED_DIGIT5 | LED_O);
        max7221_control(LED_DIGIT4 | LED_V);
        max7221_control(LED_DIGIT3 | LED_E);
        max7221_control(LED_DIGIT2 | LED_M);
        max7221_control(LED_DIGIT1 | LED_b);
        break;
    case 12 :
        max7221_control(LED_DIGIT5 | LED_E);
        max7221_control(LED_DIGIT5 | LED_E);
        max7221_control(LED_DIGIT4 | LED_C);
        max7221_control(LED_DIGIT3 | LED_E);
        max7221_control(LED_DIGIT2 | LED_M);
        max7221_control(LED_DIGIT1 | LED_b);
        break;
    default :
        max7221_control(LED_DIGIT5 | LED_M);
        max7221_control(LED_DIGIT5 | LED_E);
        max7221_control(LED_DIGIT4 | LED_r);
        max7221_control(LED_DIGIT3 | LED_r); 
        max7221_control(LED_DIGIT2 | LED_o);
        max7221_control(LED_DIGIT1 | LED_r);     
    }
    
    wait(1.5);
  
    // printf("tm_ptr->tm_year %d \r\n", tm_ptr->tm_year);
    max7221_control(LED_DIGIT6 | LED__);
    max7221_control(LED_DIGIT5 | LED__);
         
    switch(tm_ptr->tm_year - 100) {
    case 11 : 
        max7221_control(LED_DIGIT4 | LED_2);
        max7221_control(LED_DIGIT3 | LED_0);
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_1);
        break;
    case 12 :
        max7221_control(LED_DIGIT4 | LED_2);
        max7221_control(LED_DIGIT3 | LED_0);
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_2);
        break;
    case 13 : 
        max7221_control(LED_DIGIT4 | LED_2);
        max7221_control(LED_DIGIT3 | LED_0);
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_3);
        break;
    case 14 :
        max7221_control(LED_DIGIT4 | LED_2);
        max7221_control(LED_DIGIT3 | LED_0);
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_4);
        break;
    case 15 :
        max7221_control(LED_DIGIT4 | LED_2);
        max7221_control(LED_DIGIT3 | LED_0);
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_5);
        break;
    case 16 :
        max7221_control(LED_DIGIT4 | LED_2);
        max7221_control(LED_DIGIT3 | LED_0);
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_6);
        break;
    case 17 :
        max7221_control(LED_DIGIT4 | LED_2);
        max7221_control(LED_DIGIT3 | LED_0);
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_7);
        break;
    case 18 :
        max7221_control(LED_DIGIT4 | LED_2);
        max7221_control(LED_DIGIT3 | LED_0);
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_8);
        break;
    case 19 :
        max7221_control(LED_DIGIT4 | LED_2);
        max7221_control(LED_DIGIT3 | LED_0);
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_9);
        break;
    case 20 :
        max7221_control(LED_DIGIT4 | LED_2);
        max7221_control(LED_DIGIT3 | LED_0);
        max7221_control(LED_DIGIT2 | LED_2);
        max7221_control(LED_DIGIT1 | LED_0);
        break;
    default :
        max7221_control(LED_DIGIT5 | LED_y);
        max7221_control(LED_DIGIT5 | LED_E);
        max7221_control(LED_DIGIT4 | LED_r);
        max7221_control(LED_DIGIT3 | LED_r);
        max7221_control(LED_DIGIT2 | LED_o);
        max7221_control(LED_DIGIT1 | LED_r);
    }
    
    wait(1.5);
    // BCD mode
    max7221_control(0x09FF);
}

void display_day_year(struct tm *tm_ptr) {
    // no decode
    max7221_control(0x0900);
    
    printf("tm_ptr->tm_wday %d \r\n", tm_ptr->tm_wday);
    switch(tm_ptr->tm_wday) {
    case 0 :
        max7221_control(LED_DIGIT6 | LED_S);
        max7221_control(LED_DIGIT5 | LED_U);
        max7221_control(LED_DIGIT4 | LED_N);
        break;
    case 1 :
        max7221_control(LED_DIGIT6 | LED_M);
        max7221_control(LED_DIGIT5 | LED_O);
        max7221_control(LED_DIGIT4 | LED_N);
        break;
    case 2 :
        max7221_control(LED_DIGIT6 | LED_t);
        max7221_control(LED_DIGIT5 | LED_U);
        max7221_control(LED_DIGIT4 | LED_E);
        break;
    case 3 :
        max7221_control(LED_DIGIT6 | LED_W);
        max7221_control(LED_DIGIT5 | LED_E);
        max7221_control(LED_DIGIT4 | LED_d);
        break;
    case 4 :
        max7221_control(LED_DIGIT6 | LED_t);
        max7221_control(LED_DIGIT5 | LED_h);
        max7221_control(LED_DIGIT4 | LED_u);
        break;
    case 5 :
        max7221_control(LED_DIGIT6 | LED_F);
        max7221_control(LED_DIGIT5 | LED_r);
        max7221_control(LED_DIGIT4 | LED_i);
        break;
    case 6 :
        max7221_control(LED_DIGIT6 | LED_S);
        max7221_control(LED_DIGIT5 | LED_A);
        max7221_control(LED_DIGIT4 | LED_t);
        break;
    default :
        max7221_control(LED_DIGIT6 | LED_E);
        max7221_control(LED_DIGIT5 | LED_r);
        max7221_control(LED_DIGIT4 | LED_r);
    }

    max7221_control(LED_DIGIT3 | LED__);
    max7221_control(LED_DIGIT2 | LED__);
    switch(tm_ptr->tm_mday) {
    case 1 :
        max7221_control(LED_DIGIT1 | LED_1);
        break;
    case 2 :
        max7221_control(LED_DIGIT1 | LED_2);
        break;
    case 3 :
        max7221_control(LED_DIGIT1 | LED_3);
        break;
    case 4 :
        max7221_control(LED_DIGIT1 | LED_4);
        break;
    case 5 :
        max7221_control(LED_DIGIT1 | LED_5);
        break;
    case 6 :
        max7221_control(LED_DIGIT1 | LED_6);
        break;
    case 7 :
        max7221_control(LED_DIGIT1 | LED_7);
        break;
    case 8 :
        max7221_control(LED_DIGIT1 | LED_8);
        break;
    case 9 :
        max7221_control(LED_DIGIT1 | LED_9);
        break;
    case 11 :
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_0);
        break;
    case 12 :
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_2);
        break;
    case 13 :
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_3);
        break;
    case 14 :
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_4);
        break;
    case 15 :
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_5);
        break;
    case 16 :
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_6);
        break;
    case 17 :
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_7);
        break;
    case 18 :
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_8);
        break;
    case 19 :
        max7221_control(LED_DIGIT2 | LED_1);
        max7221_control(LED_DIGIT1 | LED_9);
        break;
    case 20 :
        max7221_control(LED_DIGIT2 | LED_2);
        max7221_control(LED_DIGIT1 | LED_0);
        break;
    case 21 :
        max7221_control(LED_DIGIT2 | LED_2);
        max7221_control(LED_DIGIT1 | LED_1);
        break;
    case 22 :
        max7221_control(LED_DIGIT2 | LED_2);
        max7221_control(LED_DIGIT1 | LED_2);
        break;
    case 23 :
        max7221_control(LED_DIGIT2 | LED_2);
        max7221_control(LED_DIGIT1 | LED_3);
        break;
    case 24 :
        max7221_control(LED_DIGIT2 | LED_2);
        max7221_control(LED_DIGIT1 | LED_4);
        break;
    case 25 :
        max7221_control(LED_DIGIT2 | LED_2);
        max7221_control(LED_DIGIT1 | LED_5);
        break;
    case 26 :
        max7221_control(LED_DIGIT2 | LED_2);
        max7221_control(LED_DIGIT1 | LED_6);
        break;
    case 27 :
        max7221_control(LED_DIGIT2 | LED_2);
        max7221_control(LED_DIGIT1 | LED_7);
        break;
    case 28 :
        max7221_control(LED_DIGIT2 | LED_2);
        max7221_control(LED_DIGIT1 | LED_8);
        break;
    case 29 :
        max7221_control(LED_DIGIT2 | LED_2);
        max7221_control(LED_DIGIT1 | LED_9);
        break;
    case 30 :
        max7221_control(LED_DIGIT2 | LED_3);
        max7221_control(LED_DIGIT1 | LED_0);
        break;
    case 31 :
        max7221_control(LED_DIGIT2 | LED_3);
        max7221_control(LED_DIGIT1 | LED_1);
        break;
    }
    wait(1.5);
    // BCD mode
    max7221_control(0x09FF);
}

/*
DigitalOut myled(LED1);

int main() {
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
*/
