#include "mbed.h"
#include "Adafruit_LEDBackpack.h"
#include "Adafruit_GFX.h"
 
I2C i2c(p9, p10); //declare led matrix 12c ports
 
Adafruit_8x8matrix matrix = Adafruit_8x8matrix(&i2c); //set up matrix
//AnalogIn sensor0(p16);
//AnalogIn sensor1(p17);
//AnalogIn sensor2(p18);    // declare photocells and their pins
//AnalogIn sensor3(p19);
//AnalogIn sensor4(p20);
//DigitalOut pin8 (p8);  //power

AnalogIn cell0(p15);
AnalogIn cell1(p16);
AnalogIn cell2(p17);
AnalogIn cell3(p18);
AnalogIn cell4(p19);
AnalogIn cell5(p20);
DigitalOut pin8(p8);

float threshold = 0.2;  //Whatever makes a good sensitivity level

int leds[8][8];
int row;
int col;

int main() {
    matrix.begin(0x70);
   pin8=1; //power on
      
while(1) {
      for (row = 7; row >=1; row--)
         for (col = 0; col <=7; col++)
            leds[row][col] = leds[row+1][col];  // These nested loops move everything down one row, except the top row

      leds[0][0] = (int)(cell0 + threshold);   // These assignments fill the top row with the cell values
      leds[0][1] = (int)(cell1 + threshold);   // Each value should be 0 or 1
      leds[0][2] = (int)(cell2 + threshold);
      leds[0][3] = (int)(cell3 + threshold);
      leds[0][4] = (int)(cell4 + threshold);
      leds[0][5] = (int)(cell5 + threshold);
      
      printf("Value0 = %f\r\n", cell0.read());
      printf("Value1 = %f\r\n", cell1.read()); 
      printf("Value2 = %f\r\n", cell2.read()); 
      printf("Value3 = %f\r\n", cell3.read()); 
      printf("Value4 = %f\r\n", cell4.read());  
      wait(1.0); 
      
        matrix.clear();
                   
        if(cell0 <= 0.2){
        matrix.drawPixel (0, 0, LED_ON);}
        else  matrix.drawPixel (0, 0, LED_OFF);
             
        if(cell1 <= 0.2){
        matrix.drawPixel (1, 0, LED_ON);}
        else  matrix.drawPixel (1, 0, LED_OFF);     
        
        if(cell2 <= 0.2){
        matrix.drawPixel (2, 0, LED_ON);}
        else  matrix.drawPixel (2, 0, LED_OFF);
        
        if(cell3 <= 0.2){
        matrix.drawPixel (3, 0, LED_ON);}
        else  matrix.drawPixel (3, 0, LED_OFF);
           
        if(cell4 <= 0.2){
        matrix.drawPixel (4, 0, LED_ON);}
        else  matrix.drawPixel (4, 0, LED_OFF);

  matrix.writeDisplay();  // write the changes we just made to the display
  wait(0.2);
  }
}
