


#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"
 
// Onboard LEDs (for testing)
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// RBG LED
PwmOut RGBLED_r(p23);
PwmOut RGBLED_g(p24);
PwmOut RGBLED_b(p25);

// LCD Screen
uLCD_4DGL uLCD(p9,p10,p17); // serial tx, serial rx, reset pin;

Thread thread1;
Thread thread2;
Thread thread3;

// mutex to make the lcd lib thread safe
Mutex lcd_mutex;

//SD Card
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card

AnalogOut DACout(p18);

wave_player waver(&DACout);

//Bouncing Ball Demo
float fx=60.0,fy=60.0,vx=1.0,vy=0.4;
int x=60,y=60,radius=4;
int i = 0;
 
void led2_thread() {
    while (true) {
        lcd_mutex.lock();
        //erase old ball location
        uLCD.filled_circle(x, y, radius, BLACK);
        //move ball
        fx=fx+vx;
        fy=fy+vy;
        x=(int)fx;
        y=(int)fy;
        //draw ball
        uLCD.filled_circle(x, y, radius, RED);
        lcd_mutex.unlock();
        //bounce off edge walls and slow down a bit?
        if ((x<=radius+1) || (x>=126-radius)) vx = -.90*vx;
        if ((y<=radius+51) || (y>=126-radius)) vy = -.90*vy;
        Thread::wait(40);
    }
}

void led3_thread() {
    while (true) {
        lcd_mutex.lock();
        uLCD.locate(1,3);
        uLCD.printf("%2D",i);
        lcd_mutex.unlock();
        i++;
        Thread::wait(1000);
    }
}

void led4_thread() {
    while(true) {         // thread loop
        RGBLED_r = 0.5 + (rand() % 11)/20.0;
        RGBLED_g = 0.1 + (rand() % 11)/20.0;
        RGBLED_b = 0.1 + (rand() % 11)/20.0;
        Thread::wait(40);    
    }
}
 
int main() {
    thread1.start(led2_thread);
    thread2.start(led3_thread);
    thread3.start(led4_thread);
    
    lcd_mutex.lock();
    //draw walls
    uLCD.line(0, 50, 127, 50, WHITE);
    uLCD.line(127, 50, 127, 127, WHITE);
    uLCD.line(127, 127, 0, 127, WHITE);
    uLCD.line(0, 127, 0, 50, WHITE);
    uLCD.locate(0,1);
    uLCD.printf("Seconds Since \nInitialisation: "); //Default Green on black text
    lcd_mutex.unlock();
    
    FILE *wave_file;
    printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/OriginalSeriesMainTitle.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
    while (true) {
        led1 = !led1;

        
        Thread::wait(500);
    }
}