#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPSocket.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

#include <stdio.h>
#include <string>
using namespace std;



#define MQTT_HOST               "192.168.0.113"
#define MQTT_PORT               1883
#define MQTT_TOPIC              "v1/devices/me/telemetry"

#include "MQTTNetwork.h"

#define IP      "192.168.0.181"
#define GATEWAY "192.168.0.1"
#define NETMASK "255.255.255.0"

/* */
EthernetInterface*  net;

AnalogIn adc_A0(A0); // PA_3
AnalogIn adc_A1(A1); // PC_0
AnalogIn adc_A2(A2); // PC_3
AnalogIn adc_A3(PF_6);
AnalogIn adc_A4(A4); // PF_5
AnalogIn adc_A5(A5); // PF_10
AnalogIn adc_A6(PF_8);
AnalogIn adc_A7(PF_7);
AnalogIn adc_A8(PF_9);
AnalogIn adc_A9(PF_4);

DigitalOut led(LED1);

DigitalOut gpS0(PD_7);
DigitalOut gpS1(PD_6);
DigitalOut gpS2(PD_5);
DigitalOut gpS3(PD_4);


BufferedSerial pc(SERIAL_TX, SERIAL_RX, 115200);

#define ADC_NUM 9 + 16
uint16_t ADCResult[ADC_NUM];

#define BACKUP_NUM 50
uint16_t ADCBackup[ADC_NUM][BACKUP_NUM] = { 0x00, };

Thread thread;

#define MUX_MAX_NUM 16
int muxChannel[16][4]={
    {0,0,0,0}, //channel 0
    {1,0,0,0}, //channel 1
    {0,1,0,0}, //channel 2
    {1,1,0,0}, //channel 3
    {0,0,1,0}, //channel 4
    {1,0,1,0}, //channel 5
    {0,1,1,0}, //channel 6
    {1,1,1,0}, //channel 7
    {0,0,0,1}, //channel 8
    {1,0,0,1}, //channel 9
    {0,1,0,1}, //channel 10
    {1,1,0,1}, //channel 11
    {0,0,1,1}, //channel 12
    {1,0,1,1}, //channel 13
    {0,1,1,1}, //channel 14
    {1,1,1,1}  //channel 15
  };
  
int readADCMux(int _ch)
{
  // 4개 컨트롤핀 (s0,s1,s2,s3) 핀 설정
  gpS0 = muxChannel[_ch][0];
  gpS1 = muxChannel[_ch][1];
  gpS2 = muxChannel[_ch][2];
  gpS3 = muxChannel[_ch][3];

  // SIG pin 읽기
  return adc_A0.read_u16();
}   
  

/**
 * @brief
 * @note
 * @param
 * @retval
 */
int main(void)
{
    
    gpS0 = 1;
    gpS1 = 1;
    gpS2 = 1;
    gpS3 = 1;
    // printf("\r\n Starting \r\n");

    //ethLed.start(eth_led);
    //net = NetworkInterface::get_default_instance();
    net = new EthernetInterface();

    //net->set_network("192.168.1.181","255.255.255.0","192.168.1.1");  // use static IP address, netmask, gateway
    if (!net) {
        printf("Error! No network inteface found.\n");
        return 0;
    }

    //net->set_network (IP, NETMASK, GATEWAY);  // include this for using static IP address
    nsapi_size_or_error_t   r = net->connect();
    if (r != NSAPI_ERROR_OK) {
        printf("Error! net->connect() returned: %d\n", r);
        return r;
    }

    // Show the network address
    SocketAddress   addr;
    net->get_ip_address(&addr);
    //printf("IP address: %s\n", addr.get_ip_address() ? addr.get_ip_address() : "None");
    net->get_netmask(&addr);
    //printf("Netmask: %s\n", addr.get_ip_address() ? addr.get_ip_address() : "None");
    net->get_gateway(&addr);
    //printf("Gateway: %s\n", addr.get_ip_address() ? addr.get_ip_address() : "None");

    int count = 0;
    while(1)
    {
        // printf("percentage: %3.3f%%\n", adc_A0.read()*100.0f);
        char temp[128] = { 0x00, };
        for(int i = 0; i < MUX_MAX_NUM; i++)
        {
            ADCBackup[i][count % MUX_MAX_NUM] = readADCMux(i);
                double total = 0;
                for(int j = 0; j < BACKUP_NUM; j++)
                {
                    total += ADCBackup[i][j];
                }
                ADCResult[i] = total / BACKUP_NUM;            
        }
        
                sprintf(temp, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d \n", 
                    ADCResult[0], 
                    ADCResult[1], 
                    ADCResult[2], 
                    ADCResult[3], 
                    ADCResult[4], 
                    ADCResult[5], 
                    ADCResult[6], 
                    ADCResult[7], 
                    ADCResult[8], 
                    ADCResult[9], 
                    ADCResult[10], 
                    ADCResult[11], 
                    ADCResult[12], 
                    ADCResult[13], 
                    ADCResult[14], 
                    ADCResult[15] 
                    
                    );       
  
        
            /*
            for(int i = 0; i < ADC_NUM; i++) {
                
                switch(i)
                {
                    case 0: ADCBackup[i][count % BACKUP_NUM] = adc_A0.read_u16(); break;
                    case 1: ADCBackup[i][count % BACKUP_NUM] = adc_A1.read_u16(); break;
                    case 2: ADCBackup[i][count % BACKUP_NUM] = adc_A2.read_u16(); break;
                    case 3: ADCBackup[i][count % BACKUP_NUM] = adc_A3.read_u16(); break;
                    case 4: ADCBackup[i][count % BACKUP_NUM] = adc_A4.read_u16(); break;
                    case 5: ADCBackup[i][count % BACKUP_NUM] = adc_A5.read_u16(); break;
                    case 6: ADCBackup[i][count % BACKUP_NUM] = adc_A6.read_u16(); break;
                    case 7: ADCBackup[i][count % BACKUP_NUM] = adc_A7.read_u16(); break;
                    case 8: ADCBackup[i][count % BACKUP_NUM] = adc_A8.read_u16(); break;
                    case 9: ADCBackup[i][count % BACKUP_NUM] = adc_A9.read_u16(); break;
                    }
                    
                double total = 0;
                for(int j = 0; j < BACKUP_NUM; j++)
                {
                    total += ADCBackup[i][j];
                }
                ADCResult[i] = total / BACKUP_NUM;
            }
            
            
            
                sprintf(temp, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d \n", 
                    ADCResult[0], 
                    ADCResult[1], 
                    ADCResult[2], 
                    ADCResult[3], 
                    ADCResult[4], 
                    ADCResult[5], 
                    ADCResult[6], 
                    ADCResult[7], 
                    ADCResult[8], 
                    ADCResult[9] 
                    ); */
               
    /*
            sprintf(temp, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d \n", 
                adc_A0.read_u16(), 
                adc_A1.read_u16(),
                adc_A2.read_u16(),
                adc_A3.read_u16(),
                adc_A4.read_u16(),
                adc_A5.read_u16(),
                adc_A6.read_u16(),
                adc_A7.read_u16(),
                adc_A8.read_u16(),
                adc_A9.read_u16()
                ); */
                
        printf(temp);
            
        if(count % 10 == 0) {
            
            
            UDPSocket sock;
            sock.open(net);
            
            uint16_t port = 50000;
            const char addr[16] = "192.168.0.104";        
            SocketAddress sAddr(addr, port);
     
            if(0 > sock.sendto(sAddr, temp, strlen(temp))) {
                printf("Error sending data\n");
                break;
            }
            
            sock.close();
        }
                
        count += 1;
        
        led = !led;
        ThisThread::sleep_for(10);
    }

}
