#include "mbed.h"
#include "rtos.h"
#include "ATParser.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include  "Speaker.h"
//#include "wave_player.h"
#include <string>
#include <iostream>
using namespace std;

//General setups
DigitalOut cmdMode(p18);
Serial pc(USBTX, USBRX);
BufferedSerial ble(p13,p14);
DigitalOut cmdstuff(p18);
DigitalOut greenLED(p24);
DigitalOut yellowLED(p25);
DigitalOut redLED(p26);
uLCD_4DGL uLCD(p28,p27,p30);
SDFileSystem sd(p5, p6, p7, p8, "sd");
PwmOut speaker(p21);
//DigitalOut speaker_on(p23);

//AT command data handlers
bool datalogged = 0;
//bool changed = 0;
char delimiter[] = "\r\n";
int buffer_size = 256;
int timeout = 100;
bool debug = false;
ATParser at(ble, delimiter, buffer_size, timeout, debug);
char buffer[10];
volatile int risk_level = 0;
//speaker_on = 0;

//RTOS Mutex Lock
Mutex mutex_lock;

time_t seconds;

//Global Data points and arrays
int averageCount = 0;
volatile int RSSI_array[15];

//This portion of the code handles RSSI readings

int calculate_average(volatile int *input, int size)
{
    int average;
    for(int i = 0; i< size; i++) {
        average = average + input[i];
    }
    average = average/size;
    return average;
}

void parse_RSSI()
{
    mutex_lock.lock();
    at.send("AT+BLEGETRSSI") && at.read(buffer, 10);
    if(buffer[0] == '-') {
        datalogged = 1;
        pc.printf("RSSI: ");
        pc.putc(buffer[1]);
        pc.putc(buffer[2]);
        pc.printf("\n");
        int digit1 = buffer[1] - 48; //Converts char to int
        int digit2 = buffer[2] - 48;
        int total = 10*digit1 + digit2;
        if (averageCount <= 15) {
            RSSI_array[averageCount] = total;
        }
        averageCount++;
        if(averageCount > 15 && buffer[0] == '-') {
            averageCount = 0;
            int average = calculate_average(RSSI_array, 15);
            if(average < 55) {
                risk_level = 3;
            } else if(average > 55 && average < 70) {
                risk_level = 2;
            } else if(average > 70 && average < 90) {
                risk_level = 1;
            } else {
                risk_level = 0;
            }
        }
        pc.printf("Risk level: ");
        pc.printf("%i\n", risk_level);
    } else {
        pc.printf("Disconnected\n");
        datalogged = 0;
    }
    mutex_lock.unlock();
}


void speaker_alarm()
{
    while(1) {
        if(risk_level == 2 && datalogged) {
            for (int i=0; i<10; i=i+2) {
                speaker.period(1.0/969.0);
                speaker = float(i)/50.0;
                wait(.8);
                speaker.period(1.0/800.0);
                wait(.8);
                speaker = 0;
            }
        } else if(risk_level == 3 && datalogged) {
            for (int i=0; i<26; i=i+2) {
                speaker.period(1.0/969.0);
                speaker = float(i)/50.0;
                wait(.25);
                speaker.period(1.0/800.0);
                wait(.25);
                speaker = 0;
            }
        } else if(risk_level <= 1 && datalogged) {
            speaker = 0;
        } else {
            speaker = 0;
        }
    }
}


void log_sd_card()
{
    while(1) {
        mutex_lock.lock();
        FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
        if(fp == NULL) {
            error("Could not open file for write\n");
        }
        int curr_time = (int)ctime(&seconds) % 86400;
        int curr_hour = curr_time / 3600;
        int curr_min = curr_time / 60;
        int curr_sec = curr_time % 60;


        fprintf(fp, "Date & time: Tuesday 28, April 2020 ");
        fprintf(fp, "%i", curr_hour);
        fprintf(fp, ":");
        fprintf(fp, "%i", curr_min);
        fprintf(fp, ":");
        fprintf(fp, "%i", curr_sec);
        fprintf(fp, "\n");
        fprintf(fp, "Risk Level: ");
        fprintf(fp, "%i", risk_level);
        fprintf(fp, "\n");
        for (int i = 0; i < 15; i++) {
            fprintf(fp, "%i", RSSI_array[i]);
            if (i < 14) {
                fprintf(fp, ", ");
            }
        }
        fprintf(fp, "\n\n");
        fclose(fp);
        mutex_lock.unlock();
    }
}



void blink_leds()
{
    while(1) {
        if(risk_level <= 1 && datalogged) {
            greenLED = 1;
            redLED = 0;
            yellowLED = 0;
        } else if(risk_level == 2 && datalogged) {
            yellowLED = 1;
            greenLED = 0;
            redLED = 0;
        } else if(risk_level == 3 && datalogged) {
            redLED = 1;
            yellowLED = 0;
            greenLED = 0;
        } else {
            redLED = 0;
            yellowLED = 0;
            greenLED = 0;
        }
    }
}

void display_ulcd()
{
    mutex_lock.lock();
    uLCD.color(WHITE);
    mutex_lock.unlock();
    while(1) {
        mutex_lock.lock();
        if(risk_level <= 1 && datalogged) {
            mutex_lock.lock();
            uLCD.cls();
            uLCD.locate(5, 7);
            uLCD.text_width(2);
            uLCD.text_height(2);
            uLCD.background_color(GREEN);
            uLCD.textbackground_color(GREEN);
            uLCD.printf("Safe");
            mutex_lock.unlock();
        } else if(risk_level == 2 && datalogged) {
            mutex_lock.lock();
            uLCD.cls();
            uLCD.locate(1, 7);
            uLCD.text_width(2);
            uLCD.text_height(2);
            uLCD.background_color(0xFFFF00);
            uLCD.textbackground_color(0xFFFF00);
            uLCD.printf("Cautious");
            mutex_lock.unlock();
        } else if(risk_level == 3 && datalogged) {
            mutex_lock.lock();
            uLCD.cls();
            uLCD.locate(3, 7);
            uLCD.text_width(2);
            uLCD.text_height(2);
            uLCD.background_color(RED);
            uLCD.textbackground_color(RED);
            uLCD.printf("Hazard");
            mutex_lock.unlock();
        }
        mutex_lock.unlock();
    }
}

int main()
{
    cmdstuff = 1;
    at.send("AT") && at.recv("OK");
    at.send("AT+AB ChangeDefaultBaud [9600]", 3) && at.recv("OK");
    pc.baud(9600);
    ble.baud(9600);

    Thread SD_Thread();
    Thread ULCD_Thread(display_ulcd);
    Thread LED_Thread(blink_leds);
    Thread Speaker_Thread(speaker_alarm);

    while(1) {
        parse_RSSI();
    }
}